/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.dictionary.impl.section;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.rdfhdt.hdt.dictionary.DictionarySectionPrivate;
import org.rdfhdt.hdt.dictionary.TempDictionarySection;
import org.rdfhdt.hdt.listener.ProgressListener;

public class DictionarySectionCachePerThread
implements DictionarySectionPrivate {
    final int CACHE_ENTRIES = 128;
    private final DictionarySectionPrivate child;
    private ThreadLocal<Map<CharSequence, Long>> cacheString = new ThreadLocal<Map<CharSequence, Long>>(){

        @Override
        protected Map<CharSequence, Long> initialValue() {
            return new LinkedHashMap<CharSequence, Long>(129, 0.75f, true){

                @Override
                public boolean removeEldestEntry(Map.Entry<CharSequence, Long> eldest) {
                    return this.size() > 128;
                }
            };
        }
    };
    private ThreadLocal<Map<Long, CharSequence>> cacheID = new ThreadLocal<Map<Long, CharSequence>>(){

        @Override
        protected Map<Long, CharSequence> initialValue() {
            return new LinkedHashMap<Long, CharSequence>(129, 0.75f, true){

                @Override
                public boolean removeEldestEntry(Map.Entry<Long, CharSequence> eldest) {
                    return this.size() > 128;
                }
            };
        }
    };

    public DictionarySectionCachePerThread(DictionarySectionPrivate child) {
        this.child = child;
    }

    public long locate(CharSequence s) {
        Map<CharSequence, Long> map = this.cacheString.get();
        Long o = map.get(s);
        if (o == null) {
            o = this.child.locate(s);
            map.put(s, o);
        }
        return o;
    }

    public CharSequence extract(long pos) {
        Map<Long, CharSequence> map = this.cacheID.get();
        CharSequence o = map.get(pos);
        if (o == null) {
            o = this.child.extract(pos);
            map.put(pos, o);
        }
        return o;
    }

    public long size() {
        return this.child.size();
    }

    public long getNumberOfElements() {
        return this.child.getNumberOfElements();
    }

    public Iterator<? extends CharSequence> getSortedEntries() {
        return this.child.getSortedEntries();
    }

    @Override
    public void save(OutputStream output, ProgressListener listener) throws IOException {
        this.child.save(output, listener);
    }

    @Override
    public void load(InputStream input, ProgressListener listener) throws IOException {
        this.child.load(input, listener);
    }

    @Override
    public void load(TempDictionarySection other, ProgressListener listener) {
        this.child.load(other, listener);
    }

    public void close() throws IOException {
        this.cacheString = null;
        this.cacheID = null;
        this.child.close();
    }
}

