/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.dictionary.impl;

import java.util.Iterator;
import org.rdfhdt.hdt.dictionary.TempDictionary;
import org.rdfhdt.hdt.dictionary.TempDictionarySection;
import org.rdfhdt.hdt.enums.DictionarySectionRole;
import org.rdfhdt.hdt.enums.TripleComponentRole;
import org.rdfhdt.hdt.exceptions.NotImplementedException;
import org.rdfhdt.hdt.options.HDTOptions;
import org.rdfhdt.hdt.triples.TempTriples;

public abstract class BaseTempDictionary
implements TempDictionary {
    final HDTOptions spec;
    protected boolean isOrganized;
    protected TempDictionarySection subjects;
    protected TempDictionarySection predicates;
    protected TempDictionarySection objects;
    protected TempDictionarySection shared;

    public BaseTempDictionary(HDTOptions spec) {
        this.spec = spec;
    }

    @Override
    public long insert(CharSequence str, TripleComponentRole position) {
        switch (position) {
            case SUBJECT: {
                this.isOrganized = false;
                return this.subjects.add(str);
            }
            case PREDICATE: {
                this.isOrganized = false;
                return this.predicates.add(str);
            }
            case OBJECT: {
                this.isOrganized = false;
                return this.objects.add(str);
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void reorganize() {
        Iterator<? extends CharSequence> itSubj = this.subjects.getEntries();
        while (itSubj.hasNext()) {
            CharSequence str = itSubj.next();
            if (str.length() <= 0 || str.charAt(0) == '\"' || this.objects.locate(str) == 0L) continue;
            this.shared.add(str);
        }
        Iterator<? extends CharSequence> itShared = this.shared.getEntries();
        while (itShared.hasNext()) {
            CharSequence sharedStr = itShared.next();
            this.subjects.remove(sharedStr);
            this.objects.remove(sharedStr);
        }
        this.shared.sort();
        this.subjects.sort();
        this.objects.sort();
        this.predicates.sort();
        this.isOrganized = true;
    }

    @Override
    public void reorganize(TempTriples triples) {
        throw new NotImplementedException();
    }

    @Override
    public boolean isOrganized() {
        return this.isOrganized;
    }

    @Override
    public void clear() {
        this.subjects.clear();
        this.predicates.clear();
        this.shared.clear();
        this.objects.clear();
    }

    @Override
    public TempDictionarySection getSubjects() {
        return this.subjects;
    }

    @Override
    public TempDictionarySection getPredicates() {
        return this.predicates;
    }

    @Override
    public TempDictionarySection getObjects() {
        return this.objects;
    }

    @Override
    public TempDictionarySection getShared() {
        return this.shared;
    }

    protected long getGlobalId(long id, DictionarySectionRole position) {
        switch (position) {
            case SUBJECT: 
            case OBJECT: {
                return this.shared.getNumberOfElements() + id;
            }
            case PREDICATE: 
            case SHARED: {
                return id;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public long stringToId(CharSequence str, TripleComponentRole position) {
        if (str == null || str.length() == 0) {
            return 0L;
        }
        long ret = 0L;
        switch (position) {
            case SUBJECT: {
                ret = this.shared.locate(str);
                if (ret != 0L) {
                    return this.getGlobalId(ret, DictionarySectionRole.SHARED);
                }
                ret = this.subjects.locate(str);
                if (ret != 0L) {
                    return this.getGlobalId(ret, DictionarySectionRole.SUBJECT);
                }
                return -1L;
            }
            case PREDICATE: {
                ret = this.predicates.locate(str);
                if (ret != 0L) {
                    return this.getGlobalId(ret, DictionarySectionRole.PREDICATE);
                }
                return -1L;
            }
            case OBJECT: {
                ret = this.shared.locate(str);
                if (ret != 0L) {
                    return this.getGlobalId(ret, DictionarySectionRole.SHARED);
                }
                ret = this.objects.locate(str);
                if (ret != 0L) {
                    return this.getGlobalId(ret, DictionarySectionRole.OBJECT);
                }
                return -1L;
            }
        }
        throw new IllegalArgumentException();
    }
}

