/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.compact.sequence;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.zip.InflaterInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeflateIntegerIterator
implements Iterator<Integer> {
    private static final Logger log = LoggerFactory.getLogger(DeflateIntegerIterator.class);
    protected final List<byte[]> buffer;
    protected DataInputStream stream;
    int current;
    int next;

    public DeflateIntegerIterator(List<byte[]> buffer) {
        this.buffer = buffer;
    }

    public void reset(long list) {
        byte[] buf = this.buffer.get((int)list);
        try {
            this.stream = new DataInputStream(new InflaterInputStream(new ByteArrayInputStream(buf)));
            try {
                this.current = this.stream.readInt();
                System.out.println("First: " + this.current);
                if (this.current == -1) {
                    return;
                }
            }
            catch (IOException e) {
                this.current = -1;
            }
            try {
                int val = this.stream.readInt();
                System.out.println("Second: " + val);
                this.next = val != -1 ? this.current + val : -1;
            }
            catch (IOException e) {
                this.next = -1;
            }
        }
        catch (Exception e1) {
            log.error("Unexpected exception.", (Throwable)e1);
        }
    }

    @Override
    public boolean hasNext() {
        return this.current != -1;
    }

    @Override
    public Integer next() {
        int aux = this.current;
        this.current = this.next;
        try {
            int val = this.stream.readInt();
            this.next = val != -1 ? this.current + val : -1;
        }
        catch (IOException e) {
            this.next = -1;
        }
        return aux;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

