/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.tools;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.internal.Lists;
import java.io.IOException;
import java.util.List;
import org.rdfhdt.hdt.enums.RDFNotation;
import org.rdfhdt.hdt.exceptions.ParserException;
import org.rdfhdt.hdt.hdt.HDT;
import org.rdfhdt.hdt.hdt.HDTManager;
import org.rdfhdt.hdt.hdt.HDTVersion;
import org.rdfhdt.hdt.listener.ProgressListener;
import org.rdfhdt.hdt.options.HDTOptions;
import org.rdfhdt.hdt.options.HDTSpecification;
import org.rdfhdt.hdt.util.StopWatch;

public class RDF2HDT
implements ProgressListener {
    public String rdfInput;
    public String hdtOutput;
    @Parameter(description="<input RDF> <output HDT>")
    public List<String> parameters = Lists.newArrayList();
    @Parameter(names={"-options"}, description="HDT Conversion options (override those of config file)")
    public String options;
    @Parameter(names={"-config"}, description="Conversion config file")
    public String configFile;
    @Parameter(names={"-rdftype"}, description="Type of RDF Input (ntriples, nquad, n3, turtle, rdfxml)")
    public String rdfType;
    @Parameter(names={"-version"}, description="Prints the HDT version number")
    public static boolean showVersion;
    @Parameter(names={"-base"}, description="Base URI for the dataset")
    public String baseURI;
    @Parameter(names={"-index"}, description="Generate also external indices to solve all queries")
    public boolean generateIndex;
    @Parameter(names={"-quiet"}, description="Do not show progress of the conversion")
    public boolean quiet;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws ParserException, IOException {
        HDTSpecification spec = this.configFile != null ? new HDTSpecification(this.configFile) : new HDTSpecification();
        if (this.options != null) {
            spec.setOptions(this.options);
        }
        if (this.baseURI == null) {
            this.baseURI = "file://" + this.rdfInput;
        }
        RDFNotation notation = null;
        if (this.rdfType != null) {
            try {
                notation = RDFNotation.parse((String)this.rdfType);
            }
            catch (IllegalArgumentException e) {
                System.out.println("Notation " + this.rdfType + " not recognised.");
            }
        }
        if (notation == null) {
            try {
                notation = RDFNotation.guess((String)this.rdfInput);
            }
            catch (IllegalArgumentException e) {
                System.out.println("Could not guess notation for " + this.rdfInput + " Trying NTriples");
                notation = RDFNotation.NTRIPLES;
            }
        }
        try (HDT hdt = HDTManager.generateHDT((String)this.rdfInput, (String)this.baseURI, (RDFNotation)notation, (HDTOptions)spec, (ProgressListener)this);){
            if (!this.quiet) {
                System.out.println("Total Triples: " + hdt.getTriples().getNumberOfElements());
                System.out.println("Different subjects: " + hdt.getDictionary().getNsubjects());
                System.out.println("Different predicates: " + hdt.getDictionary().getNpredicates());
                System.out.println("Different objects: " + hdt.getDictionary().getNobjects());
                System.out.println("Common Subject/Object:" + hdt.getDictionary().getNshared());
            }
            StopWatch sw = new StopWatch();
            hdt.saveToHDT(this.hdtOutput, (ProgressListener)this);
            System.out.println("HDT saved to file in: " + sw.stopAndShow());
            sw.reset();
            if (this.generateIndex) {
                hdt = HDTManager.indexedHDT((HDT)hdt, (ProgressListener)this);
                System.out.println("Index generated and saved in: " + sw.stopAndShow());
            }
        }
    }

    public void notifyProgress(float level, String message) {
        if (!this.quiet) {
            System.out.print("\r" + message + "\t" + Float.toString(level) + "                            \r");
        }
    }

    public static void main(String[] args) throws Throwable {
        RDF2HDT rdf2hdt = new RDF2HDT();
        JCommander com = new JCommander((Object)rdf2hdt, args);
        com.setProgramName("rdf2hdt");
        if (rdf2hdt.parameters.size() == 1) {
            System.err.println("No input file specified, reading from standard input.");
            rdf2hdt.rdfInput = "-";
            rdf2hdt.hdtOutput = rdf2hdt.parameters.get(0);
        } else if (rdf2hdt.parameters.size() == 2) {
            rdf2hdt.rdfInput = rdf2hdt.parameters.get(0);
            rdf2hdt.hdtOutput = rdf2hdt.parameters.get(1);
        } else if (showVersion) {
            System.out.println(HDTVersion.get_version_string((String)"."));
            System.exit(0);
        } else {
            com.usage();
            System.exit(1);
        }
        System.out.println("Converting " + rdf2hdt.rdfInput + " to " + rdf2hdt.hdtOutput + " as " + rdf2hdt.rdfType);
        rdf2hdt.execute();
    }
}

