/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.tools;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.internal.Lists;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import org.rdfhdt.hdt.exceptions.NotFoundException;
import org.rdfhdt.hdt.exceptions.ParserException;
import org.rdfhdt.hdt.hdt.HDT;
import org.rdfhdt.hdt.hdt.HDTManager;
import org.rdfhdt.hdt.hdt.HDTVersion;
import org.rdfhdt.hdt.listener.ProgressListener;
import org.rdfhdt.hdt.triples.IteratorTripleString;
import org.rdfhdt.hdt.triples.TripleString;
import org.rdfhdt.hdt.util.StopWatch;
import org.rdfhdt.hdt.util.UnicodeEscape;

public class HdtSearch
implements ProgressListener {
    @Parameter(description="<HDT File>")
    public List<String> parameters = Lists.newArrayList();
    @Parameter(names={"-version"}, description="Prints the HDT version number")
    public static boolean showVersion;
    public String hdtInput;
    @Parameter(names={"-memory"}, description="Load the whole file into main memory. Ensures fastest querying.")
    public boolean loadInMemory;

    protected static void iterate(HDT hdt, CharSequence subject, CharSequence predicate, CharSequence object) throws NotFoundException {
        StopWatch iterateTime = new StopWatch();
        int count = 0;
        subject = subject.length() == 1 && subject.charAt(0) == '?' ? "" : subject;
        predicate = predicate.length() == 1 && predicate.charAt(0) == '?' ? "" : predicate;
        object = object.length() == 1 && object.charAt(0) == '?' ? "" : object;
        IteratorTripleString it = hdt.search(subject, predicate, object);
        count = 0;
        while (it.hasNext()) {
            TripleString triple = (TripleString)it.next();
            System.out.println(triple);
            ++count;
        }
        System.out.println("Iterated " + count + " triples in " + iterateTime.stopAndShow());
    }

    private void help() {
        System.out.println("HELP:");
        System.out.println("Please write Triple Search Pattern, using '?' for wildcards. e.g ");
        System.out.println("   http://www.somewhere.com/mysubject ? ?");
        System.out.println("Use 'exit' or 'quit' to terminate interactive shell.");
    }

    private static void parseTriplePattern(TripleString dest, String line) throws ParserException {
        int split;
        dest.clear();
        int posa = 0;
        int posb = split = line.indexOf(32, posa);
        if (posb == -1) {
            throw new ParserException("Make sure that you included three terms.");
        }
        dest.setSubject((CharSequence)line.substring(posa, posb));
        posa = split + 1;
        posb = split = line.indexOf(32, posa);
        if (posb == -1) {
            throw new ParserException("Make sure that you included three terms.");
        }
        dest.setPredicate((CharSequence)line.substring(posa, posb));
        posa = split + 1;
        posb = line.length();
        if (line.charAt(posb - 1) == '.') {
            --posb;
        }
        if (line.charAt(posb - 1) == ' ') {
            --posb;
        }
        dest.setObject((CharSequence)UnicodeEscape.unescapeString((String)line.substring(posa, posb)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws IOException {
        HDT hdt = this.loadInMemory ? HDTManager.loadIndexedHDT((String)this.hdtInput, (ProgressListener)this) : HDTManager.mapIndexedHDT((String)this.hdtInput, (ProgressListener)this);
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        try {
            TripleString triplePattern = new TripleString();
            while (true) {
                System.out.print(">> ");
                System.out.flush();
                String line = in.readLine();
                if (line == null || line.equals("exit")) break;
                if (line.equals("quit")) {
                    break;
                }
                if (line.equals("help")) {
                    this.help();
                    continue;
                }
                try {
                    HdtSearch.parseTriplePattern(triplePattern, line);
                    System.out.println("Query: |" + triplePattern.getSubject() + "| |" + triplePattern.getPredicate() + "| |" + triplePattern.getObject() + "|");
                    HdtSearch.iterate(hdt, triplePattern.getSubject(), triplePattern.getPredicate(), triplePattern.getObject());
                }
                catch (ParserException e) {
                    System.err.println("Could not parse triple pattern: " + e.getMessage());
                    this.help();
                }
                catch (NotFoundException e) {
                    System.err.println("No results found.");
                }
            }
        }
        finally {
            if (hdt != null) {
                hdt.close();
            }
            in.close();
        }
    }

    public void notifyProgress(float level, String message) {
    }

    public static void main(String[] args) throws Throwable {
        HdtSearch hdtSearch = new HdtSearch();
        JCommander com = new JCommander((Object)hdtSearch, args);
        com.setProgramName("hdtSearch");
        if (showVersion) {
            System.out.println(HDTVersion.get_version_string((String)"."));
            System.exit(0);
        }
        if (hdtSearch.parameters.size() != 1) {
            com.usage();
            System.exit(1);
        }
        hdtSearch.hdtInput = hdtSearch.parameters.get(0);
        hdtSearch.execute();
    }
}

