/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.tools;

import java.util.Comparator;
import java.util.Iterator;
import org.rdfhdt.hdt.hdt.HDT;
import org.rdfhdt.hdt.hdt.HDTManager;
import org.rdfhdt.hdt.util.string.CharSequenceComparator;
import org.rdfhdt.hdt.util.string.CompactString;

public class HDTVerify {
    private static Comparator<CharSequence> comparator = CharSequenceComparator.getInstance();

    private HDTVerify() {
    }

    private static void print(byte[] arr) {
        for (int i = 0; i < arr.length; ++i) {
            byte b = arr[i];
            System.out.print(String.format("%02X ", b));
        }
        System.out.println();
    }

    private static void print(CharSequence seq) {
        if (seq instanceof CompactString) {
            CompactString cs1 = (CompactString)seq;
            HDTVerify.print(cs1.getData());
        }
        if (seq instanceof String) {
            String rs1 = (String)seq;
            HDTVerify.print(rs1.getBytes());
        }
    }

    public static void checkDictionarySectionOrder(Iterator<? extends CharSequence> it) {
        CharSequence lastCharseq = null;
        String lastStr = null;
        int cmp = 0;
        int cmp2 = 0;
        while (it.hasNext()) {
            CharSequence charSeq = it.next();
            String str = charSeq.toString();
            if (lastCharseq != null && (cmp = comparator.compare(lastCharseq, charSeq)) > 0) {
                System.out.println("ERRA: " + lastCharseq + " / " + charSeq);
            }
            if (lastStr != null && (cmp2 = lastStr.compareTo(str)) > 0) {
                System.out.println("ERRB: " + lastStr + " / " + str);
            }
            if (Math.signum(cmp) != Math.signum(cmp2)) {
                System.out.println("Not equal: " + cmp + " / " + cmp2);
                HDTVerify.print(lastCharseq);
                HDTVerify.print(charSeq);
                HDTVerify.print(lastStr);
                HDTVerify.print(str);
            }
            lastCharseq = charSeq;
            lastStr = str;
        }
    }

    public static void main(String[] args) throws Throwable {
        if (args.length < 1) {
            System.out.println("hdtVerify <file.hdt>");
            System.exit(-1);
        }
        HDT hdt = HDTManager.mapHDT((String)args[0], null);
        HDTVerify.checkDictionarySectionOrder(hdt.getDictionary().getSubjects().getSortedEntries());
        HDTVerify.checkDictionarySectionOrder(hdt.getDictionary().getPredicates().getSortedEntries());
        HDTVerify.checkDictionarySectionOrder(hdt.getDictionary().getObjects().getSortedEntries());
        HDTVerify.checkDictionarySectionOrder(hdt.getDictionary().getShared().getSortedEntries());
    }
}

