/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.tools;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.internal.Lists;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.zip.GZIPInputStream;
import org.rdfhdt.hdt.exceptions.ParserException;
import org.rdfhdt.hdt.hdt.HDTVersion;
import org.rdfhdt.hdt.options.ControlInformation;
import org.rdfhdt.hdt.util.io.IOUtil;

public class HDTInfo {
    @Parameter(description="<HDT File>")
    public List<String> parameters = Lists.newArrayList();
    @Parameter(names={"-version"}, description="Prints the HDT version number")
    public static boolean showVersion;
    public String hdtInput;

    public void execute() throws ParserException, IOException {
        FilterInputStream input = this.hdtInput.endsWith(".gz") ? new GZIPInputStream(new FileInputStream(this.hdtInput)) : new BufferedInputStream(new FileInputStream(this.hdtInput));
        ControlInformation ci = new ControlInformation();
        ci.load((InputStream)input);
        ci.load((InputStream)input);
        int headerSize = (int)ci.getInt("length");
        byte[] headerData = IOUtil.readBuffer((InputStream)input, (int)headerSize, null);
        ((InputStream)input).close();
        System.out.write(headerData);
        ((InputStream)input).close();
    }

    public static void main(String[] args) throws Throwable {
        HDTInfo hdtInfo = new HDTInfo();
        JCommander com = new JCommander((Object)hdtInfo, args);
        com.setProgramName("hdtInfo");
        if (showVersion) {
            System.out.println(HDTVersion.get_version_string((String)"."));
            System.exit(0);
        }
        try {
            if (hdtInfo.hdtInput == null) {
                hdtInfo.hdtInput = hdtInfo.parameters.get(0);
            }
        }
        catch (Exception e) {
            com.usage();
            System.exit(1);
        }
        hdtInfo.execute();
    }
}

