package eu.vendeli.tgbot.types.internal.options

import eu.vendeli.tgbot.types.MessageEntity
import eu.vendeli.tgbot.types.ParseMode
import eu.vendeli.tgbot.types.PollType
import eu.vendeli.tgbot.types.ReplyParameters
import eu.vendeli.tgbot.utils.serde.DurationSerializer
import eu.vendeli.tgbot.utils.serde.InstantSerializer
import kotlinx.datetime.Instant
import kotlinx.serialization.Serializable
import kotlin.time.Duration
@Serializable
data class PollOptions(
    var isAnonymous: Boolean? = null,
    var type: PollType? = null,
    var allowsMultipleAnswers: Boolean? = null,
    var correctOptionId: Int? = null,
    var explanation: String? = null,
    var explanationParseMode: ParseMode? = null,
    var explanationEntities: List<MessageEntity>? = null,
    @Serializable(DurationSerializer::class)
    var openPeriod: Duration? = null,
    @Serializable(InstantSerializer::class)
    var closeDate: Instant? = null,
    var isClosed: Boolean? = null,
    override var disableNotification: Boolean? = null,
    override var replyParameters: ReplyParameters? = null,
    override var protectContent: Boolean? = null,
    override var messageThreadId: Int? = null,
) : OptionsCommon
