package eu.vendeli.tgbot.types

import kotlinx.serialization.Serializable

/**
 * This object represents a phone contact.
 * @property phoneNumber Contact's phone number
 * @property firstName Contact's first name
 * @property lastName Optional. Contact's last name
 * @property userId Optional. Contact's user identifier in Telegram. This number may have more than 32 significant bits and some programming languages may have difficulty/silent defects in interpreting it. But it has at most 52 significant bits, so a 64-bit integer or double-precision float type are safe for storing this identifier.
 * @property vcard Optional. Additional data about the contact in the form of a vCard
 * Api reference: https://core.telegram.org/bots/api#contact
*/
@Serializable
data class Contact(
    val phoneNumber: String,
    val firstName: String,
    val lastName: String? = null,
    val userId: Long? = null,
    val vcard: String? = null,
)
