@file:Suppress("MatchingDeclarationName")

package eu.vendeli.tgbot.api.chat

import eu.vendeli.tgbot.interfaces.Action
import eu.vendeli.tgbot.types.User
import eu.vendeli.tgbot.types.chat.ChatMember
import eu.vendeli.tgbot.types.internal.TgMethod
import eu.vendeli.tgbot.utils.getReturnType
import eu.vendeli.tgbot.utils.toJsonElement

class GetChatMemberAction(userId: Long) : Action<ChatMember>() {
    override val method = TgMethod("getChatMember")
    override val returnType = getReturnType()

    init {
        parameters["user_id"] = userId.toJsonElement()
    }
}

/**
 * Use this method to get information about a member of a chat. The method is only guaranteed to work for other users if the bot is an administrator in the chat. Returns a ChatMember object on success.
 * Api reference: https://core.telegram.org/bots/api#getchatmember
 * @param chatId Unique identifier for the target chat or username of the target supergroup or channel (in the format @channelusername)
 * @param userId Unique identifier of the target user
 * @returns [ChatMember]
*/
@Suppress("NOTHING_TO_INLINE")
inline fun getChatMember(userId: Long) = GetChatMemberAction(userId)

@Suppress("NOTHING_TO_INLINE")
inline fun getChatMember(user: User) = getChatMember(user.id)
