/*
 * Decompiled with CFR 0.152.
 */
package eu.vaadinonkotlin.vaadin8;

import com.github.mvysny.karibudsl.v8.GridKt;
import com.github.mvysny.karibudsl.v8.Size;
import com.github.mvysny.karibudsl.v8.SizeKt;
import com.vaadin.data.BeanPropertySet;
import com.vaadin.data.HasValue;
import com.vaadin.data.PropertyDefinition;
import com.vaadin.data.provider.ConfigurableFilterDataProvider;
import com.vaadin.data.provider.DataProvider;
import com.vaadin.server.SerializableConsumer;
import com.vaadin.server.Sizeable;
import com.vaadin.shared.ui.ValueChangeMode;
import com.vaadin.ui.Component;
import com.vaadin.ui.Grid;
import com.vaadin.ui.HasValueChangeMode;
import com.vaadin.ui.components.grid.HeaderCell;
import com.vaadin.ui.components.grid.HeaderRow;
import eu.vaadinonkotlin.FilterFactory;
import eu.vaadinonkotlin.Listeners;
import eu.vaadinonkotlin.vaadin8.FilterBinder;
import eu.vaadinonkotlin.vaadin8.FilterFieldFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KProperty1;
import kotlin.streams.jdk8.StreamsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\u00020\u0004B\u0093\u0001\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\f\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00010\u000e\u0012F\b\u0002\u0010\u000f\u001a@\u0012\u0017\u0012\u0015\u0012\u0002\b\u00030\u0011\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0014\u0012\u001d\u0012\u001b\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u00030\u0015\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0016\u0012\u0004\u0012\u00020\u00170\u0010\u00a2\u0006\u0002\u0010\u0018J\u0006\u0010,\u001a\u00020\u0017J&\u0010-\u001a\u00020\u00172\n\u0010.\u001a\u0006\u0012\u0002\b\u00030\u00112\u0010\u0010\u0016\u001a\f\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u00030\u0015H\u0002J\u0010\u0010/\u001a\u00020\u00172\b\b\u0002\u00100\u001a\u000201J \u00102\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00112\u0010\u0010\u0016\u001a\f\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u000303J\u0006\u00104\u001a\u00020\u0017R\u001d\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cRL\u0010\u000f\u001a@\u0012\u0017\u0012\u0015\u0012\u0002\b\u00030\u0011\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0014\u0012\u001d\u0012\u001b\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u00030\u0015\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0016\u0012\u0004\u0012\u00020\u00170\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u001d\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u001f\u0010'\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00018\u00010)0(8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010+\u00a8\u00065"}, d2={"Leu/vaadinonkotlin/vaadin8/FilterRow;", "T", "", "F", "Ljava/io/Serializable;", "grid", "Lcom/vaadin/ui/Grid;", "itemClass", "Ljava/lang/Class;", "headerRow", "Lcom/vaadin/ui/components/grid/HeaderRow;", "filterFieldFactory", "Leu/vaadinonkotlin/vaadin8/FilterFieldFactory;", "filterFactory", "Leu/vaadinonkotlin/FilterFactory;", "componentConfigurator", "Lkotlin/Function2;", "Lcom/vaadin/data/HasValue;", "Lkotlin/ParameterName;", "name", "filterComponent", "Lcom/vaadin/data/PropertyDefinition;", "property", "", "(Lcom/vaadin/ui/Grid;Ljava/lang/Class;Lcom/vaadin/ui/components/grid/HeaderRow;Leu/vaadinonkotlin/vaadin8/FilterFieldFactory;Leu/vaadinonkotlin/FilterFactory;Lkotlin/jvm/functions/Function2;)V", "binder", "Leu/vaadinonkotlin/vaadin8/FilterBinder;", "getBinder", "()Leu/vaadinonkotlin/vaadin8/FilterBinder;", "getFilterFactory", "()Leu/vaadinonkotlin/FilterFactory;", "getFilterFieldFactory", "()Leu/vaadinonkotlin/vaadin8/FilterFieldFactory;", "getGrid", "()Lcom/vaadin/ui/Grid;", "getHeaderRow", "()Lcom/vaadin/ui/components/grid/HeaderRow;", "getItemClass", "()Ljava/lang/Class;", "onFilterChangeListeners", "Leu/vaadinonkotlin/Listeners;", "Lcom/vaadin/server/SerializableConsumer;", "getOnFilterChangeListeners", "()Leu/vaadinonkotlin/Listeners;", "clear", "configureField", "field", "generateFilterComponents", "valueChangeMode", "Lcom/vaadin/shared/ui/ValueChangeMode;", "getFilterComponent", "Lkotlin/reflect/KProperty1;", "remove", "vok-util-vaadin8"})
public final class FilterRow<T, F>
implements Serializable {
    @NotNull
    private final Grid<T> grid;
    @NotNull
    private final Class<T> itemClass;
    @NotNull
    private final HeaderRow headerRow;
    @NotNull
    private final FilterFieldFactory<T, F> filterFieldFactory;
    @NotNull
    private final FilterFactory<F> filterFactory;
    @NotNull
    private final Function2<HasValue<?>, PropertyDefinition<T, ?>, Unit> componentConfigurator;
    @NotNull
    private final FilterBinder<T, F> binder;

    public FilterRow(@NotNull Grid<T> grid, @NotNull Class<T> itemClass, @NotNull HeaderRow headerRow, @NotNull FilterFieldFactory<T, F> filterFieldFactory, @NotNull FilterFactory<F> filterFactory, @NotNull Function2<? super HasValue<?>, ? super PropertyDefinition<T, ?>, Unit> componentConfigurator) {
        Intrinsics.checkNotNullParameter(grid, (String)"grid");
        Intrinsics.checkNotNullParameter(itemClass, (String)"itemClass");
        Intrinsics.checkNotNullParameter((Object)headerRow, (String)"headerRow");
        Intrinsics.checkNotNullParameter(filterFieldFactory, (String)"filterFieldFactory");
        Intrinsics.checkNotNullParameter(filterFactory, (String)"filterFactory");
        Intrinsics.checkNotNullParameter(componentConfigurator, (String)"componentConfigurator");
        this.grid = grid;
        this.itemClass = itemClass;
        this.headerRow = headerRow;
        this.filterFieldFactory = filterFieldFactory;
        this.filterFactory = filterFactory;
        this.componentConfigurator = componentConfigurator;
        this.binder = new FilterBinder<T, F>(this.filterFieldFactory, this.filterFactory);
        this.binder.getOnFilterChangeListeners().add((Serializable)new SerializableConsumer(){

            public final void accept(@Nullable F filter) {
                DataProvider dataProvider = this.getGrid().getDataProvider();
                if (dataProvider == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.vaadin.data.provider.ConfigurableFilterDataProvider<T of eu.vaadinonkotlin.vaadin8.FilterRow, F of eu.vaadinonkotlin.vaadin8.FilterRow, F of eu.vaadinonkotlin.vaadin8.FilterRow>");
                }
                ((ConfigurableFilterDataProvider)dataProvider).setFilter(filter);
            }
        });
    }

    public /* synthetic */ FilterRow(Grid grid, Class clazz, HeaderRow headerRow, FilterFieldFactory filterFieldFactory, FilterFactory filterFactory, Function2 function2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            function2 = 1.INSTANCE;
        }
        this(grid, clazz, headerRow, filterFieldFactory, filterFactory, function2);
    }

    @NotNull
    public final Grid<T> getGrid() {
        return this.grid;
    }

    @NotNull
    public final Class<T> getItemClass() {
        return this.itemClass;
    }

    @NotNull
    public final HeaderRow getHeaderRow() {
        return this.headerRow;
    }

    @NotNull
    public final FilterFieldFactory<T, F> getFilterFieldFactory() {
        return this.filterFieldFactory;
    }

    @NotNull
    public final FilterFactory<F> getFilterFactory() {
        return this.filterFactory;
    }

    @NotNull
    public final FilterBinder<T, F> getBinder() {
        return this.binder;
    }

    @NotNull
    public final Listeners<SerializableConsumer<F>> getOnFilterChangeListeners() {
        return this.binder.getOnFilterChangeListeners();
    }

    /*
     * WARNING - void declaration
     */
    public final void generateFilterComponents(@NotNull ValueChangeMode valueChangeMode) {
        void $this$mapNotNullTo$iv$iv;
        Object object;
        Iterable $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)valueChangeMode, (String)"valueChangeMode");
        this.clear();
        Stream stream = BeanPropertySet.get(this.itemClass).getProperties();
        Intrinsics.checkNotNullExpressionValue((Object)stream, (String)"get(itemClass).properties");
        Iterable $this$associateBy$iv = StreamsKt.toList((Stream)stream);
        boolean $i$f$associateBy22 = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Object destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            object = (PropertyDefinition)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            String string = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
            String string2 = string;
            map.put(string2, element$iv$iv);
        }
        Map properties = destination$iv$iv;
        List $i$f$associateBy22 = this.grid.getColumns();
        Intrinsics.checkNotNullExpressionValue((Object)$i$f$associateBy22, (String)"grid.columns");
        Iterable $this$mapNotNull$iv = $i$f$associateBy22;
        boolean $i$f$mapNotNull = false;
        $this$associateByTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        object = $this$forEach$iv$iv$iv.iterator();
        while (object.hasNext()) {
            String string;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = object.next();
            boolean bl = false;
            Grid.Column it = (Grid.Column)element$iv$iv;
            boolean bl2 = false;
            if (it.getId() == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            String it$iv$iv = string;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        for (String propertyId : (List)destination$iv$iv) {
            PropertyDefinition property = (PropertyDefinition)properties.get(propertyId);
            HasValue field = property == null ? null : this.filterFieldFactory.createField(property);
            Object object2 = destination$iv$iv = field instanceof HasValueChangeMode ? (HasValueChangeMode)field : null;
            if (destination$iv$iv != null) {
                destination$iv$iv.setValueChangeMode(valueChangeMode);
            }
            HeaderCell cell = this.headerRow.getCell(propertyId);
            if (field == null) continue;
            PropertyDefinition propertyDefinition = property;
            Intrinsics.checkNotNull((Object)propertyDefinition);
            this.binder.bind(field, propertyDefinition);
            cell.setComponent((Component)field);
        }
    }

    public static /* synthetic */ void generateFilterComponents$default(FilterRow filterRow, ValueChangeMode valueChangeMode, int n, Object object) {
        if ((n & 1) != 0) {
            valueChangeMode = ValueChangeMode.LAZY;
        }
        filterRow.generateFilterComponents(valueChangeMode);
    }

    private final void configureField(HasValue<?> field, PropertyDefinition<T, ?> property) {
        SizeKt.setW((Sizeable)((Sizeable)((Component)field)), (Size)SizeKt.getFillParent());
        this.componentConfigurator.invoke(field, property);
    }

    public final void clear() {
        this.binder.unbindAll();
        List list = this.grid.getColumns();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"grid.columns");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Grid.Column column = (Grid.Column)element$iv;
            boolean bl = false;
            this.getHeaderRow().getCell(column).setText("");
        }
    }

    public final void remove() {
        this.clear();
        this.grid.removeHeaderRow(this.headerRow);
    }

    @NotNull
    public final HasValue<Object> getFilterComponent(@NotNull KProperty1<T, ?> property) {
        Intrinsics.checkNotNullParameter(property, (String)"property");
        Grid.Column column = GridKt.getColumnBy(this.grid, property);
        Component component = this.headerRow.getCell(column).getComponent();
        if (component == null) {
            throw new IllegalArgumentException(Intrinsics.stringPlus((String)"There is no filter configured for ", property));
        }
        Component component2 = component;
        return (HasValue)component2;
    }
}

