/*
 * Decompiled with CFR 0.152.
 */
package eu.vaadinonkotlin.vaadin8;

import com.github.mvysny.karibudsl.v8.GridKt;
import com.vaadin.data.BeanPropertySet;
import com.vaadin.data.HasValue;
import com.vaadin.data.PropertyDefinition;
import com.vaadin.data.PropertySet;
import com.vaadin.data.provider.ConfigurableFilterDataProvider;
import com.vaadin.data.provider.DataProvider;
import com.vaadin.server.SerializableConsumer;
import com.vaadin.shared.ui.ValueChangeMode;
import com.vaadin.ui.Component;
import com.vaadin.ui.Grid;
import com.vaadin.ui.HasValueChangeMode;
import com.vaadin.ui.components.grid.HeaderCell;
import com.vaadin.ui.components.grid.HeaderRow;
import eu.vaadinonkotlin.FilterFactory;
import eu.vaadinonkotlin.Listeners;
import eu.vaadinonkotlin.vaadin8.FilterBinder;
import eu.vaadinonkotlin.vaadin8.FilterFieldFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty1;
import kotlin.streams.jdk8.StreamsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\u00020\u0004BK\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\f\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00010\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0006\u0010#\u001a\u00020$J\u0010\u0010%\u001a\u00020$2\b\b\u0002\u0010&\u001a\u00020'J \u0010(\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020)2\u0010\u0010*\u001a\f\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u00030+J\u0006\u0010,\u001a\u00020$R\u001d\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001d\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u001f\u0010\u001e\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00018\u00010 0\u001f8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006-"}, d2={"Leu/vaadinonkotlin/vaadin8/FilterRow;", "T", "", "F", "Ljava/io/Serializable;", "grid", "Lcom/vaadin/ui/Grid;", "itemClass", "Lkotlin/reflect/KClass;", "headerRow", "Lcom/vaadin/ui/components/grid/HeaderRow;", "filterFieldFactory", "Leu/vaadinonkotlin/vaadin8/FilterFieldFactory;", "filterFactory", "Leu/vaadinonkotlin/FilterFactory;", "(Lcom/vaadin/ui/Grid;Lkotlin/reflect/KClass;Lcom/vaadin/ui/components/grid/HeaderRow;Leu/vaadinonkotlin/vaadin8/FilterFieldFactory;Leu/vaadinonkotlin/FilterFactory;)V", "binder", "Leu/vaadinonkotlin/vaadin8/FilterBinder;", "getBinder", "()Leu/vaadinonkotlin/vaadin8/FilterBinder;", "getFilterFactory", "()Leu/vaadinonkotlin/FilterFactory;", "getFilterFieldFactory", "()Leu/vaadinonkotlin/vaadin8/FilterFieldFactory;", "getGrid", "()Lcom/vaadin/ui/Grid;", "getHeaderRow", "()Lcom/vaadin/ui/components/grid/HeaderRow;", "getItemClass", "()Lkotlin/reflect/KClass;", "onFilterChangeListeners", "Leu/vaadinonkotlin/Listeners;", "Lcom/vaadin/server/SerializableConsumer;", "getOnFilterChangeListeners", "()Leu/vaadinonkotlin/Listeners;", "clear", "", "generateFilterComponents", "valueChangeMode", "Lcom/vaadin/shared/ui/ValueChangeMode;", "getFilterComponent", "Lcom/vaadin/data/HasValue;", "property", "Lkotlin/reflect/KProperty1;", "remove", "vok-util-vaadin8"})
public final class FilterRow<T, F>
implements Serializable {
    @NotNull
    private final FilterBinder<T, F> binder;
    @NotNull
    private final Grid<T> grid;
    @NotNull
    private final KClass<T> itemClass;
    @NotNull
    private final HeaderRow headerRow;
    @NotNull
    private final FilterFieldFactory<T, F> filterFieldFactory;
    @NotNull
    private final FilterFactory<F> filterFactory;

    @NotNull
    public final FilterBinder<T, F> getBinder() {
        return this.binder;
    }

    @NotNull
    public final Listeners<SerializableConsumer<F>> getOnFilterChangeListeners() {
        return this.binder.getOnFilterChangeListeners();
    }

    /*
     * WARNING - void declaration
     */
    public final void generateFilterComponents(@NotNull ValueChangeMode valueChangeMode) {
        void $receiver$iv$iv;
        Object object;
        void $receiver$iv$iv2;
        Intrinsics.checkParameterIsNotNull((Object)valueChangeMode, (String)"valueChangeMode");
        this.clear();
        PropertySet propertySet = BeanPropertySet.get((Class)JvmClassMappingKt.getJavaClass(this.itemClass));
        Intrinsics.checkExpressionValueIsNotNull((Object)propertySet, (String)"BeanPropertySet.get(itemClass.java)");
        Stream stream = propertySet.getProperties();
        Intrinsics.checkExpressionValueIsNotNull((Object)stream, (String)"BeanPropertySet.get(itemClass.java).properties");
        Iterable $receiver$iv = StreamsKt.toList((Stream)stream);
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10)), (int)16);
        Iterable iterable = $receiver$iv;
        Object destination$iv$iv = new LinkedHashMap(capacity$iv);
        for (Object element$iv$iv : $receiver$iv$iv2) {
            void it;
            object = (PropertyDefinition)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            void v2 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"it");
            String string = v2.getName();
            map.put(string, element$iv$iv);
        }
        Map properties = destination$iv$iv;
        List list = this.grid.getColumns();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"grid.columns");
        Iterable $receiver$iv2 = list;
        destination$iv$iv = $receiver$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv;
        object = $receiver$iv$iv$iv.iterator();
        while (object.hasNext()) {
            String string;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = object.next();
            Grid.Column it = (Grid.Column)element$iv$iv;
            boolean bl = false;
            Grid.Column column = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)column, (String)"it");
            if (column.getId() == null) continue;
            String it$iv$iv = string;
            destination$iv$iv2.add(it$iv$iv);
        }
        for (String propertyId : (List)destination$iv$iv2) {
            PropertyDefinition property = (PropertyDefinition)properties.get(propertyId);
            HasValue<?> field = property == null ? null : this.filterFieldFactory.createField(property);
            HasValue<?> hasValue = field;
            if (!(hasValue instanceof HasValueChangeMode)) {
                hasValue = null;
            }
            HasValueChangeMode hasValueChangeMode = (HasValueChangeMode)hasValue;
            if (hasValueChangeMode != null) {
                hasValueChangeMode.setValueChangeMode(valueChangeMode);
            }
            HeaderCell cell = this.headerRow.getCell(propertyId);
            if (field == null) continue;
            PropertyDefinition propertyDefinition = property;
            if (propertyDefinition == null) {
                Intrinsics.throwNpe();
            }
            if (propertyDefinition == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.vaadin.data.PropertyDefinition<T, kotlin.Any?>");
            }
            this.binder.bind(field, propertyDefinition);
            HeaderCell headerCell = cell;
            Intrinsics.checkExpressionValueIsNotNull((Object)headerCell, (String)"cell");
            headerCell.setComponent((Component)field);
        }
    }

    public static /* synthetic */ void generateFilterComponents$default(FilterRow filterRow, ValueChangeMode valueChangeMode, int n, Object object) {
        if ((n & 1) != 0) {
            valueChangeMode = ValueChangeMode.LAZY;
        }
        filterRow.generateFilterComponents(valueChangeMode);
    }

    public final void clear() {
        this.binder.unbindAll();
        List list = this.grid.getColumns();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"grid.columns");
        Iterable $receiver$iv = list;
        for (Object element$iv : $receiver$iv) {
            Grid.Column column = (Grid.Column)element$iv;
            boolean bl = false;
            HeaderCell headerCell = this.headerRow.getCell(column);
            Intrinsics.checkExpressionValueIsNotNull((Object)headerCell, (String)"headerRow.getCell(column)");
            headerCell.setText("");
        }
    }

    public final void remove() {
        this.clear();
        this.grid.removeHeaderRow(this.headerRow);
    }

    @NotNull
    public final HasValue<Object> getFilterComponent(@NotNull KProperty1<T, ?> property) {
        Component component;
        Intrinsics.checkParameterIsNotNull(property, (String)"property");
        Grid.Column column = GridKt.getColumnBy(this.grid, property);
        HeaderCell headerCell = this.headerRow.getCell(column);
        Intrinsics.checkExpressionValueIsNotNull((Object)headerCell, (String)"headerRow.getCell(column)");
        Component component2 = headerCell.getComponent();
        if (component2 == null) {
            throw (Throwable)new IllegalArgumentException("There is no filter configured for " + property);
        }
        Component component3 = component = component2;
        if (component3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.vaadin.data.HasValue<kotlin.Any?>");
        }
        return (HasValue)component3;
    }

    @NotNull
    public final Grid<T> getGrid() {
        return this.grid;
    }

    @NotNull
    public final KClass<T> getItemClass() {
        return this.itemClass;
    }

    @NotNull
    public final HeaderRow getHeaderRow() {
        return this.headerRow;
    }

    @NotNull
    public final FilterFieldFactory<T, F> getFilterFieldFactory() {
        return this.filterFieldFactory;
    }

    @NotNull
    public final FilterFactory<F> getFilterFactory() {
        return this.filterFactory;
    }

    public FilterRow(@NotNull Grid<T> grid, @NotNull KClass<T> itemClass, @NotNull HeaderRow headerRow, @NotNull FilterFieldFactory<T, F> filterFieldFactory, @NotNull FilterFactory<F> filterFactory) {
        Intrinsics.checkParameterIsNotNull(grid, (String)"grid");
        Intrinsics.checkParameterIsNotNull(itemClass, (String)"itemClass");
        Intrinsics.checkParameterIsNotNull((Object)headerRow, (String)"headerRow");
        Intrinsics.checkParameterIsNotNull(filterFieldFactory, (String)"filterFieldFactory");
        Intrinsics.checkParameterIsNotNull(filterFactory, (String)"filterFactory");
        this.grid = grid;
        this.itemClass = itemClass;
        this.headerRow = headerRow;
        this.filterFieldFactory = filterFieldFactory;
        this.filterFactory = filterFactory;
        this.binder = new FilterBinder<T, F>(this.filterFieldFactory, this.filterFactory);
        this.binder.getOnFilterChangeListeners().add((Serializable)new SerializableConsumer<F>(){

            public final void accept(@Nullable F filter) {
                DataProvider dataProvider = this.getGrid().getDataProvider();
                if (dataProvider == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.vaadin.data.provider.ConfigurableFilterDataProvider<T, F, F>");
                }
                ((ConfigurableFilterDataProvider)dataProvider).setFilter(filter);
            }
        });
    }
}

