/*
 * Decompiled with CFR 0.152.
 */
package eu.vaadinonkotlin;

import eu.vaadinonkotlin.I18nKt;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0011\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\rH\u0086\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Leu/vaadinonkotlin/I18n;", "", "locale", "Ljava/util/Locale;", "(Ljava/util/Locale;)V", "customMessages", "Ljava/util/ResourceBundle;", "getLocale", "()Ljava/util/Locale;", "standardMessages", "contains", "", "key", "", "get", "Companion", "vok-framework"})
public final class I18n {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Locale locale;
    @NotNull
    private final ResourceBundle standardMessages;
    @NotNull
    private final ResourceBundle customMessages;
    private static final Logger log = LoggerFactory.getLogger(I18n.class);

    public I18n(@NotNull Locale locale) {
        ResourceBundle resourceBundle;
        I18n i18n;
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        this.locale = locale;
        ResourceBundle resourceBundle2 = ResourceBundle.getBundle("eu.vaadinonkotlin.VokMessages", this.locale);
        Intrinsics.checkNotNullExpressionValue((Object)resourceBundle2, (String)"getBundle(...)");
        this.standardMessages = resourceBundle2;
        I18n i18n2 = this;
        try {
            i18n = i18n2;
            resourceBundle = ResourceBundle.getBundle("VokMessages", this.locale);
            Intrinsics.checkNotNull((Object)resourceBundle);
        }
        catch (MissingResourceException missingResourceException) {
            i18n = i18n2;
            log.debug("Custom message bundle VokMessages for locale " + this.locale + " is missing, ignoring");
            resourceBundle = I18nKt.getEmptyResourceBundle();
        }
        i18n.customMessages = resourceBundle;
    }

    @NotNull
    public final Locale getLocale() {
        return this.locale;
    }

    @NotNull
    public final String get(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (this.customMessages.containsKey(key)) {
            String string = this.customMessages.getString(key);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            return string;
        }
        if (this.standardMessages.containsKey(key)) {
            String string = this.standardMessages.getString(key);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            return string;
        }
        return "!{" + key + "}!";
    }

    public final boolean contains(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.customMessages.containsKey(key) || this.standardMessages.containsKey(key);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001e\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00048\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0002\u00a8\u0006\u0007"}, d2={"Leu/vaadinonkotlin/I18n$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLog$annotations", "vok-framework"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private static /* synthetic */ void getLog$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

