// auto-generated by sbt-boilerplate
/**
 * Copyright (C) 2014-2015 Lightbend Inc. <http://www.lightbend.com>
 */
package akka.stream

import scala.collection.immutable
import scala.annotation.unchecked.uncheckedVariance

object FanOutShape {
  sealed trait Init[I] {
    def inlet: Inlet[I]
    def outlets: immutable.Seq[Outlet[_]]
    def name: String
  }
  final case class Name[I](override val name: String) extends Init[I] {
    override def inlet: Inlet[I] = Inlet(s"$name.in")
    override def outlets: immutable.Seq[Outlet[_]] = Nil
  }
  final case class Ports[I](override val inlet: Inlet[I], override val outlets: immutable.Seq[Outlet[_]]) extends Init[I] {
    override def name: String = "FanOut"
  }
}

abstract class FanOutShape[-I] private (_in: Inlet[I @uncheckedVariance], _registered: Iterator[Outlet[_]], _name: String) extends Shape {
  import FanOutShape._

  def this(init: FanOutShape.Init[I]) = this(init.inlet, init.outlets.iterator, init.name)
  
  final def in: Inlet[I @uncheckedVariance] = _in
  final override def outlets: immutable.Seq[Outlet[_]] = _outlets
  final override def inlets: immutable.Seq[Inlet[_]] = in :: Nil
  
  private var _outlets: Vector[Outlet[_]] = Vector.empty
  protected def newOutlet[T](name: String): Outlet[T] = {
    val p = if (_registered.hasNext) _registered.next().asInstanceOf[Outlet[T]] else Outlet[T](s"${_name}.$name")
    _outlets :+= p
    p
  }
  
  protected def construct(init: Init[I @uncheckedVariance]): FanOutShape[I]
  
  def deepCopy(): FanOutShape[I] = construct(Ports[I](_in.carbonCopy(), outlets.map(_.carbonCopy())))
  final def copyFromPorts(inlets: immutable.Seq[Inlet[_]], outlets: immutable.Seq[Outlet[_]]): FanOutShape[I] = {
    require(outlets.size == _outlets.size, s"proposed outlets [${outlets.mkString(", ")}] do not fit FanOutShape")
    require(inlets.size == 1, s"proposed inlets [${inlets.mkString(", ")}] do not fit FanOutShape")
    construct(Ports[I](inlets.head.asInstanceOf[Inlet[I]], outlets))
  }
}

object UniformFanOutShape {
  def apply[I, O](inlet: Inlet[I], outlets: Outlet[O]*): UniformFanOutShape[I, O] =
    new UniformFanOutShape(outlets.size, FanOutShape.Ports(inlet, outlets.toList))
}

class UniformFanOutShape[-I, +O](n: Int, _init: FanOutShape.Init[I @uncheckedVariance]) extends FanOutShape[I](_init) {
  def this(n: Int) = this(n, FanOutShape.Name[I]("UniformFanOut"))
  def this(n: Int, name: String) = this(n, FanOutShape.Name[I](name))
  def this(inlet: Inlet[I], outlets: Array[Outlet[O]]) = this(outlets.size, FanOutShape.Ports(inlet, outlets.toList))
  override protected def construct(init: FanOutShape.Init[I @uncheckedVariance]): FanOutShape[I] = new UniformFanOutShape(n, init)
  override def deepCopy(): UniformFanOutShape[I, O] = super.deepCopy().asInstanceOf[UniformFanOutShape[I, O]]
  
  val outArray: Array[Outlet[O @uncheckedVariance]] = Array.tabulate(n)(i => newOutlet[O](s"out$i"))
  def out(n: Int): Outlet[O @uncheckedVariance] = outArray(n)
}

class FanOutShape2[-I, +O0, +O1](_init: FanOutShape.Init[I @uncheckedVariance]) extends FanOutShape[I](_init) {
  def this(name: String) = this(FanOutShape.Name[I](name))
  def this(in: Inlet[I], out0: Outlet[O0], out1: Outlet[O1]) = this(FanOutShape.Ports(in, out0 :: out1 :: Nil))
  override protected def construct(init: FanOutShape.Init[I @uncheckedVariance]): FanOutShape[I] = new FanOutShape2(init)
  override def deepCopy(): FanOutShape2[I, O0, O1] = super.deepCopy().asInstanceOf[FanOutShape2[I, O0, O1]]
  
  val out0: Outlet[O0 @uncheckedVariance] = newOutlet[O0]("out0")
  val out1: Outlet[O1 @uncheckedVariance] = newOutlet[O1]("out1")
}

class FanOutShape3[-I, +O0, +O1, +O2](_init: FanOutShape.Init[I @uncheckedVariance]) extends FanOutShape[I](_init) {
  def this(name: String) = this(FanOutShape.Name[I](name))
  def this(in: Inlet[I], out0: Outlet[O0], out1: Outlet[O1], out2: Outlet[O2]) = this(FanOutShape.Ports(in, out0 :: out1 :: out2 :: Nil))
  override protected def construct(init: FanOutShape.Init[I @uncheckedVariance]): FanOutShape[I] = new FanOutShape3(init)
  override def deepCopy(): FanOutShape3[I, O0, O1, O2] = super.deepCopy().asInstanceOf[FanOutShape3[I, O0, O1, O2]]
  
  val out0: Outlet[O0 @uncheckedVariance] = newOutlet[O0]("out0")
  val out1: Outlet[O1 @uncheckedVariance] = newOutlet[O1]("out1")
  val out2: Outlet[O2 @uncheckedVariance] = newOutlet[O2]("out2")
}

class FanOutShape4[-I, +O0, +O1, +O2, +O3](_init: FanOutShape.Init[I @uncheckedVariance]) extends FanOutShape[I](_init) {
  def this(name: String) = this(FanOutShape.Name[I](name))
  def this(in: Inlet[I], out0: Outlet[O0], out1: Outlet[O1], out2: Outlet[O2], out3: Outlet[O3]) = this(FanOutShape.Ports(in, out0 :: out1 :: out2 :: out3 :: Nil))
  override protected def construct(init: FanOutShape.Init[I @uncheckedVariance]): FanOutShape[I] = new FanOutShape4(init)
  override def deepCopy(): FanOutShape4[I, O0, O1, O2, O3] = super.deepCopy().asInstanceOf[FanOutShape4[I, O0, O1, O2, O3]]
  
  val out0: Outlet[O0 @uncheckedVariance] = newOutlet[O0]("out0")
  val out1: Outlet[O1 @uncheckedVariance] = newOutlet[O1]("out1")
  val out2: Outlet[O2 @uncheckedVariance] = newOutlet[O2]("out2")
  val out3: Outlet[O3 @uncheckedVariance] = newOutlet[O3]("out3")
}

class FanOutShape5[-I, +O0, +O1, +O2, +O3, +O4](_init: FanOutShape.Init[I @uncheckedVariance]) extends FanOutShape[I](_init) {
  def this(name: String) = this(FanOutShape.Name[I](name))
  def this(in: Inlet[I], out0: Outlet[O0], out1: Outlet[O1], out2: Outlet[O2], out3: Outlet[O3], out4: Outlet[O4]) = this(FanOutShape.Ports(in, out0 :: out1 :: out2 :: out3 :: out4 :: Nil))
  override protected def construct(init: FanOutShape.Init[I @uncheckedVariance]): FanOutShape[I] = new FanOutShape5(init)
  override def deepCopy(): FanOutShape5[I, O0, O1, O2, O3, O4] = super.deepCopy().asInstanceOf[FanOutShape5[I, O0, O1, O2, O3, O4]]
  
  val out0: Outlet[O0 @uncheckedVariance] = newOutlet[O0]("out0")
  val out1: Outlet[O1 @uncheckedVariance] = newOutlet[O1]("out1")
  val out2: Outlet[O2 @uncheckedVariance] = newOutlet[O2]("out2")
  val out3: Outlet[O3 @uncheckedVariance] = newOutlet[O3]("out3")
  val out4: Outlet[O4 @uncheckedVariance] = newOutlet[O4]("out4")
}

class FanOutShape6[-I, +O0, +O1, +O2, +O3, +O4, +O5](_init: FanOutShape.Init[I @uncheckedVariance]) extends FanOutShape[I](_init) {
  def this(name: String) = this(FanOutShape.Name[I](name))
  def this(in: Inlet[I], out0: Outlet[O0], out1: Outlet[O1], out2: Outlet[O2], out3: Outlet[O3], out4: Outlet[O4], out5: Outlet[O5]) = this(FanOutShape.Ports(in, out0 :: out1 :: out2 :: out3 :: out4 :: out5 :: Nil))
  override protected def construct(init: FanOutShape.Init[I @uncheckedVariance]): FanOutShape[I] = new FanOutShape6(init)
  override def deepCopy(): FanOutShape6[I, O0, O1, O2, O3, O4, O5] = super.deepCopy().asInstanceOf[FanOutShape6[I, O0, O1, O2, O3, O4, O5]]
  
  val out0: Outlet[O0 @uncheckedVariance] = newOutlet[O0]("out0")
  val out1: Outlet[O1 @uncheckedVariance] = newOutlet[O1]("out1")
  val out2: Outlet[O2 @uncheckedVariance] = newOutlet[O2]("out2")
  val out3: Outlet[O3 @uncheckedVariance] = newOutlet[O3]("out3")
  val out4: Outlet[O4 @uncheckedVariance] = newOutlet[O4]("out4")
  val out5: Outlet[O5 @uncheckedVariance] = newOutlet[O5]("out5")
}

class FanOutShape7[-I, +O0, +O1, +O2, +O3, +O4, +O5, +O6](_init: FanOutShape.Init[I @uncheckedVariance]) extends FanOutShape[I](_init) {
  def this(name: String) = this(FanOutShape.Name[I](name))
  def this(in: Inlet[I], out0: Outlet[O0], out1: Outlet[O1], out2: Outlet[O2], out3: Outlet[O3], out4: Outlet[O4], out5: Outlet[O5], out6: Outlet[O6]) = this(FanOutShape.Ports(in, out0 :: out1 :: out2 :: out3 :: out4 :: out5 :: out6 :: Nil))
  override protected def construct(init: FanOutShape.Init[I @uncheckedVariance]): FanOutShape[I] = new FanOutShape7(init)
  override def deepCopy(): FanOutShape7[I, O0, O1, O2, O3, O4, O5, O6] = super.deepCopy().asInstanceOf[FanOutShape7[I, O0, O1, O2, O3, O4, O5, O6]]
  
  val out0: Outlet[O0 @uncheckedVariance] = newOutlet[O0]("out0")
  val out1: Outlet[O1 @uncheckedVariance] = newOutlet[O1]("out1")
  val out2: Outlet[O2 @uncheckedVariance] = newOutlet[O2]("out2")
  val out3: Outlet[O3 @uncheckedVariance] = newOutlet[O3]("out3")
  val out4: Outlet[O4 @uncheckedVariance] = newOutlet[O4]("out4")
  val out5: Outlet[O5 @uncheckedVariance] = newOutlet[O5]("out5")
  val out6: Outlet[O6 @uncheckedVariance] = newOutlet[O6]("out6")
}

class FanOutShape8[-I, +O0, +O1, +O2, +O3, +O4, +O5, +O6, +O7](_init: FanOutShape.Init[I @uncheckedVariance]) extends FanOutShape[I](_init) {
  def this(name: String) = this(FanOutShape.Name[I](name))
  def this(in: Inlet[I], out0: Outlet[O0], out1: Outlet[O1], out2: Outlet[O2], out3: Outlet[O3], out4: Outlet[O4], out5: Outlet[O5], out6: Outlet[O6], out7: Outlet[O7]) = this(FanOutShape.Ports(in, out0 :: out1 :: out2 :: out3 :: out4 :: out5 :: out6 :: out7 :: Nil))
  override protected def construct(init: FanOutShape.Init[I @uncheckedVariance]): FanOutShape[I] = new FanOutShape8(init)
  override def deepCopy(): FanOutShape8[I, O0, O1, O2, O3, O4, O5, O6, O7] = super.deepCopy().asInstanceOf[FanOutShape8[I, O0, O1, O2, O3, O4, O5, O6, O7]]
  
  val out0: Outlet[O0 @uncheckedVariance] = newOutlet[O0]("out0")
  val out1: Outlet[O1 @uncheckedVariance] = newOutlet[O1]("out1")
  val out2: Outlet[O2 @uncheckedVariance] = newOutlet[O2]("out2")
  val out3: Outlet[O3 @uncheckedVariance] = newOutlet[O3]("out3")
  val out4: Outlet[O4 @uncheckedVariance] = newOutlet[O4]("out4")
  val out5: Outlet[O5 @uncheckedVariance] = newOutlet[O5]("out5")
  val out6: Outlet[O6 @uncheckedVariance] = newOutlet[O6]("out6")
  val out7: Outlet[O7 @uncheckedVariance] = newOutlet[O7]("out7")
}

class FanOutShape9[-I, +O0, +O1, +O2, +O3, +O4, +O5, +O6, +O7, +O8](_init: FanOutShape.Init[I @uncheckedVariance]) extends FanOutShape[I](_init) {
  def this(name: String) = this(FanOutShape.Name[I](name))
  def this(in: Inlet[I], out0: Outlet[O0], out1: Outlet[O1], out2: Outlet[O2], out3: Outlet[O3], out4: Outlet[O4], out5: Outlet[O5], out6: Outlet[O6], out7: Outlet[O7], out8: Outlet[O8]) = this(FanOutShape.Ports(in, out0 :: out1 :: out2 :: out3 :: out4 :: out5 :: out6 :: out7 :: out8 :: Nil))
  override protected def construct(init: FanOutShape.Init[I @uncheckedVariance]): FanOutShape[I] = new FanOutShape9(init)
  override def deepCopy(): FanOutShape9[I, O0, O1, O2, O3, O4, O5, O6, O7, O8] = super.deepCopy().asInstanceOf[FanOutShape9[I, O0, O1, O2, O3, O4, O5, O6, O7, O8]]
  
  val out0: Outlet[O0 @uncheckedVariance] = newOutlet[O0]("out0")
  val out1: Outlet[O1 @uncheckedVariance] = newOutlet[O1]("out1")
  val out2: Outlet[O2 @uncheckedVariance] = newOutlet[O2]("out2")
  val out3: Outlet[O3 @uncheckedVariance] = newOutlet[O3]("out3")
  val out4: Outlet[O4 @uncheckedVariance] = newOutlet[O4]("out4")
  val out5: Outlet[O5 @uncheckedVariance] = newOutlet[O5]("out5")
  val out6: Outlet[O6 @uncheckedVariance] = newOutlet[O6]("out6")
  val out7: Outlet[O7 @uncheckedVariance] = newOutlet[O7]("out7")
  val out8: Outlet[O8 @uncheckedVariance] = newOutlet[O8]("out8")
}

class FanOutShape10[-I, +O0, +O1, +O2, +O3, +O4, +O5, +O6, +O7, +O8, +O9](_init: FanOutShape.Init[I @uncheckedVariance]) extends FanOutShape[I](_init) {
  def this(name: String) = this(FanOutShape.Name[I](name))
  def this(in: Inlet[I], out0: Outlet[O0], out1: Outlet[O1], out2: Outlet[O2], out3: Outlet[O3], out4: Outlet[O4], out5: Outlet[O5], out6: Outlet[O6], out7: Outlet[O7], out8: Outlet[O8], out9: Outlet[O9]) = this(FanOutShape.Ports(in, out0 :: out1 :: out2 :: out3 :: out4 :: out5 :: out6 :: out7 :: out8 :: out9 :: Nil))
  override protected def construct(init: FanOutShape.Init[I @uncheckedVariance]): FanOutShape[I] = new FanOutShape10(init)
  override def deepCopy(): FanOutShape10[I, O0, O1, O2, O3, O4, O5, O6, O7, O8, O9] = super.deepCopy().asInstanceOf[FanOutShape10[I, O0, O1, O2, O3, O4, O5, O6, O7, O8, O9]]
  
  val out0: Outlet[O0 @uncheckedVariance] = newOutlet[O0]("out0")
  val out1: Outlet[O1 @uncheckedVariance] = newOutlet[O1]("out1")
  val out2: Outlet[O2 @uncheckedVariance] = newOutlet[O2]("out2")
  val out3: Outlet[O3 @uncheckedVariance] = newOutlet[O3]("out3")
  val out4: Outlet[O4 @uncheckedVariance] = newOutlet[O4]("out4")
  val out5: Outlet[O5 @uncheckedVariance] = newOutlet[O5]("out5")
  val out6: Outlet[O6 @uncheckedVariance] = newOutlet[O6]("out6")
  val out7: Outlet[O7 @uncheckedVariance] = newOutlet[O7]("out7")
  val out8: Outlet[O8 @uncheckedVariance] = newOutlet[O8]("out8")
  val out9: Outlet[O9 @uncheckedVariance] = newOutlet[O9]("out9")
}

class FanOutShape11[-I, +O0, +O1, +O2, +O3, +O4, +O5, +O6, +O7, +O8, +O9, +O10](_init: FanOutShape.Init[I @uncheckedVariance]) extends FanOutShape[I](_init) {
  def this(name: String) = this(FanOutShape.Name[I](name))
  def this(in: Inlet[I], out0: Outlet[O0], out1: Outlet[O1], out2: Outlet[O2], out3: Outlet[O3], out4: Outlet[O4], out5: Outlet[O5], out6: Outlet[O6], out7: Outlet[O7], out8: Outlet[O8], out9: Outlet[O9], out10: Outlet[O10]) = this(FanOutShape.Ports(in, out0 :: out1 :: out2 :: out3 :: out4 :: out5 :: out6 :: out7 :: out8 :: out9 :: out10 :: Nil))
  override protected def construct(init: FanOutShape.Init[I @uncheckedVariance]): FanOutShape[I] = new FanOutShape11(init)
  override def deepCopy(): FanOutShape11[I, O0, O1, O2, O3, O4, O5, O6, O7, O8, O9, O10] = super.deepCopy().asInstanceOf[FanOutShape11[I, O0, O1, O2, O3, O4, O5, O6, O7, O8, O9, O10]]
  
  val out0: Outlet[O0 @uncheckedVariance] = newOutlet[O0]("out0")
  val out1: Outlet[O1 @uncheckedVariance] = newOutlet[O1]("out1")
  val out2: Outlet[O2 @uncheckedVariance] = newOutlet[O2]("out2")
  val out3: Outlet[O3 @uncheckedVariance] = newOutlet[O3]("out3")
  val out4: Outlet[O4 @uncheckedVariance] = newOutlet[O4]("out4")
  val out5: Outlet[O5 @uncheckedVariance] = newOutlet[O5]("out5")
  val out6: Outlet[O6 @uncheckedVariance] = newOutlet[O6]("out6")
  val out7: Outlet[O7 @uncheckedVariance] = newOutlet[O7]("out7")
  val out8: Outlet[O8 @uncheckedVariance] = newOutlet[O8]("out8")
  val out9: Outlet[O9 @uncheckedVariance] = newOutlet[O9]("out9")
  val out10: Outlet[O10 @uncheckedVariance] = newOutlet[O10]("out10")
}

class FanOutShape12[-I, +O0, +O1, +O2, +O3, +O4, +O5, +O6, +O7, +O8, +O9, +O10, +O11](_init: FanOutShape.Init[I @uncheckedVariance]) extends FanOutShape[I](_init) {
  def this(name: String) = this(FanOutShape.Name[I](name))
  def this(in: Inlet[I], out0: Outlet[O0], out1: Outlet[O1], out2: Outlet[O2], out3: Outlet[O3], out4: Outlet[O4], out5: Outlet[O5], out6: Outlet[O6], out7: Outlet[O7], out8: Outlet[O8], out9: Outlet[O9], out10: Outlet[O10], out11: Outlet[O11]) = this(FanOutShape.Ports(in, out0 :: out1 :: out2 :: out3 :: out4 :: out5 :: out6 :: out7 :: out8 :: out9 :: out10 :: out11 :: Nil))
  override protected def construct(init: FanOutShape.Init[I @uncheckedVariance]): FanOutShape[I] = new FanOutShape12(init)
  override def deepCopy(): FanOutShape12[I, O0, O1, O2, O3, O4, O5, O6, O7, O8, O9, O10, O11] = super.deepCopy().asInstanceOf[FanOutShape12[I, O0, O1, O2, O3, O4, O5, O6, O7, O8, O9, O10, O11]]
  
  val out0: Outlet[O0 @uncheckedVariance] = newOutlet[O0]("out0")
  val out1: Outlet[O1 @uncheckedVariance] = newOutlet[O1]("out1")
  val out2: Outlet[O2 @uncheckedVariance] = newOutlet[O2]("out2")
  val out3: Outlet[O3 @uncheckedVariance] = newOutlet[O3]("out3")
  val out4: Outlet[O4 @uncheckedVariance] = newOutlet[O4]("out4")
  val out5: Outlet[O5 @uncheckedVariance] = newOutlet[O5]("out5")
  val out6: Outlet[O6 @uncheckedVariance] = newOutlet[O6]("out6")
  val out7: Outlet[O7 @uncheckedVariance] = newOutlet[O7]("out7")
  val out8: Outlet[O8 @uncheckedVariance] = newOutlet[O8]("out8")
  val out9: Outlet[O9 @uncheckedVariance] = newOutlet[O9]("out9")
  val out10: Outlet[O10 @uncheckedVariance] = newOutlet[O10]("out10")
  val out11: Outlet[O11 @uncheckedVariance] = newOutlet[O11]("out11")
}

class FanOutShape13[-I, +O0, +O1, +O2, +O3, +O4, +O5, +O6, +O7, +O8, +O9, +O10, +O11, +O12](_init: FanOutShape.Init[I @uncheckedVariance]) extends FanOutShape[I](_init) {
  def this(name: String) = this(FanOutShape.Name[I](name))
  def this(in: Inlet[I], out0: Outlet[O0], out1: Outlet[O1], out2: Outlet[O2], out3: Outlet[O3], out4: Outlet[O4], out5: Outlet[O5], out6: Outlet[O6], out7: Outlet[O7], out8: Outlet[O8], out9: Outlet[O9], out10: Outlet[O10], out11: Outlet[O11], out12: Outlet[O12]) = this(FanOutShape.Ports(in, out0 :: out1 :: out2 :: out3 :: out4 :: out5 :: out6 :: out7 :: out8 :: out9 :: out10 :: out11 :: out12 :: Nil))
  override protected def construct(init: FanOutShape.Init[I @uncheckedVariance]): FanOutShape[I] = new FanOutShape13(init)
  override def deepCopy(): FanOutShape13[I, O0, O1, O2, O3, O4, O5, O6, O7, O8, O9, O10, O11, O12] = super.deepCopy().asInstanceOf[FanOutShape13[I, O0, O1, O2, O3, O4, O5, O6, O7, O8, O9, O10, O11, O12]]
  
  val out0: Outlet[O0 @uncheckedVariance] = newOutlet[O0]("out0")
  val out1: Outlet[O1 @uncheckedVariance] = newOutlet[O1]("out1")
  val out2: Outlet[O2 @uncheckedVariance] = newOutlet[O2]("out2")
  val out3: Outlet[O3 @uncheckedVariance] = newOutlet[O3]("out3")
  val out4: Outlet[O4 @uncheckedVariance] = newOutlet[O4]("out4")
  val out5: Outlet[O5 @uncheckedVariance] = newOutlet[O5]("out5")
  val out6: Outlet[O6 @uncheckedVariance] = newOutlet[O6]("out6")
  val out7: Outlet[O7 @uncheckedVariance] = newOutlet[O7]("out7")
  val out8: Outlet[O8 @uncheckedVariance] = newOutlet[O8]("out8")
  val out9: Outlet[O9 @uncheckedVariance] = newOutlet[O9]("out9")
  val out10: Outlet[O10 @uncheckedVariance] = newOutlet[O10]("out10")
  val out11: Outlet[O11 @uncheckedVariance] = newOutlet[O11]("out11")
  val out12: Outlet[O12 @uncheckedVariance] = newOutlet[O12]("out12")
}

class FanOutShape14[-I, +O0, +O1, +O2, +O3, +O4, +O5, +O6, +O7, +O8, +O9, +O10, +O11, +O12, +O13](_init: FanOutShape.Init[I @uncheckedVariance]) extends FanOutShape[I](_init) {
  def this(name: String) = this(FanOutShape.Name[I](name))
  def this(in: Inlet[I], out0: Outlet[O0], out1: Outlet[O1], out2: Outlet[O2], out3: Outlet[O3], out4: Outlet[O4], out5: Outlet[O5], out6: Outlet[O6], out7: Outlet[O7], out8: Outlet[O8], out9: Outlet[O9], out10: Outlet[O10], out11: Outlet[O11], out12: Outlet[O12], out13: Outlet[O13]) = this(FanOutShape.Ports(in, out0 :: out1 :: out2 :: out3 :: out4 :: out5 :: out6 :: out7 :: out8 :: out9 :: out10 :: out11 :: out12 :: out13 :: Nil))
  override protected def construct(init: FanOutShape.Init[I @uncheckedVariance]): FanOutShape[I] = new FanOutShape14(init)
  override def deepCopy(): FanOutShape14[I, O0, O1, O2, O3, O4, O5, O6, O7, O8, O9, O10, O11, O12, O13] = super.deepCopy().asInstanceOf[FanOutShape14[I, O0, O1, O2, O3, O4, O5, O6, O7, O8, O9, O10, O11, O12, O13]]
  
  val out0: Outlet[O0 @uncheckedVariance] = newOutlet[O0]("out0")
  val out1: Outlet[O1 @uncheckedVariance] = newOutlet[O1]("out1")
  val out2: Outlet[O2 @uncheckedVariance] = newOutlet[O2]("out2")
  val out3: Outlet[O3 @uncheckedVariance] = newOutlet[O3]("out3")
  val out4: Outlet[O4 @uncheckedVariance] = newOutlet[O4]("out4")
  val out5: Outlet[O5 @uncheckedVariance] = newOutlet[O5]("out5")
  val out6: Outlet[O6 @uncheckedVariance] = newOutlet[O6]("out6")
  val out7: Outlet[O7 @uncheckedVariance] = newOutlet[O7]("out7")
  val out8: Outlet[O8 @uncheckedVariance] = newOutlet[O8]("out8")
  val out9: Outlet[O9 @uncheckedVariance] = newOutlet[O9]("out9")
  val out10: Outlet[O10 @uncheckedVariance] = newOutlet[O10]("out10")
  val out11: Outlet[O11 @uncheckedVariance] = newOutlet[O11]("out11")
  val out12: Outlet[O12 @uncheckedVariance] = newOutlet[O12]("out12")
  val out13: Outlet[O13 @uncheckedVariance] = newOutlet[O13]("out13")
}

class FanOutShape15[-I, +O0, +O1, +O2, +O3, +O4, +O5, +O6, +O7, +O8, +O9, +O10, +O11, +O12, +O13, +O14](_init: FanOutShape.Init[I @uncheckedVariance]) extends FanOutShape[I](_init) {
  def this(name: String) = this(FanOutShape.Name[I](name))
  def this(in: Inlet[I], out0: Outlet[O0], out1: Outlet[O1], out2: Outlet[O2], out3: Outlet[O3], out4: Outlet[O4], out5: Outlet[O5], out6: Outlet[O6], out7: Outlet[O7], out8: Outlet[O8], out9: Outlet[O9], out10: Outlet[O10], out11: Outlet[O11], out12: Outlet[O12], out13: Outlet[O13], out14: Outlet[O14]) = this(FanOutShape.Ports(in, out0 :: out1 :: out2 :: out3 :: out4 :: out5 :: out6 :: out7 :: out8 :: out9 :: out10 :: out11 :: out12 :: out13 :: out14 :: Nil))
  override protected def construct(init: FanOutShape.Init[I @uncheckedVariance]): FanOutShape[I] = new FanOutShape15(init)
  override def deepCopy(): FanOutShape15[I, O0, O1, O2, O3, O4, O5, O6, O7, O8, O9, O10, O11, O12, O13, O14] = super.deepCopy().asInstanceOf[FanOutShape15[I, O0, O1, O2, O3, O4, O5, O6, O7, O8, O9, O10, O11, O12, O13, O14]]
  
  val out0: Outlet[O0 @uncheckedVariance] = newOutlet[O0]("out0")
  val out1: Outlet[O1 @uncheckedVariance] = newOutlet[O1]("out1")
  val out2: Outlet[O2 @uncheckedVariance] = newOutlet[O2]("out2")
  val out3: Outlet[O3 @uncheckedVariance] = newOutlet[O3]("out3")
  val out4: Outlet[O4 @uncheckedVariance] = newOutlet[O4]("out4")
  val out5: Outlet[O5 @uncheckedVariance] = newOutlet[O5]("out5")
  val out6: Outlet[O6 @uncheckedVariance] = newOutlet[O6]("out6")
  val out7: Outlet[O7 @uncheckedVariance] = newOutlet[O7]("out7")
  val out8: Outlet[O8 @uncheckedVariance] = newOutlet[O8]("out8")
  val out9: Outlet[O9 @uncheckedVariance] = newOutlet[O9]("out9")
  val out10: Outlet[O10 @uncheckedVariance] = newOutlet[O10]("out10")
  val out11: Outlet[O11 @uncheckedVariance] = newOutlet[O11]("out11")
  val out12: Outlet[O12 @uncheckedVariance] = newOutlet[O12]("out12")
  val out13: Outlet[O13 @uncheckedVariance] = newOutlet[O13]("out13")
  val out14: Outlet[O14 @uncheckedVariance] = newOutlet[O14]("out14")
}

class FanOutShape16[-I, +O0, +O1, +O2, +O3, +O4, +O5, +O6, +O7, +O8, +O9, +O10, +O11, +O12, +O13, +O14, +O15](_init: FanOutShape.Init[I @uncheckedVariance]) extends FanOutShape[I](_init) {
  def this(name: String) = this(FanOutShape.Name[I](name))
  def this(in: Inlet[I], out0: Outlet[O0], out1: Outlet[O1], out2: Outlet[O2], out3: Outlet[O3], out4: Outlet[O4], out5: Outlet[O5], out6: Outlet[O6], out7: Outlet[O7], out8: Outlet[O8], out9: Outlet[O9], out10: Outlet[O10], out11: Outlet[O11], out12: Outlet[O12], out13: Outlet[O13], out14: Outlet[O14], out15: Outlet[O15]) = this(FanOutShape.Ports(in, out0 :: out1 :: out2 :: out3 :: out4 :: out5 :: out6 :: out7 :: out8 :: out9 :: out10 :: out11 :: out12 :: out13 :: out14 :: out15 :: Nil))
  override protected def construct(init: FanOutShape.Init[I @uncheckedVariance]): FanOutShape[I] = new FanOutShape16(init)
  override def deepCopy(): FanOutShape16[I, O0, O1, O2, O3, O4, O5, O6, O7, O8, O9, O10, O11, O12, O13, O14, O15] = super.deepCopy().asInstanceOf[FanOutShape16[I, O0, O1, O2, O3, O4, O5, O6, O7, O8, O9, O10, O11, O12, O13, O14, O15]]
  
  val out0: Outlet[O0 @uncheckedVariance] = newOutlet[O0]("out0")
  val out1: Outlet[O1 @uncheckedVariance] = newOutlet[O1]("out1")
  val out2: Outlet[O2 @uncheckedVariance] = newOutlet[O2]("out2")
  val out3: Outlet[O3 @uncheckedVariance] = newOutlet[O3]("out3")
  val out4: Outlet[O4 @uncheckedVariance] = newOutlet[O4]("out4")
  val out5: Outlet[O5 @uncheckedVariance] = newOutlet[O5]("out5")
  val out6: Outlet[O6 @uncheckedVariance] = newOutlet[O6]("out6")
  val out7: Outlet[O7 @uncheckedVariance] = newOutlet[O7]("out7")
  val out8: Outlet[O8 @uncheckedVariance] = newOutlet[O8]("out8")
  val out9: Outlet[O9 @uncheckedVariance] = newOutlet[O9]("out9")
  val out10: Outlet[O10 @uncheckedVariance] = newOutlet[O10]("out10")
  val out11: Outlet[O11 @uncheckedVariance] = newOutlet[O11]("out11")
  val out12: Outlet[O12 @uncheckedVariance] = newOutlet[O12]("out12")
  val out13: Outlet[O13 @uncheckedVariance] = newOutlet[O13]("out13")
  val out14: Outlet[O14 @uncheckedVariance] = newOutlet[O14]("out14")
  val out15: Outlet[O15 @uncheckedVariance] = newOutlet[O15]("out15")
}

class FanOutShape17[-I, +O0, +O1, +O2, +O3, +O4, +O5, +O6, +O7, +O8, +O9, +O10, +O11, +O12, +O13, +O14, +O15, +O16](_init: FanOutShape.Init[I @uncheckedVariance]) extends FanOutShape[I](_init) {
  def this(name: String) = this(FanOutShape.Name[I](name))
  def this(in: Inlet[I], out0: Outlet[O0], out1: Outlet[O1], out2: Outlet[O2], out3: Outlet[O3], out4: Outlet[O4], out5: Outlet[O5], out6: Outlet[O6], out7: Outlet[O7], out8: Outlet[O8], out9: Outlet[O9], out10: Outlet[O10], out11: Outlet[O11], out12: Outlet[O12], out13: Outlet[O13], out14: Outlet[O14], out15: Outlet[O15], out16: Outlet[O16]) = this(FanOutShape.Ports(in, out0 :: out1 :: out2 :: out3 :: out4 :: out5 :: out6 :: out7 :: out8 :: out9 :: out10 :: out11 :: out12 :: out13 :: out14 :: out15 :: out16 :: Nil))
  override protected def construct(init: FanOutShape.Init[I @uncheckedVariance]): FanOutShape[I] = new FanOutShape17(init)
  override def deepCopy(): FanOutShape17[I, O0, O1, O2, O3, O4, O5, O6, O7, O8, O9, O10, O11, O12, O13, O14, O15, O16] = super.deepCopy().asInstanceOf[FanOutShape17[I, O0, O1, O2, O3, O4, O5, O6, O7, O8, O9, O10, O11, O12, O13, O14, O15, O16]]
  
  val out0: Outlet[O0 @uncheckedVariance] = newOutlet[O0]("out0")
  val out1: Outlet[O1 @uncheckedVariance] = newOutlet[O1]("out1")
  val out2: Outlet[O2 @uncheckedVariance] = newOutlet[O2]("out2")
  val out3: Outlet[O3 @uncheckedVariance] = newOutlet[O3]("out3")
  val out4: Outlet[O4 @uncheckedVariance] = newOutlet[O4]("out4")
  val out5: Outlet[O5 @uncheckedVariance] = newOutlet[O5]("out5")
  val out6: Outlet[O6 @uncheckedVariance] = newOutlet[O6]("out6")
  val out7: Outlet[O7 @uncheckedVariance] = newOutlet[O7]("out7")
  val out8: Outlet[O8 @uncheckedVariance] = newOutlet[O8]("out8")
  val out9: Outlet[O9 @uncheckedVariance] = newOutlet[O9]("out9")
  val out10: Outlet[O10 @uncheckedVariance] = newOutlet[O10]("out10")
  val out11: Outlet[O11 @uncheckedVariance] = newOutlet[O11]("out11")
  val out12: Outlet[O12 @uncheckedVariance] = newOutlet[O12]("out12")
  val out13: Outlet[O13 @uncheckedVariance] = newOutlet[O13]("out13")
  val out14: Outlet[O14 @uncheckedVariance] = newOutlet[O14]("out14")
  val out15: Outlet[O15 @uncheckedVariance] = newOutlet[O15]("out15")
  val out16: Outlet[O16 @uncheckedVariance] = newOutlet[O16]("out16")
}

class FanOutShape18[-I, +O0, +O1, +O2, +O3, +O4, +O5, +O6, +O7, +O8, +O9, +O10, +O11, +O12, +O13, +O14, +O15, +O16, +O17](_init: FanOutShape.Init[I @uncheckedVariance]) extends FanOutShape[I](_init) {
  def this(name: String) = this(FanOutShape.Name[I](name))
  def this(in: Inlet[I], out0: Outlet[O0], out1: Outlet[O1], out2: Outlet[O2], out3: Outlet[O3], out4: Outlet[O4], out5: Outlet[O5], out6: Outlet[O6], out7: Outlet[O7], out8: Outlet[O8], out9: Outlet[O9], out10: Outlet[O10], out11: Outlet[O11], out12: Outlet[O12], out13: Outlet[O13], out14: Outlet[O14], out15: Outlet[O15], out16: Outlet[O16], out17: Outlet[O17]) = this(FanOutShape.Ports(in, out0 :: out1 :: out2 :: out3 :: out4 :: out5 :: out6 :: out7 :: out8 :: out9 :: out10 :: out11 :: out12 :: out13 :: out14 :: out15 :: out16 :: out17 :: Nil))
  override protected def construct(init: FanOutShape.Init[I @uncheckedVariance]): FanOutShape[I] = new FanOutShape18(init)
  override def deepCopy(): FanOutShape18[I, O0, O1, O2, O3, O4, O5, O6, O7, O8, O9, O10, O11, O12, O13, O14, O15, O16, O17] = super.deepCopy().asInstanceOf[FanOutShape18[I, O0, O1, O2, O3, O4, O5, O6, O7, O8, O9, O10, O11, O12, O13, O14, O15, O16, O17]]
  
  val out0: Outlet[O0 @uncheckedVariance] = newOutlet[O0]("out0")
  val out1: Outlet[O1 @uncheckedVariance] = newOutlet[O1]("out1")
  val out2: Outlet[O2 @uncheckedVariance] = newOutlet[O2]("out2")
  val out3: Outlet[O3 @uncheckedVariance] = newOutlet[O3]("out3")
  val out4: Outlet[O4 @uncheckedVariance] = newOutlet[O4]("out4")
  val out5: Outlet[O5 @uncheckedVariance] = newOutlet[O5]("out5")
  val out6: Outlet[O6 @uncheckedVariance] = newOutlet[O6]("out6")
  val out7: Outlet[O7 @uncheckedVariance] = newOutlet[O7]("out7")
  val out8: Outlet[O8 @uncheckedVariance] = newOutlet[O8]("out8")
  val out9: Outlet[O9 @uncheckedVariance] = newOutlet[O9]("out9")
  val out10: Outlet[O10 @uncheckedVariance] = newOutlet[O10]("out10")
  val out11: Outlet[O11 @uncheckedVariance] = newOutlet[O11]("out11")
  val out12: Outlet[O12 @uncheckedVariance] = newOutlet[O12]("out12")
  val out13: Outlet[O13 @uncheckedVariance] = newOutlet[O13]("out13")
  val out14: Outlet[O14 @uncheckedVariance] = newOutlet[O14]("out14")
  val out15: Outlet[O15 @uncheckedVariance] = newOutlet[O15]("out15")
  val out16: Outlet[O16 @uncheckedVariance] = newOutlet[O16]("out16")
  val out17: Outlet[O17 @uncheckedVariance] = newOutlet[O17]("out17")
}

class FanOutShape19[-I, +O0, +O1, +O2, +O3, +O4, +O5, +O6, +O7, +O8, +O9, +O10, +O11, +O12, +O13, +O14, +O15, +O16, +O17, +O18](_init: FanOutShape.Init[I @uncheckedVariance]) extends FanOutShape[I](_init) {
  def this(name: String) = this(FanOutShape.Name[I](name))
  def this(in: Inlet[I], out0: Outlet[O0], out1: Outlet[O1], out2: Outlet[O2], out3: Outlet[O3], out4: Outlet[O4], out5: Outlet[O5], out6: Outlet[O6], out7: Outlet[O7], out8: Outlet[O8], out9: Outlet[O9], out10: Outlet[O10], out11: Outlet[O11], out12: Outlet[O12], out13: Outlet[O13], out14: Outlet[O14], out15: Outlet[O15], out16: Outlet[O16], out17: Outlet[O17], out18: Outlet[O18]) = this(FanOutShape.Ports(in, out0 :: out1 :: out2 :: out3 :: out4 :: out5 :: out6 :: out7 :: out8 :: out9 :: out10 :: out11 :: out12 :: out13 :: out14 :: out15 :: out16 :: out17 :: out18 :: Nil))
  override protected def construct(init: FanOutShape.Init[I @uncheckedVariance]): FanOutShape[I] = new FanOutShape19(init)
  override def deepCopy(): FanOutShape19[I, O0, O1, O2, O3, O4, O5, O6, O7, O8, O9, O10, O11, O12, O13, O14, O15, O16, O17, O18] = super.deepCopy().asInstanceOf[FanOutShape19[I, O0, O1, O2, O3, O4, O5, O6, O7, O8, O9, O10, O11, O12, O13, O14, O15, O16, O17, O18]]
  
  val out0: Outlet[O0 @uncheckedVariance] = newOutlet[O0]("out0")
  val out1: Outlet[O1 @uncheckedVariance] = newOutlet[O1]("out1")
  val out2: Outlet[O2 @uncheckedVariance] = newOutlet[O2]("out2")
  val out3: Outlet[O3 @uncheckedVariance] = newOutlet[O3]("out3")
  val out4: Outlet[O4 @uncheckedVariance] = newOutlet[O4]("out4")
  val out5: Outlet[O5 @uncheckedVariance] = newOutlet[O5]("out5")
  val out6: Outlet[O6 @uncheckedVariance] = newOutlet[O6]("out6")
  val out7: Outlet[O7 @uncheckedVariance] = newOutlet[O7]("out7")
  val out8: Outlet[O8 @uncheckedVariance] = newOutlet[O8]("out8")
  val out9: Outlet[O9 @uncheckedVariance] = newOutlet[O9]("out9")
  val out10: Outlet[O10 @uncheckedVariance] = newOutlet[O10]("out10")
  val out11: Outlet[O11 @uncheckedVariance] = newOutlet[O11]("out11")
  val out12: Outlet[O12 @uncheckedVariance] = newOutlet[O12]("out12")
  val out13: Outlet[O13 @uncheckedVariance] = newOutlet[O13]("out13")
  val out14: Outlet[O14 @uncheckedVariance] = newOutlet[O14]("out14")
  val out15: Outlet[O15 @uncheckedVariance] = newOutlet[O15]("out15")
  val out16: Outlet[O16 @uncheckedVariance] = newOutlet[O16]("out16")
  val out17: Outlet[O17 @uncheckedVariance] = newOutlet[O17]("out17")
  val out18: Outlet[O18 @uncheckedVariance] = newOutlet[O18]("out18")
}

class FanOutShape20[-I, +O0, +O1, +O2, +O3, +O4, +O5, +O6, +O7, +O8, +O9, +O10, +O11, +O12, +O13, +O14, +O15, +O16, +O17, +O18, +O19](_init: FanOutShape.Init[I @uncheckedVariance]) extends FanOutShape[I](_init) {
  def this(name: String) = this(FanOutShape.Name[I](name))
  def this(in: Inlet[I], out0: Outlet[O0], out1: Outlet[O1], out2: Outlet[O2], out3: Outlet[O3], out4: Outlet[O4], out5: Outlet[O5], out6: Outlet[O6], out7: Outlet[O7], out8: Outlet[O8], out9: Outlet[O9], out10: Outlet[O10], out11: Outlet[O11], out12: Outlet[O12], out13: Outlet[O13], out14: Outlet[O14], out15: Outlet[O15], out16: Outlet[O16], out17: Outlet[O17], out18: Outlet[O18], out19: Outlet[O19]) = this(FanOutShape.Ports(in, out0 :: out1 :: out2 :: out3 :: out4 :: out5 :: out6 :: out7 :: out8 :: out9 :: out10 :: out11 :: out12 :: out13 :: out14 :: out15 :: out16 :: out17 :: out18 :: out19 :: Nil))
  override protected def construct(init: FanOutShape.Init[I @uncheckedVariance]): FanOutShape[I] = new FanOutShape20(init)
  override def deepCopy(): FanOutShape20[I, O0, O1, O2, O3, O4, O5, O6, O7, O8, O9, O10, O11, O12, O13, O14, O15, O16, O17, O18, O19] = super.deepCopy().asInstanceOf[FanOutShape20[I, O0, O1, O2, O3, O4, O5, O6, O7, O8, O9, O10, O11, O12, O13, O14, O15, O16, O17, O18, O19]]
  
  val out0: Outlet[O0 @uncheckedVariance] = newOutlet[O0]("out0")
  val out1: Outlet[O1 @uncheckedVariance] = newOutlet[O1]("out1")
  val out2: Outlet[O2 @uncheckedVariance] = newOutlet[O2]("out2")
  val out3: Outlet[O3 @uncheckedVariance] = newOutlet[O3]("out3")
  val out4: Outlet[O4 @uncheckedVariance] = newOutlet[O4]("out4")
  val out5: Outlet[O5 @uncheckedVariance] = newOutlet[O5]("out5")
  val out6: Outlet[O6 @uncheckedVariance] = newOutlet[O6]("out6")
  val out7: Outlet[O7 @uncheckedVariance] = newOutlet[O7]("out7")
  val out8: Outlet[O8 @uncheckedVariance] = newOutlet[O8]("out8")
  val out9: Outlet[O9 @uncheckedVariance] = newOutlet[O9]("out9")
  val out10: Outlet[O10 @uncheckedVariance] = newOutlet[O10]("out10")
  val out11: Outlet[O11 @uncheckedVariance] = newOutlet[O11]("out11")
  val out12: Outlet[O12 @uncheckedVariance] = newOutlet[O12]("out12")
  val out13: Outlet[O13 @uncheckedVariance] = newOutlet[O13]("out13")
  val out14: Outlet[O14 @uncheckedVariance] = newOutlet[O14]("out14")
  val out15: Outlet[O15 @uncheckedVariance] = newOutlet[O15]("out15")
  val out16: Outlet[O16 @uncheckedVariance] = newOutlet[O16]("out16")
  val out17: Outlet[O17 @uncheckedVariance] = newOutlet[O17]("out17")
  val out18: Outlet[O18 @uncheckedVariance] = newOutlet[O18]("out18")
  val out19: Outlet[O19 @uncheckedVariance] = newOutlet[O19]("out19")
}

class FanOutShape21[-I, +O0, +O1, +O2, +O3, +O4, +O5, +O6, +O7, +O8, +O9, +O10, +O11, +O12, +O13, +O14, +O15, +O16, +O17, +O18, +O19, +O20](_init: FanOutShape.Init[I @uncheckedVariance]) extends FanOutShape[I](_init) {
  def this(name: String) = this(FanOutShape.Name[I](name))
  def this(in: Inlet[I], out0: Outlet[O0], out1: Outlet[O1], out2: Outlet[O2], out3: Outlet[O3], out4: Outlet[O4], out5: Outlet[O5], out6: Outlet[O6], out7: Outlet[O7], out8: Outlet[O8], out9: Outlet[O9], out10: Outlet[O10], out11: Outlet[O11], out12: Outlet[O12], out13: Outlet[O13], out14: Outlet[O14], out15: Outlet[O15], out16: Outlet[O16], out17: Outlet[O17], out18: Outlet[O18], out19: Outlet[O19], out20: Outlet[O20]) = this(FanOutShape.Ports(in, out0 :: out1 :: out2 :: out3 :: out4 :: out5 :: out6 :: out7 :: out8 :: out9 :: out10 :: out11 :: out12 :: out13 :: out14 :: out15 :: out16 :: out17 :: out18 :: out19 :: out20 :: Nil))
  override protected def construct(init: FanOutShape.Init[I @uncheckedVariance]): FanOutShape[I] = new FanOutShape21(init)
  override def deepCopy(): FanOutShape21[I, O0, O1, O2, O3, O4, O5, O6, O7, O8, O9, O10, O11, O12, O13, O14, O15, O16, O17, O18, O19, O20] = super.deepCopy().asInstanceOf[FanOutShape21[I, O0, O1, O2, O3, O4, O5, O6, O7, O8, O9, O10, O11, O12, O13, O14, O15, O16, O17, O18, O19, O20]]
  
  val out0: Outlet[O0 @uncheckedVariance] = newOutlet[O0]("out0")
  val out1: Outlet[O1 @uncheckedVariance] = newOutlet[O1]("out1")
  val out2: Outlet[O2 @uncheckedVariance] = newOutlet[O2]("out2")
  val out3: Outlet[O3 @uncheckedVariance] = newOutlet[O3]("out3")
  val out4: Outlet[O4 @uncheckedVariance] = newOutlet[O4]("out4")
  val out5: Outlet[O5 @uncheckedVariance] = newOutlet[O5]("out5")
  val out6: Outlet[O6 @uncheckedVariance] = newOutlet[O6]("out6")
  val out7: Outlet[O7 @uncheckedVariance] = newOutlet[O7]("out7")
  val out8: Outlet[O8 @uncheckedVariance] = newOutlet[O8]("out8")
  val out9: Outlet[O9 @uncheckedVariance] = newOutlet[O9]("out9")
  val out10: Outlet[O10 @uncheckedVariance] = newOutlet[O10]("out10")
  val out11: Outlet[O11 @uncheckedVariance] = newOutlet[O11]("out11")
  val out12: Outlet[O12 @uncheckedVariance] = newOutlet[O12]("out12")
  val out13: Outlet[O13 @uncheckedVariance] = newOutlet[O13]("out13")
  val out14: Outlet[O14 @uncheckedVariance] = newOutlet[O14]("out14")
  val out15: Outlet[O15 @uncheckedVariance] = newOutlet[O15]("out15")
  val out16: Outlet[O16 @uncheckedVariance] = newOutlet[O16]("out16")
  val out17: Outlet[O17 @uncheckedVariance] = newOutlet[O17]("out17")
  val out18: Outlet[O18 @uncheckedVariance] = newOutlet[O18]("out18")
  val out19: Outlet[O19 @uncheckedVariance] = newOutlet[O19]("out19")
  val out20: Outlet[O20 @uncheckedVariance] = newOutlet[O20]("out20")
}

class FanOutShape22[-I, +O0, +O1, +O2, +O3, +O4, +O5, +O6, +O7, +O8, +O9, +O10, +O11, +O12, +O13, +O14, +O15, +O16, +O17, +O18, +O19, +O20, +O21](_init: FanOutShape.Init[I @uncheckedVariance]) extends FanOutShape[I](_init) {
  def this(name: String) = this(FanOutShape.Name[I](name))
  def this(in: Inlet[I], out0: Outlet[O0], out1: Outlet[O1], out2: Outlet[O2], out3: Outlet[O3], out4: Outlet[O4], out5: Outlet[O5], out6: Outlet[O6], out7: Outlet[O7], out8: Outlet[O8], out9: Outlet[O9], out10: Outlet[O10], out11: Outlet[O11], out12: Outlet[O12], out13: Outlet[O13], out14: Outlet[O14], out15: Outlet[O15], out16: Outlet[O16], out17: Outlet[O17], out18: Outlet[O18], out19: Outlet[O19], out20: Outlet[O20], out21: Outlet[O21]) = this(FanOutShape.Ports(in, out0 :: out1 :: out2 :: out3 :: out4 :: out5 :: out6 :: out7 :: out8 :: out9 :: out10 :: out11 :: out12 :: out13 :: out14 :: out15 :: out16 :: out17 :: out18 :: out19 :: out20 :: out21 :: Nil))
  override protected def construct(init: FanOutShape.Init[I @uncheckedVariance]): FanOutShape[I] = new FanOutShape22(init)
  override def deepCopy(): FanOutShape22[I, O0, O1, O2, O3, O4, O5, O6, O7, O8, O9, O10, O11, O12, O13, O14, O15, O16, O17, O18, O19, O20, O21] = super.deepCopy().asInstanceOf[FanOutShape22[I, O0, O1, O2, O3, O4, O5, O6, O7, O8, O9, O10, O11, O12, O13, O14, O15, O16, O17, O18, O19, O20, O21]]
  
  val out0: Outlet[O0 @uncheckedVariance] = newOutlet[O0]("out0")
  val out1: Outlet[O1 @uncheckedVariance] = newOutlet[O1]("out1")
  val out2: Outlet[O2 @uncheckedVariance] = newOutlet[O2]("out2")
  val out3: Outlet[O3 @uncheckedVariance] = newOutlet[O3]("out3")
  val out4: Outlet[O4 @uncheckedVariance] = newOutlet[O4]("out4")
  val out5: Outlet[O5 @uncheckedVariance] = newOutlet[O5]("out5")
  val out6: Outlet[O6 @uncheckedVariance] = newOutlet[O6]("out6")
  val out7: Outlet[O7 @uncheckedVariance] = newOutlet[O7]("out7")
  val out8: Outlet[O8 @uncheckedVariance] = newOutlet[O8]("out8")
  val out9: Outlet[O9 @uncheckedVariance] = newOutlet[O9]("out9")
  val out10: Outlet[O10 @uncheckedVariance] = newOutlet[O10]("out10")
  val out11: Outlet[O11 @uncheckedVariance] = newOutlet[O11]("out11")
  val out12: Outlet[O12 @uncheckedVariance] = newOutlet[O12]("out12")
  val out13: Outlet[O13 @uncheckedVariance] = newOutlet[O13]("out13")
  val out14: Outlet[O14 @uncheckedVariance] = newOutlet[O14]("out14")
  val out15: Outlet[O15 @uncheckedVariance] = newOutlet[O15]("out15")
  val out16: Outlet[O16 @uncheckedVariance] = newOutlet[O16]("out16")
  val out17: Outlet[O17 @uncheckedVariance] = newOutlet[O17]("out17")
  val out18: Outlet[O18 @uncheckedVariance] = newOutlet[O18]("out18")
  val out19: Outlet[O19 @uncheckedVariance] = newOutlet[O19]("out19")
  val out20: Outlet[O20 @uncheckedVariance] = newOutlet[O20]("out20")
  val out21: Outlet[O21 @uncheckedVariance] = newOutlet[O21]("out21")
}
