
package eu.toop.regrep.rs;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import eu.toop.regrep.query.QueryExceptionType;
import eu.toop.regrep.rim.ExtensibleObjectType;
import eu.toop.regrep.spi.CatalogingExceptionType;
import eu.toop.regrep.spi.FilteringExceptionType;
import eu.toop.regrep.spi.ValidationExceptionType;


/**
 * Base for all registry exceptions. Based upon SOAPFault: http://www.w3schools.com/soap/soap_fault.asp
 * 
 * <p>Java class for RegistryExceptionType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="RegistryExceptionType"&gt;
 *   &lt;complexContent&gt;
 *     &lt;extension base="{urn:oasis:names:tc:ebxml-regrep:xsd:rim:4.0}ExtensibleObjectType"&gt;
 *       &lt;attribute name="code" type="{http://www.w3.org/2001/XMLSchema}string" /&gt;
 *       &lt;attribute name="detail" type="{http://www.w3.org/2001/XMLSchema}string" /&gt;
 *       &lt;attribute name="message" type="{http://www.w3.org/2001/XMLSchema}string" /&gt;
 *       &lt;attribute name="severity" type="{urn:oasis:names:tc:ebxml-regrep:xsd:rim:4.0}objectReferenceType" default="urn:oasis:names:tc:ebxml-regrep:ErrorSeverityType:Error" /&gt;
 *     &lt;/extension&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * <p>This class was annotated by ph-jaxb22-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "RegistryExceptionType")
@XmlSeeAlso({
    AuthenticationExceptionType.class,
    AuthorizationExceptionType.class,
    InvalidRequestExceptionType.class,
    ObjectExistsExceptionType.class,
    ObjectNotFoundExceptionType.class,
    QuotaExceededExceptionType.class,
    ReferencesExistExceptionType.class,
    TimeoutExceptionType.class,
    UnresolvedReferenceExceptionType.class,
    UnsupportedCapabilityExceptionType.class,
    QueryExceptionType.class,
    ValidationExceptionType.class,
    CatalogingExceptionType.class,
    FilteringExceptionType.class
})
@CodingStyleguideUnaware
public class RegistryExceptionType
    extends ExtensibleObjectType
{

    @XmlAttribute(name = "code")
    private String code;
    @XmlAttribute(name = "detail")
    private String detail;
    @XmlAttribute(name = "message")
    private String message;
    @XmlAttribute(name = "severity")
    private String severity;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     */
    public RegistryExceptionType() {
    }

    /**
     * Gets the value of the code property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getCode() {
        return code;
    }

    /**
     * Sets the value of the code property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setCode(
        @Nullable
        String value) {
        this.code = value;
    }

    /**
     * Gets the value of the detail property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getDetail() {
        return detail;
    }

    /**
     * Sets the value of the detail property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setDetail(
        @Nullable
        String value) {
        this.detail = value;
    }

    /**
     * Gets the value of the message property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getMessage() {
        return message;
    }

    /**
     * Sets the value of the message property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setMessage(
        @Nullable
        String value) {
        this.message = value;
    }

    /**
     * Gets the value of the severity property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getSeverity() {
        if (severity == null) {
            return "urn:oasis:names:tc:ebxml-regrep:ErrorSeverityType:Error";
        } else {
            return severity;
        }
    }

    /**
     * Sets the value of the severity property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setSeverity(
        @Nullable
        String value) {
        this.severity = value;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        final RegistryExceptionType rhs = ((RegistryExceptionType) o);
        if (!EqualsHelper.equals(code, rhs.code)) {
            return false;
        }
        if (!EqualsHelper.equals(detail, rhs.detail)) {
            return false;
        }
        if (!EqualsHelper.equals(message, rhs.message)) {
            return false;
        }
        if (!EqualsHelper.equals(severity, rhs.severity)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived(super.hashCode()).append(code).append(detail).append(message).append(severity).getHashCode();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("code", code).append("detail", detail).append("message", message).append("severity", severity).getToString();
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        RegistryExceptionType ret) {
        super.cloneTo(ret);
        ret.code = code;
        ret.detail = detail;
        ret.message = message;
        ret.severity = severity;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public RegistryExceptionType clone() {
        RegistryExceptionType ret = new RegistryExceptionType();
        cloneTo(ret);
        return ret;
    }

}
