
package eu.toop.regrep.rim;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;


/**
 * 
 *         Represents an association or relationship between two RegistryObjects.
 *         The sourceObject is id of the sourceObject in association
 *         The targetObject is id of the targetObject in association
 *       
 * 
 * <p>Java class for AssociationType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="AssociationType"&gt;
 *   &lt;complexContent&gt;
 *     &lt;extension base="{urn:oasis:names:tc:ebxml-regrep:xsd:rim:4.0}RegistryObjectType"&gt;
 *       &lt;attribute name="type" use="required" type="{urn:oasis:names:tc:ebxml-regrep:xsd:rim:4.0}objectReferenceType" /&gt;
 *       &lt;attribute name="sourceObject" use="required" type="{urn:oasis:names:tc:ebxml-regrep:xsd:rim:4.0}objectReferenceType" /&gt;
 *       &lt;attribute name="targetObject" use="required" type="{urn:oasis:names:tc:ebxml-regrep:xsd:rim:4.0}objectReferenceType" /&gt;
 *     &lt;/extension&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * <p>This class was annotated by ph-jaxb22-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "AssociationType")
@CodingStyleguideUnaware
public class AssociationType
    extends RegistryObjectType
{

    @XmlAttribute(name = "type", required = true)
    private String type;
    @XmlAttribute(name = "sourceObject", required = true)
    private String sourceObject;
    @XmlAttribute(name = "targetObject", required = true)
    private String targetObject;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     */
    public AssociationType() {
    }

    /**
     * Gets the value of the type property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getType() {
        return type;
    }

    /**
     * Sets the value of the type property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setType(
        @Nullable
        String value) {
        this.type = value;
    }

    /**
     * Gets the value of the sourceObject property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getSourceObject() {
        return sourceObject;
    }

    /**
     * Sets the value of the sourceObject property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setSourceObject(
        @Nullable
        String value) {
        this.sourceObject = value;
    }

    /**
     * Gets the value of the targetObject property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getTargetObject() {
        return targetObject;
    }

    /**
     * Sets the value of the targetObject property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setTargetObject(
        @Nullable
        String value) {
        this.targetObject = value;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        final AssociationType rhs = ((AssociationType) o);
        if (!EqualsHelper.equals(sourceObject, rhs.sourceObject)) {
            return false;
        }
        if (!EqualsHelper.equals(targetObject, rhs.targetObject)) {
            return false;
        }
        if (!EqualsHelper.equals(type, rhs.type)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived(super.hashCode()).append(sourceObject).append(targetObject).append(type).getHashCode();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("sourceObject", sourceObject).append("targetObject", targetObject).append("type", type).getToString();
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        AssociationType ret) {
        super.cloneTo(ret);
        ret.sourceObject = sourceObject;
        ret.targetObject = targetObject;
        ret.type = type;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public AssociationType clone() {
        AssociationType ret = new AssociationType();
        cloneTo(ret);
        return ret;
    }

}
