
package eu.toop.regrep.query;

import java.math.BigInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import eu.toop.regrep.rim.QueryType;
import eu.toop.regrep.rs.RegistryRequestType;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType&gt;
 *   &lt;complexContent&gt;
 *     &lt;extension base="{urn:oasis:names:tc:ebxml-regrep:xsd:rs:4.0}RegistryRequestType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element name="ResponseOption" type="{urn:oasis:names:tc:ebxml-regrep:xsd:query:4.0}ResponseOptionType"/&gt;
 *         &lt;element name="Query" type="{urn:oasis:names:tc:ebxml-regrep:xsd:rim:4.0}QueryType"/&gt;
 *       &lt;/sequence&gt;
 *       &lt;attribute name="federated" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" /&gt;
 *       &lt;attribute name="federation" type="{http://www.w3.org/2001/XMLSchema}anyURI" /&gt;
 *       &lt;attribute name="format" type="{http://www.w3.org/2001/XMLSchema}string" default="application/ebrim+xml" /&gt;
 *       &lt;attribute ref="{http://www.w3.org/XML/1998/namespace}lang"/&gt;
 *       &lt;attribute name="startIndex" type="{http://www.w3.org/2001/XMLSchema}integer" default="0" /&gt;
 *       &lt;attribute name="maxResults" type="{http://www.w3.org/2001/XMLSchema}integer" default="-1" /&gt;
 *       &lt;attribute name="depth" type="{http://www.w3.org/2001/XMLSchema}integer" default="0" /&gt;
 *       &lt;attribute name="matchOlderVersions" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" /&gt;
 *     &lt;/extension&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * <p>This class was annotated by ph-jaxb22-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "responseOption",
    "query"
})
@XmlRootElement(name = "QueryRequest")
@CodingStyleguideUnaware
public class QueryRequest
    extends RegistryRequestType
{

    @XmlElement(name = "ResponseOption", required = true)
    private ResponseOptionType responseOption;
    @XmlElement(name = "Query", required = true)
    private QueryType query;
    @XmlAttribute(name = "federated")
    private Boolean federated;
    @XmlAttribute(name = "federation")
    @XmlSchemaType(name = "anyURI")
    private String federation;
    @XmlAttribute(name = "format")
    private String format;
    @XmlAttribute(name = "lang", namespace = "http://www.w3.org/XML/1998/namespace")
    private String lang;
    @XmlAttribute(name = "startIndex")
    private BigInteger startIndex;
    @XmlAttribute(name = "maxResults")
    private BigInteger maxResults;
    @XmlAttribute(name = "depth")
    private BigInteger depth;
    @XmlAttribute(name = "matchOlderVersions")
    private Boolean matchOlderVersions;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     */
    public QueryRequest() {
    }

    /**
     * Gets the value of the responseOption property.
     * 
     * @return
     *     possible object is
     *     {@link ResponseOptionType }
     *     
     */
    @Nullable
    public ResponseOptionType getResponseOption() {
        return responseOption;
    }

    /**
     * Sets the value of the responseOption property.
     * 
     * @param value
     *     allowed object is
     *     {@link ResponseOptionType }
     *     
     */
    public void setResponseOption(
        @Nullable
        ResponseOptionType value) {
        this.responseOption = value;
    }

    /**
     * Gets the value of the query property.
     * 
     * @return
     *     possible object is
     *     {@link QueryType }
     *     
     */
    @Nullable
    public QueryType getQuery() {
        return query;
    }

    /**
     * Sets the value of the query property.
     * 
     * @param value
     *     allowed object is
     *     {@link QueryType }
     *     
     */
    public void setQuery(
        @Nullable
        QueryType value) {
        this.query = value;
    }

    /**
     * Gets the value of the federated property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isFederated() {
        if (federated == null) {
            return false;
        } else {
            return federated;
        }
    }

    /**
     * Sets the value of the federated property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setFederated(
        @Nullable
        Boolean value) {
        this.federated = value;
    }

    /**
     * Gets the value of the federation property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getFederation() {
        return federation;
    }

    /**
     * Sets the value of the federation property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setFederation(
        @Nullable
        String value) {
        this.federation = value;
    }

    /**
     * Gets the value of the format property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getFormat() {
        if (format == null) {
            return "application/ebrim+xml";
        } else {
            return format;
        }
    }

    /**
     * Sets the value of the format property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setFormat(
        @Nullable
        String value) {
        this.format = value;
    }

    /**
     * Gets the value of the lang property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getLang() {
        return lang;
    }

    /**
     * Sets the value of the lang property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setLang(
        @Nullable
        String value) {
        this.lang = value;
    }

    /**
     * Gets the value of the startIndex property.
     * 
     * @return
     *     possible object is
     *     {@link BigInteger }
     *     
     */
    @Nullable
    public BigInteger getStartIndex() {
        if (startIndex == null) {
            return new BigInteger("0");
        } else {
            return startIndex;
        }
    }

    /**
     * Sets the value of the startIndex property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigInteger }
     *     
     */
    public void setStartIndex(
        @Nullable
        BigInteger value) {
        this.startIndex = value;
    }

    /**
     * Gets the value of the maxResults property.
     * 
     * @return
     *     possible object is
     *     {@link BigInteger }
     *     
     */
    @Nullable
    public BigInteger getMaxResults() {
        if (maxResults == null) {
            return new BigInteger("-1");
        } else {
            return maxResults;
        }
    }

    /**
     * Sets the value of the maxResults property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigInteger }
     *     
     */
    public void setMaxResults(
        @Nullable
        BigInteger value) {
        this.maxResults = value;
    }

    /**
     * Gets the value of the depth property.
     * 
     * @return
     *     possible object is
     *     {@link BigInteger }
     *     
     */
    @Nullable
    public BigInteger getDepth() {
        if (depth == null) {
            return new BigInteger("0");
        } else {
            return depth;
        }
    }

    /**
     * Sets the value of the depth property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigInteger }
     *     
     */
    public void setDepth(
        @Nullable
        BigInteger value) {
        this.depth = value;
    }

    /**
     * Gets the value of the matchOlderVersions property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isMatchOlderVersions() {
        if (matchOlderVersions == null) {
            return false;
        } else {
            return matchOlderVersions;
        }
    }

    /**
     * Sets the value of the matchOlderVersions property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setMatchOlderVersions(
        @Nullable
        Boolean value) {
        this.matchOlderVersions = value;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        final QueryRequest rhs = ((QueryRequest) o);
        if (!EqualsHelper.equals(depth, rhs.depth)) {
            return false;
        }
        if (!EqualsHelper.equals(federated, rhs.federated)) {
            return false;
        }
        if (!EqualsHelper.equals(federation, rhs.federation)) {
            return false;
        }
        if (!EqualsHelper.equals(format, rhs.format)) {
            return false;
        }
        if (!EqualsHelper.equals(lang, rhs.lang)) {
            return false;
        }
        if (!EqualsHelper.equals(matchOlderVersions, rhs.matchOlderVersions)) {
            return false;
        }
        if (!EqualsHelper.equals(maxResults, rhs.maxResults)) {
            return false;
        }
        if (!EqualsHelper.equals(query, rhs.query)) {
            return false;
        }
        if (!EqualsHelper.equals(responseOption, rhs.responseOption)) {
            return false;
        }
        if (!EqualsHelper.equals(startIndex, rhs.startIndex)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived(super.hashCode()).append(depth).append(federated).append(federation).append(format).append(lang).append(matchOlderVersions).append(maxResults).append(query).append(responseOption).append(startIndex).getHashCode();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("depth", depth).append("federated", federated).append("federation", federation).append("format", format).append("lang", lang).append("matchOlderVersions", matchOlderVersions).append("maxResults", maxResults).append("query", query).append("responseOption", responseOption).append("startIndex", startIndex).getToString();
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        QueryRequest ret) {
        super.cloneTo(ret);
        ret.depth = depth;
        ret.federated = federated;
        ret.federation = federation;
        ret.format = format;
        ret.lang = lang;
        ret.matchOlderVersions = matchOlderVersions;
        ret.maxResults = maxResults;
        ret.query = ((query == null)?null:query.clone());
        ret.responseOption = ((responseOption == null)?null:responseOption.clone());
        ret.startIndex = startIndex;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public QueryRequest clone() {
        QueryRequest ret = new QueryRequest();
        cloneTo(ret);
        return ret;
    }

}
