
package eu.toop.regrep.lcm;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import eu.toop.regrep.rim.ObjectRefListType;
import eu.toop.regrep.rim.QueryType;
import eu.toop.regrep.rs.RegistryRequestType;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType&gt;
 *   &lt;complexContent&gt;
 *     &lt;extension base="{urn:oasis:names:tc:ebxml-regrep:xsd:rs:4.0}RegistryRequestType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element name="Query" type="{urn:oasis:names:tc:ebxml-regrep:xsd:rim:4.0}QueryType" minOccurs="0"/&gt;
 *         &lt;element ref="{urn:oasis:names:tc:ebxml-regrep:xsd:rim:4.0}ObjectRefList" minOccurs="0"/&gt;
 *       &lt;/sequence&gt;
 *       &lt;attribute name="checkReferences" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" /&gt;
 *       &lt;attribute name="deleteChildren" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" /&gt;
 *       &lt;attribute name="deletionScope" type="{urn:oasis:names:tc:ebxml-regrep:xsd:rim:4.0}objectReferenceType" default="urn:oasis:names:tc:ebxml-regrep:DeletionScopeType:DeleteAll" /&gt;
 *     &lt;/extension&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * <p>This class was annotated by ph-jaxb22-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "query",
    "objectRefList"
})
@XmlRootElement(name = "RemoveObjectsRequest")
@CodingStyleguideUnaware
public class RemoveObjectsRequest
    extends RegistryRequestType
{

    @XmlElement(name = "Query")
    private QueryType query;
    @XmlElement(name = "ObjectRefList", namespace = "urn:oasis:names:tc:ebxml-regrep:xsd:rim:4.0")
    private ObjectRefListType objectRefList;
    @XmlAttribute(name = "checkReferences")
    private Boolean checkReferences;
    @XmlAttribute(name = "deleteChildren")
    private Boolean deleteChildren;
    @XmlAttribute(name = "deletionScope")
    private String deletionScope;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     */
    public RemoveObjectsRequest() {
    }

    /**
     * Gets the value of the query property.
     * 
     * @return
     *     possible object is
     *     {@link QueryType }
     *     
     */
    @Nullable
    public QueryType getQuery() {
        return query;
    }

    /**
     * Sets the value of the query property.
     * 
     * @param value
     *     allowed object is
     *     {@link QueryType }
     *     
     */
    public void setQuery(
        @Nullable
        QueryType value) {
        this.query = value;
    }

    /**
     * Gets the value of the objectRefList property.
     * 
     * @return
     *     possible object is
     *     {@link ObjectRefListType }
     *     
     */
    @Nullable
    public ObjectRefListType getObjectRefList() {
        return objectRefList;
    }

    /**
     * Sets the value of the objectRefList property.
     * 
     * @param value
     *     allowed object is
     *     {@link ObjectRefListType }
     *     
     */
    public void setObjectRefList(
        @Nullable
        ObjectRefListType value) {
        this.objectRefList = value;
    }

    /**
     * Gets the value of the checkReferences property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isCheckReferences() {
        if (checkReferences == null) {
            return false;
        } else {
            return checkReferences;
        }
    }

    /**
     * Sets the value of the checkReferences property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setCheckReferences(
        @Nullable
        Boolean value) {
        this.checkReferences = value;
    }

    /**
     * Gets the value of the deleteChildren property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isDeleteChildren() {
        if (deleteChildren == null) {
            return false;
        } else {
            return deleteChildren;
        }
    }

    /**
     * Sets the value of the deleteChildren property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setDeleteChildren(
        @Nullable
        Boolean value) {
        this.deleteChildren = value;
    }

    /**
     * Gets the value of the deletionScope property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getDeletionScope() {
        if (deletionScope == null) {
            return "urn:oasis:names:tc:ebxml-regrep:DeletionScopeType:DeleteAll";
        } else {
            return deletionScope;
        }
    }

    /**
     * Sets the value of the deletionScope property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setDeletionScope(
        @Nullable
        String value) {
        this.deletionScope = value;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        final RemoveObjectsRequest rhs = ((RemoveObjectsRequest) o);
        if (!EqualsHelper.equals(checkReferences, rhs.checkReferences)) {
            return false;
        }
        if (!EqualsHelper.equals(deleteChildren, rhs.deleteChildren)) {
            return false;
        }
        if (!EqualsHelper.equals(deletionScope, rhs.deletionScope)) {
            return false;
        }
        if (!EqualsHelper.equals(objectRefList, rhs.objectRefList)) {
            return false;
        }
        if (!EqualsHelper.equals(query, rhs.query)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived(super.hashCode()).append(checkReferences).append(deleteChildren).append(deletionScope).append(objectRefList).append(query).getHashCode();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("checkReferences", checkReferences).append("deleteChildren", deleteChildren).append("deletionScope", deletionScope).append("objectRefList", objectRefList).append("query", query).getToString();
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        RemoveObjectsRequest ret) {
        super.cloneTo(ret);
        ret.checkReferences = checkReferences;
        ret.deleteChildren = deleteChildren;
        ret.deletionScope = deletionScope;
        ret.objectRefList = ((objectRefList == null)?null:objectRefList.clone());
        ret.query = ((query == null)?null:query.clone());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public RemoveObjectsRequest clone() {
        RemoveObjectsRequest ret = new RemoveObjectsRequest();
        cloneTo(ret);
        return ret;
    }

}
