/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.iface.util;

import com.helger.commons.ValueEnforcer;
import com.helger.httpclient.HttpClientFactory;
import com.helger.httpclient.HttpClientManager;
import com.helger.httpclient.IHttpClientProvider;
import com.helger.httpclient.response.ResponseHandlerByteArray;
import java.io.IOException;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.apache.http.HttpEntity;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;

@Immutable
public final class HttpClientInvoker {
    private HttpClientInvoker() {
    }

    public static <T> void httpClientCall(@Nonnull String string, @Nonnull byte[] byArray, @Nonnull ResponseHandler<T> responseHandler, @Nonnull Consumer<? super T> consumer) throws IOException {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"DestinationURL");
        ValueEnforcer.notNull((Object)byArray, (String)"DataToSend");
        ValueEnforcer.notNull(responseHandler, (String)"ResponseHandler");
        ValueEnforcer.notNull(consumer, (String)"ResultHandler");
        HttpClientFactory httpClientFactory = new HttpClientFactory();
        httpClientFactory.setUseSystemProperties(true);
        try (HttpClientManager httpClientManager = new HttpClientManager((IHttpClientProvider)httpClientFactory);){
            HttpPost httpPost = new HttpPost(string);
            httpPost.setEntity((HttpEntity)new ByteArrayEntity(byArray));
            Object object = httpClientManager.execute((HttpUriRequest)httpPost, responseHandler);
            consumer.accept(object);
        }
    }

    public static void httpClientCallNoResponse(@Nonnull String string, @Nonnull byte[] byArray2) throws IOException {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"DestinationURL");
        ValueEnforcer.notNull((Object)byArray2, (String)"DataToSend");
        HttpClientInvoker.httpClientCall(string, byArray2, new ResponseHandlerByteArray(), byArray -> {});
    }
}

