/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.iface.servlet;

import eu.toop.commons.dataexchange.TDETOOPResponseType;
import eu.toop.commons.exchange.ToopMessageBuilder;
import eu.toop.iface.ToopInterfaceManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(value={"/to-dc"})
public class ToDCServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(ToDCServlet.class);

    protected void doPost(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Serializable serializable = ToopMessageBuilder.parseRequestOrResponse((InputStream)httpServletRequest.getInputStream());
        if (serializable == null) {
            LOGGER.error("The request does not contain an ASiC archive or the ASiC archive does not contain a TOOP Response Message or a TOOP Error Message!");
            httpServletResponse.setStatus(400);
        } else if (serializable instanceof TDETOOPResponseType) {
            ToopInterfaceManager.getInterfaceDC().onToopResponse((TDETOOPResponseType)serializable);
            httpServletResponse.setStatus(202);
        } else {
            LOGGER.error("The request contain an ASiC archive but with unsupported payload of type " + serializable.getClass().getName());
            httpServletResponse.setStatus(400);
        }
    }
}

