/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.iface;

import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.debug.GlobalDebug;
import com.helger.commons.state.ESuccess;
import com.helger.settings.exchange.configfile.ConfigFile;
import com.helger.settings.exchange.configfile.ConfigFileBuilder;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class ToopInterfaceConfig {
    private static final Logger s_aLogger = LoggerFactory.getLogger(ToopInterfaceConfig.class);
    private static final SimpleReadWriteLock s_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="s_aRWLock")
    private static ConfigFile s_aConfigFile;
    public static final String SYSTEM_PROPERTY_TOOP_MP_SERVER_PROPERTIES_PATH = "toop.interface.properties.path";
    public static final String PATH_PRIVATE_TOOP_INTERFACE_PROPERTIES = "private-toop-interface.properties";
    public static final String PATH_TOOP_INTERFACE_PROPERTIES = "toop-interface.properties";

    @Nonnull
    public static ESuccess reloadConfiguration() {
        ConfigFileBuilder configFileBuilder = new ConfigFileBuilder().addPathFromSystemProperty(SYSTEM_PROPERTY_TOOP_MP_SERVER_PROPERTIES_PATH).addPath(PATH_PRIVATE_TOOP_INTERFACE_PROPERTIES).addPath(PATH_TOOP_INTERFACE_PROPERTIES);
        return (ESuccess)s_aRWLock.writeLocked(() -> {
            s_aConfigFile = configFileBuilder.build();
            if (s_aConfigFile.isRead()) {
                s_aLogger.info("Read TOOP interface properties from " + s_aConfigFile.getReadResource().getPath());
                return ESuccess.SUCCESS;
            }
            s_aLogger.warn("Failed to read TOOP interface properties from " + configFileBuilder.getAllPaths());
            return ESuccess.FAILURE;
        });
    }

    private ToopInterfaceConfig() {
    }

    @Nonnull
    public static ConfigFile getConfigFile() {
        return (ConfigFile)s_aRWLock.readLocked(() -> s_aConfigFile);
    }

    public static boolean isGlobalDebug() {
        return ToopInterfaceConfig.getConfigFile().getAsBoolean((Object)"global.debug", GlobalDebug.isDebugMode());
    }

    public static boolean isGlobalProduction() {
        return ToopInterfaceConfig.getConfigFile().getAsBoolean((Object)"global.production", GlobalDebug.isProductionMode());
    }

    @Nullable
    public static String getToopConnectorDCUrl() {
        return ToopInterfaceConfig.getConfigFile().getAsString((Object)"toop.connector.dc.url");
    }

    @Nullable
    public static String getToopConnectorDPUrl() {
        return ToopInterfaceConfig.getConfigFile().getAsString((Object)"toop.connector.dp.url");
    }

    @Nullable
    public static String getKeystorePath() {
        return ToopInterfaceConfig.getConfigFile().getAsString((Object)"toop.keystore.path");
    }

    @Nullable
    public static String getKeystorePassword() {
        return ToopInterfaceConfig.getConfigFile().getAsString((Object)"toop.keystore.password");
    }

    @Nullable
    public static String getKeystoreKeyAlias() {
        return ToopInterfaceConfig.getConfigFile().getAsString((Object)"toop.keystore.key.alias");
    }

    @Nullable
    public static String getKeystoreKeyPassword() {
        return ToopInterfaceConfig.getConfigFile().getAsString((Object)"toop.keystore.key.password");
    }

    static {
        ToopInterfaceConfig.reloadConfiguration();
    }
}

