/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.iface;

import com.helger.asic.SignatureHelper;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.io.resourceprovider.DefaultResourceProvider;
import com.helger.commons.io.stream.NonBlockingByteArrayOutputStream;
import eu.toop.commons.codelist.EPredefinedDocumentTypeIdentifier;
import eu.toop.commons.codelist.EPredefinedProcessIdentifier;
import eu.toop.commons.concept.ConceptValue;
import eu.toop.commons.dataexchange.TDEDataRequestSubjectType;
import eu.toop.commons.dataexchange.TDETOOPRequestType;
import eu.toop.commons.dataexchange.TDETOOPResponseType;
import eu.toop.commons.exchange.ToopMessageBuilder;
import eu.toop.iface.ToopInterfaceConfig;
import eu.toop.iface.util.HttpClientInvoker;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import oasis.names.specification.ubl.schema.xsd.unqualifieddatatypes_21.IdentifierType;

@ThreadSafe
public final class ToopInterfaceClient {
    private ToopInterfaceClient() {
    }

    public static void createRequestAndSendToToopConnector(@Nonnull TDEDataRequestSubjectType tDEDataRequestSubjectType, @Nonnull @Nonempty IdentifierType identifierType, @Nonnull @Nonempty String string, @Nonnull EPredefinedDocumentTypeIdentifier ePredefinedDocumentTypeIdentifier, @Nonnull EPredefinedProcessIdentifier ePredefinedProcessIdentifier, @Nullable List<? extends ConceptValue> list) throws IOException {
        SignatureHelper signatureHelper = new SignatureHelper(new DefaultResourceProvider().getInputStream(ToopInterfaceConfig.getKeystorePath()), ToopInterfaceConfig.getKeystorePassword(), ToopInterfaceConfig.getKeystoreKeyAlias(), ToopInterfaceConfig.getKeystoreKeyPassword());
        try (NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream = new NonBlockingByteArrayOutputStream();){
            TDETOOPRequestType tDETOOPRequestType = ToopMessageBuilder.createMockRequest((TDEDataRequestSubjectType)tDEDataRequestSubjectType, (IdentifierType)identifierType, (String)string, (EPredefinedDocumentTypeIdentifier)ePredefinedDocumentTypeIdentifier, (EPredefinedProcessIdentifier)ePredefinedProcessIdentifier, list);
            ToopMessageBuilder.createRequestMessage((TDETOOPRequestType)tDETOOPRequestType, (OutputStream)nonBlockingByteArrayOutputStream, (SignatureHelper)signatureHelper);
            String string2 = ToopInterfaceConfig.getToopConnectorDCUrl();
            HttpClientInvoker.httpClientCallNoResponse(string2, nonBlockingByteArrayOutputStream.toByteArray());
        }
    }

    public static void sendResponseToToopConnector(@Nonnull TDETOOPResponseType tDETOOPResponseType) throws IOException {
        SignatureHelper signatureHelper = new SignatureHelper(new DefaultResourceProvider().getInputStream(ToopInterfaceConfig.getKeystorePath()), ToopInterfaceConfig.getKeystorePassword(), ToopInterfaceConfig.getKeystoreKeyAlias(), ToopInterfaceConfig.getKeystoreKeyPassword());
        try (NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream = new NonBlockingByteArrayOutputStream();){
            ToopMessageBuilder.createResponseMessage((TDETOOPResponseType)tDETOOPResponseType, (OutputStream)nonBlockingByteArrayOutputStream, (SignatureHelper)signatureHelper);
            String string = ToopInterfaceConfig.getToopConnectorDPUrl();
            HttpClientInvoker.httpClientCallNoResponse(string, nonBlockingByteArrayOutputStream.toByteArray());
        }
    }
}

