/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.iface.util;

import com.helger.commons.exception.InitializationException;
import com.helger.httpclient.HttpClientFactory;
import eu.toop.iface.ToopInterfaceConfig;
import java.security.GeneralSecurityException;
import org.apache.http.HttpHost;

public final class TCHttpClientFactory
extends HttpClientFactory {
    public TCHttpClientFactory() {
        if (ToopInterfaceConfig.isUseHttpSystemProperties()) {
            this.setUseSystemProperties(true);
        } else {
            if (ToopInterfaceConfig.isProxyServerEnabled()) {
                this.setProxy(new HttpHost(ToopInterfaceConfig.getProxyServerAddress(), ToopInterfaceConfig.getProxyServerPort()));
                this.addNonProxyHostsFromPipeString(ToopInterfaceConfig.getProxyServerNonProxyHosts());
            }
            if (ToopInterfaceConfig.isTLSTrustAll()) {
                try {
                    this.setSSLContextTrustAll();
                    this.setHostnameVerifierVerifyAll();
                }
                catch (GeneralSecurityException generalSecurityException) {
                    throw new InitializationException((Throwable)generalSecurityException);
                }
            }
        }
    }
}

