/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.iface.servlet;

import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import eu.toop.commons.dataexchange.v140.TDETOOPResponseType;
import eu.toop.commons.exchange.ToopMessageBuilder140;
import eu.toop.commons.exchange.ToopResponseWithAttachments140;
import eu.toop.iface.ToopInterfaceManager;
import eu.toop.iface.servlet.AbstractToopInterfaceServlet;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(value={"/to-dc"})
public class ToDCServlet
extends AbstractToopInterfaceServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(ToDCServlet.class);

    @Override
    protected void doPost(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Received new HTTP POST on /to-dc");
        }
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        Serializable serializable = ToopMessageBuilder140.parseRequestOrResponse((InputStream)httpServletRequest.getInputStream(), arg_0 -> ((ICommonsList)commonsArrayList).add(arg_0));
        if (serializable == null) {
            LOGGER.error("The /to-dc request does not contain an ASiC archive or the ASiC archive does not contain a TOOP Response Message or a TOOP Error Message!");
            httpServletResponse.setStatus(400);
        } else if (serializable instanceof TDETOOPResponseType) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Successfully parsed to a TOOP response");
            }
            ToopResponseWithAttachments140 toopResponseWithAttachments140 = new ToopResponseWithAttachments140((TDETOOPResponseType)serializable, (ICommonsList)commonsArrayList);
            ToopInterfaceManager.getInterfaceDC().onToopResponse(toopResponseWithAttachments140);
            httpServletResponse.setStatus(202);
        } else {
            LOGGER.error("The /to-dc request contains an ASiC archive but with unsupported payload of type " + serializable.getClass().getName());
            httpServletResponse.setStatus(400);
        }
    }
}

