/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.iface;

import com.helger.commons.concurrent.SimpleReadWriteLock;
import eu.toop.iface.IToopInterfaceDC;
import eu.toop.iface.IToopInterfaceDP;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class ToopInterfaceManager {
    private static final SimpleReadWriteLock s_aRWLock = new SimpleReadWriteLock();
    private static IToopInterfaceDC s_aInterfaceDC;
    private static IToopInterfaceDP s_aInterfaceDP;

    private ToopInterfaceManager() {
    }

    @Nonnull
    public static IToopInterfaceDC getInterfaceDC() {
        IToopInterfaceDC iToopInterfaceDC = (IToopInterfaceDC)s_aRWLock.readLocked(() -> s_aInterfaceDC);
        if (iToopInterfaceDC == null) {
            throw new IllegalStateException("No DC interface present!");
        }
        return iToopInterfaceDC;
    }

    public static void setInterfaceDC(@Nullable IToopInterfaceDC iToopInterfaceDC) {
        s_aRWLock.writeLocked(() -> {
            s_aInterfaceDC = iToopInterfaceDC;
            return s_aInterfaceDC;
        });
    }

    @Nonnull
    public static IToopInterfaceDP getInterfaceDP() {
        IToopInterfaceDP iToopInterfaceDP = (IToopInterfaceDP)s_aRWLock.readLocked(() -> s_aInterfaceDP);
        if (iToopInterfaceDP == null) {
            throw new IllegalStateException("No DP interface present!");
        }
        return iToopInterfaceDP;
    }

    public static void setInterfaceDP(@Nullable IToopInterfaceDP iToopInterfaceDP) {
        s_aRWLock.writeLocked(() -> {
            s_aInterfaceDP = iToopInterfaceDP;
            return s_aInterfaceDP;
        });
    }
}

