/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.iface;

import com.helger.asic.SignatureHelper;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.io.stream.NonBlockingByteArrayOutputStream;
import com.helger.commons.string.StringHelper;
import com.helger.commons.wrapper.Wrapper;
import com.helger.httpclient.response.ResponseHandlerByteArray;
import com.helger.pd.searchapi.PDSearchAPIReader;
import com.helger.pd.searchapi.v1.ResultListType;
import eu.toop.commons.codelist.EPredefinedDocumentTypeIdentifier;
import eu.toop.commons.codelist.EPredefinedProcessIdentifier;
import eu.toop.commons.concept.ConceptValue;
import eu.toop.commons.dataexchange.v140.TDEDataRequestSubjectType;
import eu.toop.commons.dataexchange.v140.TDETOOPRequestType;
import eu.toop.commons.dataexchange.v140.TDETOOPResponseType;
import eu.toop.commons.error.ToopErrorException;
import eu.toop.commons.exchange.AsicWriteEntry;
import eu.toop.commons.exchange.ToopMessageBuilder140;
import eu.toop.iface.ToopInterfaceConfig;
import eu.toop.iface.util.HttpClientInvoker;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import oasis.names.specification.ubl.schema.xsd.unqualifieddatatypes_21.IdentifierType;

@ThreadSafe
public final class ToopInterfaceClient {
    private ToopInterfaceClient() {
    }

    @Nonnull
    @ReturnsMutableCopy
    private static SignatureHelper createSH() {
        return new SignatureHelper(ToopInterfaceConfig.getKeystoreType(), ToopInterfaceConfig.getKeystorePath(), ToopInterfaceConfig.getKeystorePassword(), ToopInterfaceConfig.getKeystoreKeyAlias(), ToopInterfaceConfig.getKeystoreKeyPassword());
    }

    @Deprecated
    public static void createRequestAndSendToToopConnector(@Nonnull TDEDataRequestSubjectType tDEDataRequestSubjectType, @Nonnull String string, @Nonnull String string2, @Nonnull @Nonempty IdentifierType identifierType, @Nonnull EPredefinedDocumentTypeIdentifier ePredefinedDocumentTypeIdentifier, @Nonnull EPredefinedProcessIdentifier ePredefinedProcessIdentifier, @Nullable List<? extends ConceptValue> list) throws IOException, ToopErrorException {
        TDETOOPRequestType tDETOOPRequestType = ToopMessageBuilder140.createMockRequest((TDEDataRequestSubjectType)tDEDataRequestSubjectType, (String)string, (String)string2, (IdentifierType)identifierType, (EPredefinedDocumentTypeIdentifier)ePredefinedDocumentTypeIdentifier, (EPredefinedProcessIdentifier)ePredefinedProcessIdentifier, list);
        ToopInterfaceClient.sendRequestToToopConnector(tDETOOPRequestType);
    }

    public static void sendRequestToToopConnector(@Nonnull TDETOOPRequestType tDETOOPRequestType) throws IOException, ToopErrorException {
        ToopInterfaceClient.sendRequestToToopConnector(tDETOOPRequestType, ToopInterfaceConfig.getToopConnectorDCUrl());
    }

    public static void sendRequestToToopConnector(@Nonnull TDETOOPRequestType tDETOOPRequestType, @Nonnull String string) throws IOException, ToopErrorException {
        ValueEnforcer.notNull((Object)tDETOOPRequestType, (String)"Request");
        ValueEnforcer.notNull((Object)string, (String)"TargetURL");
        SignatureHelper signatureHelper = ToopInterfaceClient.createSH();
        try (NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream = new NonBlockingByteArrayOutputStream();){
            ToopMessageBuilder140.createRequestMessageAsic((TDETOOPRequestType)tDETOOPRequestType, (OutputStream)nonBlockingByteArrayOutputStream, (SignatureHelper)signatureHelper);
            HttpClientInvoker.httpClientCallNoResponse(string, nonBlockingByteArrayOutputStream.toByteArray());
        }
    }

    public static void sendResponseToToopConnector(@Nonnull TDETOOPResponseType tDETOOPResponseType, @Nullable ICommonsList<AsicWriteEntry> iCommonsList) throws IOException, ToopErrorException {
        ToopInterfaceClient.sendResponseToToopConnector(tDETOOPResponseType, iCommonsList, ToopInterfaceConfig.getToopConnectorDPUrl());
    }

    public static void sendResponseToToopConnector(@Nonnull TDETOOPResponseType tDETOOPResponseType, @Nullable ICommonsList<AsicWriteEntry> iCommonsList, @Nonnull String string) throws IOException, ToopErrorException {
        ValueEnforcer.notNull((Object)tDETOOPResponseType, (String)"Response");
        ValueEnforcer.notNull((Object)string, (String)"TargetURL");
        SignatureHelper signatureHelper = ToopInterfaceClient.createSH();
        try (NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream = new NonBlockingByteArrayOutputStream();){
            ToopMessageBuilder140.createResponseMessageAsic((TDETOOPResponseType)tDETOOPResponseType, (OutputStream)nonBlockingByteArrayOutputStream, (SignatureHelper)signatureHelper, iCommonsList);
            HttpClientInvoker.httpClientCallNoResponse(string, nonBlockingByteArrayOutputStream.toByteArray());
        }
    }

    public static void sendResponseToToopConnector(@Nonnull TDETOOPResponseType tDETOOPResponseType, @Nonnull String string, @Nullable Iterable<? extends AsicWriteEntry> iterable) throws IOException, ToopErrorException {
        ValueEnforcer.notNull((Object)tDETOOPResponseType, (String)"Response");
        ValueEnforcer.notNull((Object)string, (String)"TargetURL");
        SignatureHelper signatureHelper = ToopInterfaceClient.createSH();
        try (NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream = new NonBlockingByteArrayOutputStream();){
            ToopMessageBuilder140.createResponseMessageAsic((TDETOOPResponseType)tDETOOPResponseType, (OutputStream)nonBlockingByteArrayOutputStream, (SignatureHelper)signatureHelper, iterable);
            HttpClientInvoker.httpClientCallNoResponse(string, nonBlockingByteArrayOutputStream.toByteArray());
        }
    }

    @Nullable
    public static ResultListType searchDataProvider(@Nonnull @Nonempty String string, @Nullable String string2) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"CountryCode");
        String string3 = ToopInterfaceConfig.getToopConnectorUrl() + "/search-dp/" + string;
        if (StringHelper.hasText((String)string2)) {
            string3 = string3 + '/' + string2;
        }
        try {
            Wrapper wrapper = new Wrapper();
            HttpClientInvoker.httpClientCallGet(string3, new ResponseHandlerByteArray(), byArray -> wrapper.set(PDSearchAPIReader.resultListV1().read(byArray)));
            return (ResultListType)wrapper.get();
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }
}

