/**
 * Copyright (C) 2018-2019 toop.eu
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package eu.toop.iface;

import static org.junit.Assert.assertEquals;

import org.junit.Test;

/**
 * Test class for class {@link ToopInterfaceConfig}.
 *
 * @author Philip Helger
 */
public final class ToopInterfaceConfigTest
{
  @Test
  public void testBasic ()
  {
    assertEquals ("http://mp.elonia.toop:8083/from-dc", ToopInterfaceConfig.getToopConnectorDCUrl ());
    assertEquals ("http://mp.elonia.toop:8083/from-dp", ToopInterfaceConfig.getToopConnectorDPUrl ());
  }
}
