/**
 * Copyright (C) 2018-2020 toop.eu
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package eu.toop.edm.schematron;

import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;

import com.helger.commons.io.resource.IReadableResource;

/**
 * TOOP Schematron validator for the 2.0.0 data model Business Rules. Apply only
 * <b>after</b> EDM. Validate DOM documents or other resources using the
 * predefined TOOP Schematron rules. This should be run AFTER
 * {@link SchematronEDM2Validator}.
 *
 * @author Philip Helger
 */
@ThreadSafe
public class SchematronBusinessRules2Validator extends AbstractSchematronValidator
{
  public SchematronBusinessRules2Validator ()
  {}

  @Override
  @Nonnull
  protected final IReadableResource getSchematronXSLTResource ()
  {
    return CEDMSchematron.TOOP_BUSINESS_RULES_XSLT;
  }
}
