
package eu.toop.edm.jaxb.w3.cv.ac;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import eu.toop.edm.jaxb.w3.cv.bc.GeometryCoordinateReferenceSystemIDType;
import eu.toop.edm.jaxb.w3.cv.bc.GeometryCoordinatesType;
import eu.toop.edm.jaxb.w3.cv.bc.GeometryTypeCodeType;


/**
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cva="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cvb="http://www.w3.org/ns/corevocabulary/BasicComponents" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ABIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Geometry. Details&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;A geometry representing a location.&lt;/ccts:Definition&gt;&lt;ccts:ObjectClass&gt;Geometry&lt;/ccts:ObjectClass&gt;&lt;/ccts:Component&gt;
 * </pre>
 * 
 * 
 * <p>Java class for GeometryType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="GeometryType"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element ref="{http://www.w3.org/ns/corevocabulary/BasicComponents}GeometryCoordinateReferenceSystemID" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.w3.org/ns/corevocabulary/BasicComponents}GeometryTypeCode" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.w3.org/ns/corevocabulary/BasicComponents}GeometryCoordinates" maxOccurs="unbounded" minOccurs="0"/&gt;
 *       &lt;/sequence&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * <p>This class was annotated by ph-jaxb22-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "GeometryType", propOrder = {
    "geometryCoordinateReferenceSystemID",
    "geometryTypeCode",
    "geometryCoordinates"
})
@CodingStyleguideUnaware
public class GeometryType implements Serializable, IExplicitlyCloneable
{

    @XmlElement(name = "GeometryCoordinateReferenceSystemID", namespace = "http://www.w3.org/ns/corevocabulary/BasicComponents")
    private List<GeometryCoordinateReferenceSystemIDType> geometryCoordinateReferenceSystemID;
    @XmlElement(name = "GeometryTypeCode", namespace = "http://www.w3.org/ns/corevocabulary/BasicComponents")
    private GeometryTypeCodeType geometryTypeCode;
    @XmlElement(name = "GeometryCoordinates", namespace = "http://www.w3.org/ns/corevocabulary/BasicComponents")
    private List<GeometryCoordinatesType> geometryCoordinates;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     */
    public GeometryType() {
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cva="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cvb="http://www.w3.org/ns/corevocabulary/BasicComponents" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Geometry. Geometry Coordinate Reference System. Identifier&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;The Coordinate Reference System (CRS) used to encode the coordinates.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Geometry&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Geometry Coordinate Reference System&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Identifier&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Identifier. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * Gets the value of the geometryCoordinateReferenceSystemID property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the geometryCoordinateReferenceSystemID property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getGeometryCoordinateReferenceSystemID().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link GeometryCoordinateReferenceSystemIDType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<GeometryCoordinateReferenceSystemIDType> getGeometryCoordinateReferenceSystemID() {
        if (geometryCoordinateReferenceSystemID == null) {
            geometryCoordinateReferenceSystemID = new ArrayList<GeometryCoordinateReferenceSystemIDType>();
        }
        return this.geometryCoordinateReferenceSystemID;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cva="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cvb="http://www.w3.org/ns/corevocabulary/BasicComponents" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Geometry. Geometry Type. Code&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;The type of the geometry.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Geometry&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Geometry Type&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Code&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Code. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     * 
     * @return
     *     possible object is
     *     {@link GeometryTypeCodeType }
     *     
     */
    @Nullable
    public GeometryTypeCodeType getGeometryTypeCode() {
        return geometryTypeCode;
    }

    /**
     * Sets the value of the geometryTypeCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link GeometryTypeCodeType }
     *     
     */
    public void setGeometryTypeCode(
        @Nullable
        GeometryTypeCodeType value) {
        this.geometryTypeCode = value;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cva="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cvb="http://www.w3.org/ns/corevocabulary/BasicComponents" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Geometry. Geometry Coordinates. Text&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;The ordered list of coordinates of the geometry.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Geometry&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Geometry Coordinates&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Text&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Text. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * Gets the value of the geometryCoordinates property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the geometryCoordinates property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getGeometryCoordinates().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link GeometryCoordinatesType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<GeometryCoordinatesType> getGeometryCoordinates() {
        if (geometryCoordinates == null) {
            geometryCoordinates = new ArrayList<GeometryCoordinatesType>();
        }
        return this.geometryCoordinates;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final GeometryType rhs = ((GeometryType) o);
        if (!EqualsHelper.equalsCollection(geometryCoordinateReferenceSystemID, rhs.geometryCoordinateReferenceSystemID)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(geometryCoordinates, rhs.geometryCoordinates)) {
            return false;
        }
        if (!EqualsHelper.equals(geometryTypeCode, rhs.geometryTypeCode)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(geometryCoordinateReferenceSystemID).append(geometryCoordinates).append(geometryTypeCode).getHashCode();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("geometryCoordinateReferenceSystemID", geometryCoordinateReferenceSystemID).append("geometryCoordinates", geometryCoordinates).append("geometryTypeCode", geometryTypeCode).getToString();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setGeometryCoordinateReferenceSystemID(
        @Nullable
        final List<GeometryCoordinateReferenceSystemIDType> aList) {
        geometryCoordinateReferenceSystemID = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setGeometryCoordinates(
        @Nullable
        final List<GeometryCoordinatesType> aList) {
        geometryCoordinates = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasGeometryCoordinateReferenceSystemIDEntries() {
        return (!getGeometryCoordinateReferenceSystemID().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoGeometryCoordinateReferenceSystemIDEntries() {
        return getGeometryCoordinateReferenceSystemID().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getGeometryCoordinateReferenceSystemIDCount() {
        return getGeometryCoordinateReferenceSystemID().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public GeometryCoordinateReferenceSystemIDType getGeometryCoordinateReferenceSystemIDAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getGeometryCoordinateReferenceSystemID().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addGeometryCoordinateReferenceSystemID(
        @Nonnull
        final GeometryCoordinateReferenceSystemIDType elem) {
        getGeometryCoordinateReferenceSystemID().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasGeometryCoordinatesEntries() {
        return (!getGeometryCoordinates().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoGeometryCoordinatesEntries() {
        return getGeometryCoordinates().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getGeometryCoordinatesCount() {
        return getGeometryCoordinates().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public GeometryCoordinatesType getGeometryCoordinatesAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getGeometryCoordinates().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addGeometryCoordinates(
        @Nonnull
        final GeometryCoordinatesType elem) {
        getGeometryCoordinates().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        GeometryType ret) {
        if (geometryCoordinateReferenceSystemID == null) {
            ret.geometryCoordinateReferenceSystemID = null;
        } else {
            List<GeometryCoordinateReferenceSystemIDType> retGeometryCoordinateReferenceSystemID = new ArrayList<GeometryCoordinateReferenceSystemIDType>();
            for (GeometryCoordinateReferenceSystemIDType aItem: getGeometryCoordinateReferenceSystemID()) {
                retGeometryCoordinateReferenceSystemID.add(((aItem == null)?null:aItem.clone()));
            }
            ret.geometryCoordinateReferenceSystemID = retGeometryCoordinateReferenceSystemID;
        }
        if (geometryCoordinates == null) {
            ret.geometryCoordinates = null;
        } else {
            List<GeometryCoordinatesType> retGeometryCoordinates = new ArrayList<GeometryCoordinatesType>();
            for (GeometryCoordinatesType aItem: getGeometryCoordinates()) {
                retGeometryCoordinates.add(((aItem == null)?null:aItem.clone()));
            }
            ret.geometryCoordinates = retGeometryCoordinates;
        }
        ret.geometryTypeCode = ((geometryTypeCode == null)?null:geometryTypeCode.clone());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public GeometryType clone() {
        GeometryType ret = new GeometryType();
        cloneTo(ret);
        return ret;
    }

}
