
package eu.toop.edm.jaxb.w3.cv.ac;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import eu.toop.edm.jaxb.w3.cv.bc.LegalEntityAlternativeNameType;
import eu.toop.edm.jaxb.w3.cv.bc.LegalEntityCompanyActivityCodeType;
import eu.toop.edm.jaxb.w3.cv.bc.LegalEntityCompanyStatusCodeType;
import eu.toop.edm.jaxb.w3.cv.bc.LegalEntityCompanyTypeCodeType;
import eu.toop.edm.jaxb.w3.cv.bc.LegalEntityIDType;
import eu.toop.edm.jaxb.w3.cv.bc.LegalEntityLegalIDType;
import eu.toop.edm.jaxb.w3.cv.bc.LegalEntityLegalNameType;


/**
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cva="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cvb="http://www.w3.org/ns/corevocabulary/BasicComponents" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ABIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Core Business. Details&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;A business that is legally registered.&lt;/ccts:Definition&gt;&lt;ccts:ObjectClass&gt;Core Business&lt;/ccts:ObjectClass&gt;&lt;/ccts:Component&gt;
 * </pre>
 * 
 * 
 * <p>Java class for CoreBusinessType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="CoreBusinessType"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element ref="{http://www.w3.org/ns/corevocabulary/BasicComponents}LegalEntityLegalID" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.w3.org/ns/corevocabulary/BasicComponents}LegalEntityID" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.w3.org/ns/corevocabulary/BasicComponents}LegalEntityLegalName" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.w3.org/ns/corevocabulary/BasicComponents}LegalEntityAlternativeName" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.w3.org/ns/corevocabulary/BasicComponents}LegalEntityCompanyTypeCode" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.w3.org/ns/corevocabulary/BasicComponents}LegalEntityCompanyStatusCode" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.w3.org/ns/corevocabulary/BasicComponents}LegalEntityCompanyActivityCode" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.w3.org/ns/corevocabulary/AggregateComponents}RegisteredCoreAddress" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.w3.org/ns/corevocabulary/AggregateComponents}LegalEntityCoreAddress" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.w3.org/ns/corevocabulary/AggregateComponents}LegalEntityCoreLocation" minOccurs="0"/&gt;
 *       &lt;/sequence&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * <p>This class was annotated by ph-jaxb22-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "CoreBusinessType", propOrder = {
    "legalEntityLegalID",
    "legalEntityID",
    "legalEntityLegalName",
    "legalEntityAlternativeName",
    "legalEntityCompanyTypeCode",
    "legalEntityCompanyStatusCode",
    "legalEntityCompanyActivityCode",
    "registeredCoreAddress",
    "legalEntityCoreAddress",
    "legalEntityCoreLocation"
})
@CodingStyleguideUnaware
public class CoreBusinessType implements Serializable, IExplicitlyCloneable
{

    @XmlElement(name = "LegalEntityLegalID", namespace = "http://www.w3.org/ns/corevocabulary/BasicComponents")
    private List<LegalEntityLegalIDType> legalEntityLegalID;
    @XmlElement(name = "LegalEntityID", namespace = "http://www.w3.org/ns/corevocabulary/BasicComponents")
    private List<LegalEntityIDType> legalEntityID;
    @XmlElement(name = "LegalEntityLegalName", namespace = "http://www.w3.org/ns/corevocabulary/BasicComponents")
    private List<LegalEntityLegalNameType> legalEntityLegalName;
    @XmlElement(name = "LegalEntityAlternativeName", namespace = "http://www.w3.org/ns/corevocabulary/BasicComponents")
    private List<LegalEntityAlternativeNameType> legalEntityAlternativeName;
    @XmlElement(name = "LegalEntityCompanyTypeCode", namespace = "http://www.w3.org/ns/corevocabulary/BasicComponents")
    private LegalEntityCompanyTypeCodeType legalEntityCompanyTypeCode;
    @XmlElement(name = "LegalEntityCompanyStatusCode", namespace = "http://www.w3.org/ns/corevocabulary/BasicComponents")
    private LegalEntityCompanyStatusCodeType legalEntityCompanyStatusCode;
    @XmlElement(name = "LegalEntityCompanyActivityCode", namespace = "http://www.w3.org/ns/corevocabulary/BasicComponents")
    private List<LegalEntityCompanyActivityCodeType> legalEntityCompanyActivityCode;
    @XmlElement(name = "RegisteredCoreAddress")
    private CoreAddressType registeredCoreAddress;
    @XmlElement(name = "LegalEntityCoreAddress")
    private CoreAddressType legalEntityCoreAddress;
    @XmlElement(name = "LegalEntityCoreLocation")
    private CoreLocationType legalEntityCoreLocation;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     */
    public CoreBusinessType() {
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cva="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cvb="http://www.w3.org/ns/corevocabulary/BasicComponents" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Core Business. Legal Entity_ Legal Identifier. Identifier&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;The identifier given to the legal entity by the authority with which it is registered.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Core Business&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Legal Entity&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Legal Identifier&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Identifier&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Identifier. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * Gets the value of the legalEntityLegalID property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the legalEntityLegalID property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getLegalEntityLegalID().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link LegalEntityLegalIDType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<LegalEntityLegalIDType> getLegalEntityLegalID() {
        if (legalEntityLegalID == null) {
            legalEntityLegalID = new ArrayList<LegalEntityLegalIDType>();
        }
        return this.legalEntityLegalID;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cva="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cvb="http://www.w3.org/ns/corevocabulary/BasicComponents" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Core Business. Legal Entity_ Identifier. Identifier&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;A formally-issued identifier for the legal entity, other than the one that confers legal status upon it.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;1..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Core Business&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Legal Entity&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Identifier&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Identifier&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Identifier. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * Gets the value of the legalEntityID property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the legalEntityID property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getLegalEntityID().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link LegalEntityIDType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<LegalEntityIDType> getLegalEntityID() {
        if (legalEntityID == null) {
            legalEntityID = new ArrayList<LegalEntityIDType>();
        }
        return this.legalEntityID;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cva="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cvb="http://www.w3.org/ns/corevocabulary/BasicComponents" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Core Business. Legal Entity_ Legal Name. Name&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;The legal name of the business.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Core Business&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Legal Entity&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Legal Name&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Name&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Name. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * Gets the value of the legalEntityLegalName property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the legalEntityLegalName property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getLegalEntityLegalName().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link LegalEntityLegalNameType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<LegalEntityLegalNameType> getLegalEntityLegalName() {
        if (legalEntityLegalName == null) {
            legalEntityLegalName = new ArrayList<LegalEntityLegalNameType>();
        }
        return this.legalEntityLegalName;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cva="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cvb="http://www.w3.org/ns/corevocabulary/BasicComponents" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Core Business. Legal Entity_ Alternative Name. Name&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;A recognized name other than the legal name.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Core Business&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Legal Entity&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Alternative Name&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Name&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Name. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * Gets the value of the legalEntityAlternativeName property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the legalEntityAlternativeName property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getLegalEntityAlternativeName().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link LegalEntityAlternativeNameType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<LegalEntityAlternativeNameType> getLegalEntityAlternativeName() {
        if (legalEntityAlternativeName == null) {
            legalEntityAlternativeName = new ArrayList<LegalEntityAlternativeNameType>();
        }
        return this.legalEntityAlternativeName;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cva="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cvb="http://www.w3.org/ns/corevocabulary/BasicComponents" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Core Business. Legal Entity_ Company Type Code. Code&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;The type of the business.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Core Business&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Legal Entity&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Company Type Code&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Code&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Code. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     * 
     * @return
     *     possible object is
     *     {@link LegalEntityCompanyTypeCodeType }
     *     
     */
    @Nullable
    public LegalEntityCompanyTypeCodeType getLegalEntityCompanyTypeCode() {
        return legalEntityCompanyTypeCode;
    }

    /**
     * Sets the value of the legalEntityCompanyTypeCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link LegalEntityCompanyTypeCodeType }
     *     
     */
    public void setLegalEntityCompanyTypeCode(
        @Nullable
        LegalEntityCompanyTypeCodeType value) {
        this.legalEntityCompanyTypeCode = value;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cva="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cvb="http://www.w3.org/ns/corevocabulary/BasicComponents" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Core Business. Legal Entity_ Company Status Code. Code&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;The status of the business.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Core Business&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Legal Entity&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Company Status Code&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Code&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Code. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     * 
     * @return
     *     possible object is
     *     {@link LegalEntityCompanyStatusCodeType }
     *     
     */
    @Nullable
    public LegalEntityCompanyStatusCodeType getLegalEntityCompanyStatusCode() {
        return legalEntityCompanyStatusCode;
    }

    /**
     * Sets the value of the legalEntityCompanyStatusCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link LegalEntityCompanyStatusCodeType }
     *     
     */
    public void setLegalEntityCompanyStatusCode(
        @Nullable
        LegalEntityCompanyStatusCodeType value) {
        this.legalEntityCompanyStatusCode = value;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cva="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cvb="http://www.w3.org/ns/corevocabulary/BasicComponents" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Core Business. Legal Entity_ Company Activity Code. Code&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;The activity of the business.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Core Business&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Legal Entity&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Company Activity Code&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Code&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Code. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * Gets the value of the legalEntityCompanyActivityCode property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the legalEntityCompanyActivityCode property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getLegalEntityCompanyActivityCode().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link LegalEntityCompanyActivityCodeType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<LegalEntityCompanyActivityCodeType> getLegalEntityCompanyActivityCode() {
        if (legalEntityCompanyActivityCode == null) {
            legalEntityCompanyActivityCode = new ArrayList<LegalEntityCompanyActivityCodeType>();
        }
        return this.legalEntityCompanyActivityCode;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cva="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cvb="http://www.w3.org/ns/corevocabulary/BasicComponents" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ASBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Core Business. Registered_ Core Address. Core Address&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;The registered address of the business.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Core Business&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Registered&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Core Address&lt;/ccts:PropertyTerm&gt;&lt;ccts:AssociatedObjectClass&gt;Core Address&lt;/ccts:AssociatedObjectClass&gt;&lt;ccts:RepresentationTerm&gt;Core Address&lt;/ccts:RepresentationTerm&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     * 
     * @return
     *     possible object is
     *     {@link CoreAddressType }
     *     
     */
    @Nullable
    public CoreAddressType getRegisteredCoreAddress() {
        return registeredCoreAddress;
    }

    /**
     * Sets the value of the registeredCoreAddress property.
     * 
     * @param value
     *     allowed object is
     *     {@link CoreAddressType }
     *     
     */
    public void setRegisteredCoreAddress(
        @Nullable
        CoreAddressType value) {
        this.registeredCoreAddress = value;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cva="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cvb="http://www.w3.org/ns/corevocabulary/BasicComponents" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ASBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Core Business. Legal Entity_ Core Address. Core Address&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;An address related to the business, other than the registered address.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Core Business&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Legal Entity&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Core Address&lt;/ccts:PropertyTerm&gt;&lt;ccts:AssociatedObjectClass&gt;Core Address&lt;/ccts:AssociatedObjectClass&gt;&lt;ccts:RepresentationTerm&gt;Core Address&lt;/ccts:RepresentationTerm&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     * 
     * @return
     *     possible object is
     *     {@link CoreAddressType }
     *     
     */
    @Nullable
    public CoreAddressType getLegalEntityCoreAddress() {
        return legalEntityCoreAddress;
    }

    /**
     * Sets the value of the legalEntityCoreAddress property.
     * 
     * @param value
     *     allowed object is
     *     {@link CoreAddressType }
     *     
     */
    public void setLegalEntityCoreAddress(
        @Nullable
        CoreAddressType value) {
        this.legalEntityCoreAddress = value;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cva="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cvb="http://www.w3.org/ns/corevocabulary/BasicComponents" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ASBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Core Business. Legal Entity_ Core Location. Core Location&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;A location related to the business.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Core Business&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Legal Entity&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Core Location&lt;/ccts:PropertyTerm&gt;&lt;ccts:AssociatedObjectClass&gt;Core Location&lt;/ccts:AssociatedObjectClass&gt;&lt;ccts:RepresentationTerm&gt;Core Location&lt;/ccts:RepresentationTerm&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     * 
     * @return
     *     possible object is
     *     {@link CoreLocationType }
     *     
     */
    @Nullable
    public CoreLocationType getLegalEntityCoreLocation() {
        return legalEntityCoreLocation;
    }

    /**
     * Sets the value of the legalEntityCoreLocation property.
     * 
     * @param value
     *     allowed object is
     *     {@link CoreLocationType }
     *     
     */
    public void setLegalEntityCoreLocation(
        @Nullable
        CoreLocationType value) {
        this.legalEntityCoreLocation = value;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final CoreBusinessType rhs = ((CoreBusinessType) o);
        if (!EqualsHelper.equalsCollection(legalEntityAlternativeName, rhs.legalEntityAlternativeName)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(legalEntityCompanyActivityCode, rhs.legalEntityCompanyActivityCode)) {
            return false;
        }
        if (!EqualsHelper.equals(legalEntityCompanyStatusCode, rhs.legalEntityCompanyStatusCode)) {
            return false;
        }
        if (!EqualsHelper.equals(legalEntityCompanyTypeCode, rhs.legalEntityCompanyTypeCode)) {
            return false;
        }
        if (!EqualsHelper.equals(legalEntityCoreAddress, rhs.legalEntityCoreAddress)) {
            return false;
        }
        if (!EqualsHelper.equals(legalEntityCoreLocation, rhs.legalEntityCoreLocation)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(legalEntityID, rhs.legalEntityID)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(legalEntityLegalID, rhs.legalEntityLegalID)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(legalEntityLegalName, rhs.legalEntityLegalName)) {
            return false;
        }
        if (!EqualsHelper.equals(registeredCoreAddress, rhs.registeredCoreAddress)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(legalEntityAlternativeName).append(legalEntityCompanyActivityCode).append(legalEntityCompanyStatusCode).append(legalEntityCompanyTypeCode).append(legalEntityCoreAddress).append(legalEntityCoreLocation).append(legalEntityID).append(legalEntityLegalID).append(legalEntityLegalName).append(registeredCoreAddress).getHashCode();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("legalEntityAlternativeName", legalEntityAlternativeName).append("legalEntityCompanyActivityCode", legalEntityCompanyActivityCode).append("legalEntityCompanyStatusCode", legalEntityCompanyStatusCode).append("legalEntityCompanyTypeCode", legalEntityCompanyTypeCode).append("legalEntityCoreAddress", legalEntityCoreAddress).append("legalEntityCoreLocation", legalEntityCoreLocation).append("legalEntityID", legalEntityID).append("legalEntityLegalID", legalEntityLegalID).append("legalEntityLegalName", legalEntityLegalName).append("registeredCoreAddress", registeredCoreAddress).getToString();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setLegalEntityLegalID(
        @Nullable
        final List<LegalEntityLegalIDType> aList) {
        legalEntityLegalID = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setLegalEntityID(
        @Nullable
        final List<LegalEntityIDType> aList) {
        legalEntityID = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setLegalEntityLegalName(
        @Nullable
        final List<LegalEntityLegalNameType> aList) {
        legalEntityLegalName = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setLegalEntityAlternativeName(
        @Nullable
        final List<LegalEntityAlternativeNameType> aList) {
        legalEntityAlternativeName = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setLegalEntityCompanyActivityCode(
        @Nullable
        final List<LegalEntityCompanyActivityCodeType> aList) {
        legalEntityCompanyActivityCode = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasLegalEntityLegalIDEntries() {
        return (!getLegalEntityLegalID().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoLegalEntityLegalIDEntries() {
        return getLegalEntityLegalID().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getLegalEntityLegalIDCount() {
        return getLegalEntityLegalID().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public LegalEntityLegalIDType getLegalEntityLegalIDAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getLegalEntityLegalID().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addLegalEntityLegalID(
        @Nonnull
        final LegalEntityLegalIDType elem) {
        getLegalEntityLegalID().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasLegalEntityIDEntries() {
        return (!getLegalEntityID().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoLegalEntityIDEntries() {
        return getLegalEntityID().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getLegalEntityIDCount() {
        return getLegalEntityID().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public LegalEntityIDType getLegalEntityIDAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getLegalEntityID().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addLegalEntityID(
        @Nonnull
        final LegalEntityIDType elem) {
        getLegalEntityID().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasLegalEntityLegalNameEntries() {
        return (!getLegalEntityLegalName().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoLegalEntityLegalNameEntries() {
        return getLegalEntityLegalName().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getLegalEntityLegalNameCount() {
        return getLegalEntityLegalName().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public LegalEntityLegalNameType getLegalEntityLegalNameAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getLegalEntityLegalName().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addLegalEntityLegalName(
        @Nonnull
        final LegalEntityLegalNameType elem) {
        getLegalEntityLegalName().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasLegalEntityAlternativeNameEntries() {
        return (!getLegalEntityAlternativeName().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoLegalEntityAlternativeNameEntries() {
        return getLegalEntityAlternativeName().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getLegalEntityAlternativeNameCount() {
        return getLegalEntityAlternativeName().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public LegalEntityAlternativeNameType getLegalEntityAlternativeNameAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getLegalEntityAlternativeName().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addLegalEntityAlternativeName(
        @Nonnull
        final LegalEntityAlternativeNameType elem) {
        getLegalEntityAlternativeName().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasLegalEntityCompanyActivityCodeEntries() {
        return (!getLegalEntityCompanyActivityCode().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoLegalEntityCompanyActivityCodeEntries() {
        return getLegalEntityCompanyActivityCode().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getLegalEntityCompanyActivityCodeCount() {
        return getLegalEntityCompanyActivityCode().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public LegalEntityCompanyActivityCodeType getLegalEntityCompanyActivityCodeAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getLegalEntityCompanyActivityCode().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addLegalEntityCompanyActivityCode(
        @Nonnull
        final LegalEntityCompanyActivityCodeType elem) {
        getLegalEntityCompanyActivityCode().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        CoreBusinessType ret) {
        if (legalEntityAlternativeName == null) {
            ret.legalEntityAlternativeName = null;
        } else {
            List<LegalEntityAlternativeNameType> retLegalEntityAlternativeName = new ArrayList<LegalEntityAlternativeNameType>();
            for (LegalEntityAlternativeNameType aItem: getLegalEntityAlternativeName()) {
                retLegalEntityAlternativeName.add(((aItem == null)?null:aItem.clone()));
            }
            ret.legalEntityAlternativeName = retLegalEntityAlternativeName;
        }
        if (legalEntityCompanyActivityCode == null) {
            ret.legalEntityCompanyActivityCode = null;
        } else {
            List<LegalEntityCompanyActivityCodeType> retLegalEntityCompanyActivityCode = new ArrayList<LegalEntityCompanyActivityCodeType>();
            for (LegalEntityCompanyActivityCodeType aItem: getLegalEntityCompanyActivityCode()) {
                retLegalEntityCompanyActivityCode.add(((aItem == null)?null:aItem.clone()));
            }
            ret.legalEntityCompanyActivityCode = retLegalEntityCompanyActivityCode;
        }
        ret.legalEntityCompanyStatusCode = ((legalEntityCompanyStatusCode == null)?null:legalEntityCompanyStatusCode.clone());
        ret.legalEntityCompanyTypeCode = ((legalEntityCompanyTypeCode == null)?null:legalEntityCompanyTypeCode.clone());
        ret.legalEntityCoreAddress = ((legalEntityCoreAddress == null)?null:legalEntityCoreAddress.clone());
        ret.legalEntityCoreLocation = ((legalEntityCoreLocation == null)?null:legalEntityCoreLocation.clone());
        if (legalEntityID == null) {
            ret.legalEntityID = null;
        } else {
            List<LegalEntityIDType> retLegalEntityID = new ArrayList<LegalEntityIDType>();
            for (LegalEntityIDType aItem: getLegalEntityID()) {
                retLegalEntityID.add(((aItem == null)?null:aItem.clone()));
            }
            ret.legalEntityID = retLegalEntityID;
        }
        if (legalEntityLegalID == null) {
            ret.legalEntityLegalID = null;
        } else {
            List<LegalEntityLegalIDType> retLegalEntityLegalID = new ArrayList<LegalEntityLegalIDType>();
            for (LegalEntityLegalIDType aItem: getLegalEntityLegalID()) {
                retLegalEntityLegalID.add(((aItem == null)?null:aItem.clone()));
            }
            ret.legalEntityLegalID = retLegalEntityLegalID;
        }
        if (legalEntityLegalName == null) {
            ret.legalEntityLegalName = null;
        } else {
            List<LegalEntityLegalNameType> retLegalEntityLegalName = new ArrayList<LegalEntityLegalNameType>();
            for (LegalEntityLegalNameType aItem: getLegalEntityLegalName()) {
                retLegalEntityLegalName.add(((aItem == null)?null:aItem.clone()));
            }
            ret.legalEntityLegalName = retLegalEntityLegalName;
        }
        ret.registeredCoreAddress = ((registeredCoreAddress == null)?null:registeredCoreAddress.clone());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public CoreBusinessType clone() {
        CoreBusinessType ret = new CoreBusinessType();
        cloneTo(ret);
        return ret;
    }

}
