
package eu.toop.edm.jaxb.spdx;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;


/**
 * A data type for Checksum type
 * 
 * <p>Java class for ChecksumType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="ChecksumType"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element ref="{spdx:xsd::1.0}ChecksumValue"/&gt;
 *         &lt;element ref="{spdx:xsd::1.0}AlgorithmCode"/&gt;
 *         &lt;element ref="{spdx:xsd::1.0}ChecksumAugmentationPoint" maxOccurs="unbounded" minOccurs="0"/&gt;
 *       &lt;/sequence&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * <p>This class was annotated by ph-jaxb22-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ChecksumType", propOrder = {
    "checksumValue",
    "algorithmCode",
    "checksumAugmentationPoint"
})
@CodingStyleguideUnaware
public class ChecksumType implements Serializable, IExplicitlyCloneable
{

    @XmlElement(name = "ChecksumValue", required = true)
    private ChecksumValueType checksumValue;
    @XmlElement(name = "AlgorithmCode", required = true)
    private AlgorithmCodeType algorithmCode;
    @XmlElement(name = "ChecksumAugmentationPoint")
    private List<ChecksumAugmentationPointType> checksumAugmentationPoint;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     */
    public ChecksumType() {
    }

    /**
     * Gets the value of the checksumValue property.
     * 
     * @return
     *     possible object is
     *     {@link ChecksumValueType }
     *     
     */
    @Nullable
    public ChecksumValueType getChecksumValue() {
        return checksumValue;
    }

    /**
     * Sets the value of the checksumValue property.
     * 
     * @param value
     *     allowed object is
     *     {@link ChecksumValueType }
     *     
     */
    public void setChecksumValue(
        @Nullable
        ChecksumValueType value) {
        this.checksumValue = value;
    }

    /**
     * Gets the value of the algorithmCode property.
     * 
     * @return
     *     possible object is
     *     {@link AlgorithmCodeType }
     *     
     */
    @Nullable
    public AlgorithmCodeType getAlgorithmCode() {
        return algorithmCode;
    }

    /**
     * Sets the value of the algorithmCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link AlgorithmCodeType }
     *     
     */
    public void setAlgorithmCode(
        @Nullable
        AlgorithmCodeType value) {
        this.algorithmCode = value;
    }

    /**
     * Gets the value of the checksumAugmentationPoint property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the checksumAugmentationPoint property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getChecksumAugmentationPoint().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ChecksumAugmentationPointType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<ChecksumAugmentationPointType> getChecksumAugmentationPoint() {
        if (checksumAugmentationPoint == null) {
            checksumAugmentationPoint = new ArrayList<ChecksumAugmentationPointType>();
        }
        return this.checksumAugmentationPoint;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final ChecksumType rhs = ((ChecksumType) o);
        if (!EqualsHelper.equals(algorithmCode, rhs.algorithmCode)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(checksumAugmentationPoint, rhs.checksumAugmentationPoint)) {
            return false;
        }
        if (!EqualsHelper.equals(checksumValue, rhs.checksumValue)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(algorithmCode).append(checksumAugmentationPoint).append(checksumValue).getHashCode();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("algorithmCode", algorithmCode).append("checksumAugmentationPoint", checksumAugmentationPoint).append("checksumValue", checksumValue).getToString();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setChecksumAugmentationPoint(
        @Nullable
        final List<ChecksumAugmentationPointType> aList) {
        checksumAugmentationPoint = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasChecksumAugmentationPointEntries() {
        return (!getChecksumAugmentationPoint().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoChecksumAugmentationPointEntries() {
        return getChecksumAugmentationPoint().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getChecksumAugmentationPointCount() {
        return getChecksumAugmentationPoint().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public ChecksumAugmentationPointType getChecksumAugmentationPointAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getChecksumAugmentationPoint().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addChecksumAugmentationPoint(
        @Nonnull
        final ChecksumAugmentationPointType elem) {
        getChecksumAugmentationPoint().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        ChecksumType ret) {
        ret.algorithmCode = ((algorithmCode == null)?null:algorithmCode.clone());
        if (checksumAugmentationPoint == null) {
            ret.checksumAugmentationPoint = null;
        } else {
            List<ChecksumAugmentationPointType> retChecksumAugmentationPoint = new ArrayList<ChecksumAugmentationPointType>();
            for (ChecksumAugmentationPointType aItem: getChecksumAugmentationPoint()) {
                retChecksumAugmentationPoint.add(((aItem == null)?null:aItem.clone()));
            }
            ret.checksumAugmentationPoint = retChecksumAugmentationPoint;
        }
        ret.checksumValue = ((checksumValue == null)?null:checksumValue.clone());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public ChecksumType clone() {
        ChecksumType ret = new ChecksumType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type AlgorithmCodeSimpleType<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type AlgorithmCodeType and never <code>null</code>
     */
    @Nonnull
    public AlgorithmCodeType setAlgorithmCode(
        @Nullable
        final AlgorithmCodeSimpleType valueParam) {
        AlgorithmCodeType aObj = getAlgorithmCode();
        if (aObj == null) {
            aObj = new AlgorithmCodeType(valueParam);
            setAlgorithmCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type byte[]<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ChecksumValueType and never <code>null</code>
     */
    @Nonnull
    public ChecksumValueType setChecksumValue(
        @Nullable
        final byte[] valueParam) {
        ChecksumValueType aObj = getChecksumValue();
        if (aObj == null) {
            aObj = new ChecksumValueType(valueParam);
            setChecksumValue(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained ChecksumValueType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ChecksumValueType object or <code>null</code>
     */
    @Nullable
    public byte[] getChecksumValueValue() {
        ChecksumValueType aObj = getChecksumValue();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained AlgorithmCodeType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained AlgorithmCodeType object or <code>null</code>
     */
    @Nullable
    public AlgorithmCodeSimpleType getAlgorithmCodeValue() {
        AlgorithmCodeType aObj = getAlgorithmCode();
        return ((aObj == null)?null:aObj.getValue());
    }

}
