
package eu.toop.edm.jaxb.dcatap;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.NormalizedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import eu.toop.edm.jaxb.dcterms.DCRightStatementType;
import eu.toop.edm.jaxb.dcterms.DCStandardType;


/**
 * <p>Java class for DataServiceType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="DataServiceType"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element ref="{http://purl.org/dc/terms/}identifier"/&gt;
 *         &lt;element ref="{http://purl.org/dc/terms/}title"/&gt;
 *         &lt;element ref="{http://data.europa.eu/r5r/}endpointURL" maxOccurs="unbounded"/&gt;
 *         &lt;element ref="{http://purl.org/dc/terms/}description" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://purl.org/dc/terms/}conformsTo" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://purl.org/dc/terms/}accessRights" minOccurs="0"/&gt;
 *         &lt;element ref="{http://data.europa.eu/r5r/}endpointDescription" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://data.europa.eu/r5r/}servesDataset" maxOccurs="unbounded" minOccurs="0"/&gt;
 *       &lt;/sequence&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * <p>This class was annotated by ph-jaxb22-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "DataServiceType", propOrder = {
    "identifier",
    "title",
    "endpointURL",
    "description",
    "conformsTo",
    "accessRights",
    "endpointDescription",
    "servesDataset"
})
@CodingStyleguideUnaware
public class DCatAPDataServiceType implements Serializable, IExplicitlyCloneable
{

    @XmlElement(namespace = "http://purl.org/dc/terms/", required = true)
    @XmlJavaTypeAdapter(NormalizedStringAdapter.class)
    @XmlSchemaType(name = "normalizedString")
    private String identifier;
    @XmlElement(namespace = "http://purl.org/dc/terms/", required = true)
    private String title;
    @XmlElement(required = true)
    @XmlSchemaType(name = "anyURI")
    private List<String> endpointURL;
    @XmlElement(namespace = "http://purl.org/dc/terms/")
    private List<String> description;
    @XmlElement(namespace = "http://purl.org/dc/terms/")
    private List<DCStandardType> conformsTo;
    @XmlElement(namespace = "http://purl.org/dc/terms/")
    private DCRightStatementType accessRights;
    private List<String> endpointDescription;
    private List<DCatAPDatasetType> servesDataset;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     */
    public DCatAPDataServiceType() {
    }

    /**
     * Gets the value of the identifier property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getIdentifier() {
        return identifier;
    }

    /**
     * Sets the value of the identifier property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setIdentifier(
        @Nullable
        String value) {
        this.identifier = value;
    }

    /**
     * Gets the value of the title property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getTitle() {
        return title;
    }

    /**
     * Sets the value of the title property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setTitle(
        @Nullable
        String value) {
        this.title = value;
    }

    /**
     * Gets the value of the endpointURL property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the endpointURL property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getEndpointURL().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link String }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<String> getEndpointURL() {
        if (endpointURL == null) {
            endpointURL = new ArrayList<String>();
        }
        return this.endpointURL;
    }

    /**
     * Gets the value of the description property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the description property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getDescription().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link String }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<String> getDescription() {
        if (description == null) {
            description = new ArrayList<String>();
        }
        return this.description;
    }

    /**
     * Gets the value of the conformsTo property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the conformsTo property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getConformsTo().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DCStandardType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DCStandardType> getConformsTo() {
        if (conformsTo == null) {
            conformsTo = new ArrayList<DCStandardType>();
        }
        return this.conformsTo;
    }

    /**
     * Gets the value of the accessRights property.
     * 
     * @return
     *     possible object is
     *     {@link DCRightStatementType }
     *     
     */
    @Nullable
    public DCRightStatementType getAccessRights() {
        return accessRights;
    }

    /**
     * Sets the value of the accessRights property.
     * 
     * @param value
     *     allowed object is
     *     {@link DCRightStatementType }
     *     
     */
    public void setAccessRights(
        @Nullable
        DCRightStatementType value) {
        this.accessRights = value;
    }

    /**
     * Gets the value of the endpointDescription property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the endpointDescription property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getEndpointDescription().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link String }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<String> getEndpointDescription() {
        if (endpointDescription == null) {
            endpointDescription = new ArrayList<String>();
        }
        return this.endpointDescription;
    }

    /**
     * Gets the value of the servesDataset property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the servesDataset property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getServesDataset().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DCatAPDatasetType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DCatAPDatasetType> getServesDataset() {
        if (servesDataset == null) {
            servesDataset = new ArrayList<DCatAPDatasetType>();
        }
        return this.servesDataset;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final DCatAPDataServiceType rhs = ((DCatAPDataServiceType) o);
        if (!EqualsHelper.equals(accessRights, rhs.accessRights)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(conformsTo, rhs.conformsTo)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(description, rhs.description)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(endpointDescription, rhs.endpointDescription)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(endpointURL, rhs.endpointURL)) {
            return false;
        }
        if (!EqualsHelper.equals(identifier, rhs.identifier)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(servesDataset, rhs.servesDataset)) {
            return false;
        }
        if (!EqualsHelper.equals(title, rhs.title)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(accessRights).append(conformsTo).append(description).append(endpointDescription).append(endpointURL).append(identifier).append(servesDataset).append(title).getHashCode();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("accessRights", accessRights).append("conformsTo", conformsTo).append("description", description).append("endpointDescription", endpointDescription).append("endpointURL", endpointURL).append("identifier", identifier).append("servesDataset", servesDataset).append("title", title).getToString();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setEndpointURL(
        @Nullable
        final List<String> aList) {
        endpointURL = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setDescription(
        @Nullable
        final List<String> aList) {
        description = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setConformsTo(
        @Nullable
        final List<DCStandardType> aList) {
        conformsTo = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setEndpointDescription(
        @Nullable
        final List<String> aList) {
        endpointDescription = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setServesDataset(
        @Nullable
        final List<DCatAPDatasetType> aList) {
        servesDataset = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasEndpointURLEntries() {
        return (!getEndpointURL().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoEndpointURLEntries() {
        return getEndpointURL().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getEndpointURLCount() {
        return getEndpointURL().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public String getEndpointURLAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getEndpointURL().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addEndpointURL(
        @Nonnull
        final String elem) {
        getEndpointURL().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasDescriptionEntries() {
        return (!getDescription().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoDescriptionEntries() {
        return getDescription().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getDescriptionCount() {
        return getDescription().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public String getDescriptionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getDescription().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addDescription(
        @Nonnull
        final String elem) {
        getDescription().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasConformsToEntries() {
        return (!getConformsTo().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoConformsToEntries() {
        return getConformsTo().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getConformsToCount() {
        return getConformsTo().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DCStandardType getConformsToAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getConformsTo().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addConformsTo(
        @Nonnull
        final DCStandardType elem) {
        getConformsTo().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasEndpointDescriptionEntries() {
        return (!getEndpointDescription().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoEndpointDescriptionEntries() {
        return getEndpointDescription().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getEndpointDescriptionCount() {
        return getEndpointDescription().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public String getEndpointDescriptionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getEndpointDescription().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addEndpointDescription(
        @Nonnull
        final String elem) {
        getEndpointDescription().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasServesDatasetEntries() {
        return (!getServesDataset().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoServesDatasetEntries() {
        return getServesDataset().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getServesDatasetCount() {
        return getServesDataset().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DCatAPDatasetType getServesDatasetAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getServesDataset().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addServesDataset(
        @Nonnull
        final DCatAPDatasetType elem) {
        getServesDataset().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        DCatAPDataServiceType ret) {
        ret.accessRights = ((accessRights == null)?null:accessRights.clone());
        if (conformsTo == null) {
            ret.conformsTo = null;
        } else {
            List<DCStandardType> retConformsTo = new ArrayList<DCStandardType>();
            for (DCStandardType aItem: getConformsTo()) {
                retConformsTo.add(((aItem == null)?null:aItem.clone()));
            }
            ret.conformsTo = retConformsTo;
        }
        if (description == null) {
            ret.description = null;
        } else {
            List<String> retDescription = new ArrayList<String>();
            for (String aItem: getDescription()) {
                retDescription.add(aItem);
            }
            ret.description = retDescription;
        }
        if (endpointDescription == null) {
            ret.endpointDescription = null;
        } else {
            List<String> retEndpointDescription = new ArrayList<String>();
            for (String aItem: getEndpointDescription()) {
                retEndpointDescription.add(aItem);
            }
            ret.endpointDescription = retEndpointDescription;
        }
        if (endpointURL == null) {
            ret.endpointURL = null;
        } else {
            List<String> retEndpointURL = new ArrayList<String>();
            for (String aItem: getEndpointURL()) {
                retEndpointURL.add(aItem);
            }
            ret.endpointURL = retEndpointURL;
        }
        ret.identifier = identifier;
        if (servesDataset == null) {
            ret.servesDataset = null;
        } else {
            List<DCatAPDatasetType> retServesDataset = new ArrayList<DCatAPDatasetType>();
            for (DCatAPDatasetType aItem: getServesDataset()) {
                retServesDataset.add(((aItem == null)?null:aItem.clone()));
            }
            ret.servesDataset = retServesDataset;
        }
        ret.title = title;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public DCatAPDataServiceType clone() {
        DCatAPDataServiceType ret = new DCatAPDataServiceType();
        cloneTo(ret);
        return ret;
    }

}
