
package eu.toop.edm.jaxb.cccev;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.NormalizedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.datatype.XMLGregorianCalendar;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import eu.toop.edm.jaxb.cv.cac.PeriodType;
import eu.toop.edm.jaxb.cv.cbc.AmountType;
import eu.toop.edm.jaxb.cv.cbc.CodeType;
import eu.toop.edm.jaxb.cv.cbc.DateType;
import eu.toop.edm.jaxb.cv.cbc.IDReferenceType;
import eu.toop.edm.jaxb.cv.cbc.IDType;
import eu.toop.edm.jaxb.cv.cbc.IndicatorType;
import eu.toop.edm.jaxb.cv.cbc.MeasureType;
import eu.toop.edm.jaxb.cv.cbc.NumericType;
import eu.toop.edm.jaxb.cv.cbc.QuantityType;
import eu.toop.edm.jaxb.cv.cbc.TextType;
import eu.toop.edm.jaxb.cv.cbc.TimeType;
import eu.toop.edm.jaxb.cv.cbc.URIType;


/**
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;an:Class xmlns:an="https://semic.org/sa/cv/common/semic-annot-2.0.0#" xmlns="https://semic.org/sa/cv/cccev-2.0.0#" xmlns:cac="https://semic.org/sa/cv/common/cac-2.0.0#" xmlns:cagv="https://semic.org/sa/cv/cagv/agent-2.0.0#" xmlns:cbc="https://semic.org/sa/cv/common/cbc-2.0.0#" xmlns:ccts="urn:un:unece:uncefact:data:specification:CoreComponentTypeSchemaModule:2" xmlns:dcat-ap="http://data.europa.eu/r5r/" xmlns:foaf="http://xmlns.com/foaf/0.1/" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;Class&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Value. Details&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;&lt;DefinitionSource/&gt;&lt;/ccts:Definition&gt;&lt;ccts:ObjectClass&gt;Value&lt;/ccts:ObjectClass&gt;&lt;/an:Class&gt;
 * </pre>
 * 
 * 
 * <p>Java class for ValueType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="ValueType"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element ref="{https://semic.org/sa/cv/cccev-2.0.0#}amountValue" minOccurs="0"/&gt;
 *         &lt;element ref="{https://semic.org/sa/cv/cccev-2.0.0#}codeValue" minOccurs="0"/&gt;
 *         &lt;element ref="{https://semic.org/sa/cv/cccev-2.0.0#}dateValue" minOccurs="0"/&gt;
 *         &lt;element ref="{https://semic.org/sa/cv/cccev-2.0.0#}identifierValue" minOccurs="0"/&gt;
 *         &lt;element ref="{https://semic.org/sa/cv/cccev-2.0.0#}indicatorValue" minOccurs="0"/&gt;
 *         &lt;element ref="{https://semic.org/sa/cv/cccev-2.0.0#}measureValue" minOccurs="0"/&gt;
 *         &lt;element ref="{https://semic.org/sa/cv/cccev-2.0.0#}numericValue" minOccurs="0"/&gt;
 *         &lt;element ref="{https://semic.org/sa/cv/cccev-2.0.0#}quantityValue" minOccurs="0"/&gt;
 *         &lt;element ref="{https://semic.org/sa/cv/cccev-2.0.0#}textValue" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{https://semic.org/sa/cv/cccev-2.0.0#}timeValue" minOccurs="0"/&gt;
 *         &lt;element ref="{https://semic.org/sa/cv/cccev-2.0.0#}uriValue" minOccurs="0"/&gt;
 *         &lt;element ref="{https://semic.org/sa/cv/cccev-2.0.0#}customDataType" minOccurs="0"/&gt;
 *         &lt;element ref="{https://semic.org/sa/cv/cccev-2.0.0#}customFunction" minOccurs="0"/&gt;
 *         &lt;element ref="{https://semic.org/sa/cv/cccev-2.0.0#}error" minOccurs="0"/&gt;
 *         &lt;element ref="{https://semic.org/sa/cv/cccev-2.0.0#}periodValue" minOccurs="0"/&gt;
 *         &lt;element ref="{https://semic.org/sa/cv/cccev-2.0.0#}valueOf" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{https://semic.org/sa/cv/cccev-2.0.0#}value" maxOccurs="unbounded" minOccurs="0"/&gt;
 *       &lt;/sequence&gt;
 *       &lt;attGroup ref="{https://semic.org/sa/cv/common/cac-2.0.0#}ThingAttributes"/&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * <p>This class was annotated by ph-jaxb22-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ValueType", propOrder = {
    "amountValue",
    "codeValue",
    "dateValue",
    "identifierValue",
    "indicatorValue",
    "measureValue",
    "numericValue",
    "quantityValue",
    "textValue",
    "timeValue",
    "uriValue",
    "customDataType",
    "customFunction",
    "error",
    "periodValue",
    "valueOf",
    "value"
})
@CodingStyleguideUnaware
public class CCCEVValueType implements Serializable, IExplicitlyCloneable
{

    private AmountType amountValue;
    private CodeType codeValue;
    private DateType dateValue;
    private IDType identifierValue;
    private IndicatorType indicatorValue;
    private MeasureType measureValue;
    private NumericType numericValue;
    private QuantityType quantityValue;
    private List<TextType> textValue;
    private TimeType timeValue;
    private URIType uriValue;
    private CodeType customDataType;
    private IDType customFunction;
    private CodeType error;
    private PeriodType periodValue;
    private List<IDReferenceType> valueOf;
    private List<CCCEVValueType> value;
    @XmlAttribute(name = "versionId")
    @XmlJavaTypeAdapter(NormalizedStringAdapter.class)
    @XmlSchemaType(name = "normalizedString")
    private String versionIdAttr;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     */
    public CCCEVValueType() {
    }

    /**
     * Constructor for value of type List<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     */
    public CCCEVValueType(
        @Nullable
        final List<CCCEVValueType> valueParam) {
        setValue(valueParam);
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;an:DataProperty xmlns:an="https://semic.org/sa/cv/common/semic-annot-2.0.0#" xmlns="https://semic.org/sa/cv/cccev-2.0.0#" xmlns:cac="https://semic.org/sa/cv/common/cac-2.0.0#" xmlns:cagv="https://semic.org/sa/cv/cagv/agent-2.0.0#" xmlns:cbc="https://semic.org/sa/cv/common/cbc-2.0.0#" xmlns:ccts="urn:un:unece:uncefact:data:specification:CoreComponentTypeSchemaModule:2" xmlns:dcat-ap="http://data.europa.eu/r5r/" xmlns:foaf="http://xmlns.com/foaf/0.1/" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;Data property&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Value. amount Value&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;&lt;DefinitionSource/&gt;&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Value&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Amount&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Amount&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Amount. Type&lt;/ccts:DataType&gt;&lt;/an:DataProperty&gt;
     * </pre>
     * 
     * 
     * @return
     *     possible object is
     *     {@link AmountType }
     *     
     */
    @Nullable
    public AmountType getAmountValue() {
        return amountValue;
    }

    /**
     * Sets the value of the amountValue property.
     * 
     * @param value
     *     allowed object is
     *     {@link AmountType }
     *     
     */
    public void setAmountValue(
        @Nullable
        AmountType value) {
        this.amountValue = value;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;an:DataProperty xmlns:an="https://semic.org/sa/cv/common/semic-annot-2.0.0#" xmlns="https://semic.org/sa/cv/cccev-2.0.0#" xmlns:cac="https://semic.org/sa/cv/common/cac-2.0.0#" xmlns:cagv="https://semic.org/sa/cv/cagv/agent-2.0.0#" xmlns:cbc="https://semic.org/sa/cv/common/cbc-2.0.0#" xmlns:ccts="urn:un:unece:uncefact:data:specification:CoreComponentTypeSchemaModule:2" xmlns:dcat-ap="http://data.europa.eu/r5r/" xmlns:foaf="http://xmlns.com/foaf/0.1/" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;Data property&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Value. code Value&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;&lt;DefinitionSource/&gt;&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Value&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Code&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Code&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Code. Type&lt;/ccts:DataType&gt;&lt;/an:DataProperty&gt;
     * </pre>
     * 
     * 
     * @return
     *     possible object is
     *     {@link CodeType }
     *     
     */
    @Nullable
    public CodeType getCodeValue() {
        return codeValue;
    }

    /**
     * Sets the value of the codeValue property.
     * 
     * @param value
     *     allowed object is
     *     {@link CodeType }
     *     
     */
    public void setCodeValue(
        @Nullable
        CodeType value) {
        this.codeValue = value;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;an:DataProperty xmlns:an="https://semic.org/sa/cv/common/semic-annot-2.0.0#" xmlns="https://semic.org/sa/cv/cccev-2.0.0#" xmlns:cac="https://semic.org/sa/cv/common/cac-2.0.0#" xmlns:cagv="https://semic.org/sa/cv/cagv/agent-2.0.0#" xmlns:cbc="https://semic.org/sa/cv/common/cbc-2.0.0#" xmlns:ccts="urn:un:unece:uncefact:data:specification:CoreComponentTypeSchemaModule:2" xmlns:dcat-ap="http://data.europa.eu/r5r/" xmlns:foaf="http://xmlns.com/foaf/0.1/" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;Data property&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Value. date Value&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;&lt;DefinitionSource/&gt;&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Value&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Date&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Date&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Date. Type&lt;/ccts:DataType&gt;&lt;/an:DataProperty&gt;
     * </pre>
     * 
     * 
     * @return
     *     possible object is
     *     {@link DateType }
     *     
     */
    @Nullable
    public DateType getDateValue() {
        return dateValue;
    }

    /**
     * Sets the value of the dateValue property.
     * 
     * @param value
     *     allowed object is
     *     {@link DateType }
     *     
     */
    public void setDateValue(
        @Nullable
        DateType value) {
        this.dateValue = value;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;an:DataProperty xmlns:an="https://semic.org/sa/cv/common/semic-annot-2.0.0#" xmlns="https://semic.org/sa/cv/cccev-2.0.0#" xmlns:cac="https://semic.org/sa/cv/common/cac-2.0.0#" xmlns:cagv="https://semic.org/sa/cv/cagv/agent-2.0.0#" xmlns:cbc="https://semic.org/sa/cv/common/cbc-2.0.0#" xmlns:ccts="urn:un:unece:uncefact:data:specification:CoreComponentTypeSchemaModule:2" xmlns:dcat-ap="http://data.europa.eu/r5r/" xmlns:foaf="http://xmlns.com/foaf/0.1/" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;Data property&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Value. identifier Value&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;&lt;DefinitionSource/&gt;&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Value&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Identifier&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Identifier&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;ID. Type&lt;/ccts:DataType&gt;&lt;/an:DataProperty&gt;
     * </pre>
     * 
     * 
     * @return
     *     possible object is
     *     {@link IDType }
     *     
     */
    @Nullable
    public IDType getIdentifierValue() {
        return identifierValue;
    }

    /**
     * Sets the value of the identifierValue property.
     * 
     * @param value
     *     allowed object is
     *     {@link IDType }
     *     
     */
    public void setIdentifierValue(
        @Nullable
        IDType value) {
        this.identifierValue = value;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;an:DataProperty xmlns:an="https://semic.org/sa/cv/common/semic-annot-2.0.0#" xmlns="https://semic.org/sa/cv/cccev-2.0.0#" xmlns:cac="https://semic.org/sa/cv/common/cac-2.0.0#" xmlns:cagv="https://semic.org/sa/cv/cagv/agent-2.0.0#" xmlns:cbc="https://semic.org/sa/cv/common/cbc-2.0.0#" xmlns:ccts="urn:un:unece:uncefact:data:specification:CoreComponentTypeSchemaModule:2" xmlns:dcat-ap="http://data.europa.eu/r5r/" xmlns:foaf="http://xmlns.com/foaf/0.1/" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;Data property&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Value. indicator Value&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;&lt;DefinitionSource/&gt;&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Value&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Indicator&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Indicator&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Indicator. Type&lt;/ccts:DataType&gt;&lt;/an:DataProperty&gt;
     * </pre>
     * 
     * 
     * @return
     *     possible object is
     *     {@link IndicatorType }
     *     
     */
    @Nullable
    public IndicatorType getIndicatorValue() {
        return indicatorValue;
    }

    /**
     * Sets the value of the indicatorValue property.
     * 
     * @param value
     *     allowed object is
     *     {@link IndicatorType }
     *     
     */
    public void setIndicatorValue(
        @Nullable
        IndicatorType value) {
        this.indicatorValue = value;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;an:DataProperty xmlns:an="https://semic.org/sa/cv/common/semic-annot-2.0.0#" xmlns="https://semic.org/sa/cv/cccev-2.0.0#" xmlns:cac="https://semic.org/sa/cv/common/cac-2.0.0#" xmlns:cagv="https://semic.org/sa/cv/cagv/agent-2.0.0#" xmlns:cbc="https://semic.org/sa/cv/common/cbc-2.0.0#" xmlns:ccts="urn:un:unece:uncefact:data:specification:CoreComponentTypeSchemaModule:2" xmlns:dcat-ap="http://data.europa.eu/r5r/" xmlns:foaf="http://xmlns.com/foaf/0.1/" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;Data property&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Value. measure Value&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;&lt;DefinitionSource/&gt;&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Value&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Measure&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Measure&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Measure. Type&lt;/ccts:DataType&gt;&lt;/an:DataProperty&gt;
     * </pre>
     * 
     * 
     * @return
     *     possible object is
     *     {@link MeasureType }
     *     
     */
    @Nullable
    public MeasureType getMeasureValue() {
        return measureValue;
    }

    /**
     * Sets the value of the measureValue property.
     * 
     * @param value
     *     allowed object is
     *     {@link MeasureType }
     *     
     */
    public void setMeasureValue(
        @Nullable
        MeasureType value) {
        this.measureValue = value;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;an:DataProperty xmlns:an="https://semic.org/sa/cv/common/semic-annot-2.0.0#" xmlns="https://semic.org/sa/cv/cccev-2.0.0#" xmlns:cac="https://semic.org/sa/cv/common/cac-2.0.0#" xmlns:cagv="https://semic.org/sa/cv/cagv/agent-2.0.0#" xmlns:cbc="https://semic.org/sa/cv/common/cbc-2.0.0#" xmlns:ccts="urn:un:unece:uncefact:data:specification:CoreComponentTypeSchemaModule:2" xmlns:dcat-ap="http://data.europa.eu/r5r/" xmlns:foaf="http://xmlns.com/foaf/0.1/" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;Data property&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Value. numeric Value&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;&lt;DefinitionSource/&gt;&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Value&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Numeric&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Numeric&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Numeric. Type&lt;/ccts:DataType&gt;&lt;/an:DataProperty&gt;
     * </pre>
     * 
     * 
     * @return
     *     possible object is
     *     {@link NumericType }
     *     
     */
    @Nullable
    public NumericType getNumericValue() {
        return numericValue;
    }

    /**
     * Sets the value of the numericValue property.
     * 
     * @param value
     *     allowed object is
     *     {@link NumericType }
     *     
     */
    public void setNumericValue(
        @Nullable
        NumericType value) {
        this.numericValue = value;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;an:DataProperty xmlns:an="https://semic.org/sa/cv/common/semic-annot-2.0.0#" xmlns="https://semic.org/sa/cv/cccev-2.0.0#" xmlns:cac="https://semic.org/sa/cv/common/cac-2.0.0#" xmlns:cagv="https://semic.org/sa/cv/cagv/agent-2.0.0#" xmlns:cbc="https://semic.org/sa/cv/common/cbc-2.0.0#" xmlns:ccts="urn:un:unece:uncefact:data:specification:CoreComponentTypeSchemaModule:2" xmlns:dcat-ap="http://data.europa.eu/r5r/" xmlns:foaf="http://xmlns.com/foaf/0.1/" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;Data property&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Value. quantity Value&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;&lt;DefinitionSource/&gt;&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Value&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Quantity&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Quantity&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Quantity. Type&lt;/ccts:DataType&gt;&lt;/an:DataProperty&gt;
     * </pre>
     * 
     * 
     * @return
     *     possible object is
     *     {@link QuantityType }
     *     
     */
    @Nullable
    public QuantityType getQuantityValue() {
        return quantityValue;
    }

    /**
     * Sets the value of the quantityValue property.
     * 
     * @param value
     *     allowed object is
     *     {@link QuantityType }
     *     
     */
    public void setQuantityValue(
        @Nullable
        QuantityType value) {
        this.quantityValue = value;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;an:DataProperty xmlns:an="https://semic.org/sa/cv/common/semic-annot-2.0.0#" xmlns="https://semic.org/sa/cv/cccev-2.0.0#" xmlns:cac="https://semic.org/sa/cv/common/cac-2.0.0#" xmlns:cagv="https://semic.org/sa/cv/cagv/agent-2.0.0#" xmlns:cbc="https://semic.org/sa/cv/common/cbc-2.0.0#" xmlns:ccts="urn:un:unece:uncefact:data:specification:CoreComponentTypeSchemaModule:2" xmlns:dcat-ap="http://data.europa.eu/r5r/" xmlns:foaf="http://xmlns.com/foaf/0.1/" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;Data property&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Value. text Value&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;&lt;DefinitionSource/&gt;&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..*&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Value&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Text&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Text&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Text. Type&lt;/ccts:DataType&gt;&lt;/an:DataProperty&gt;
     * </pre>
     * Gets the value of the textValue property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the textValue property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getTextValue().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TextType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TextType> getTextValue() {
        if (textValue == null) {
            textValue = new ArrayList<TextType>();
        }
        return this.textValue;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;an:DataProperty xmlns:an="https://semic.org/sa/cv/common/semic-annot-2.0.0#" xmlns="https://semic.org/sa/cv/cccev-2.0.0#" xmlns:cac="https://semic.org/sa/cv/common/cac-2.0.0#" xmlns:cagv="https://semic.org/sa/cv/cagv/agent-2.0.0#" xmlns:cbc="https://semic.org/sa/cv/common/cbc-2.0.0#" xmlns:ccts="urn:un:unece:uncefact:data:specification:CoreComponentTypeSchemaModule:2" xmlns:dcat-ap="http://data.europa.eu/r5r/" xmlns:foaf="http://xmlns.com/foaf/0.1/" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;Data property&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Value. time Value&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;&lt;DefinitionSource/&gt;&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Value&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Time&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Time&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Time. Type&lt;/ccts:DataType&gt;&lt;/an:DataProperty&gt;
     * </pre>
     * 
     * 
     * @return
     *     possible object is
     *     {@link TimeType }
     *     
     */
    @Nullable
    public TimeType getTimeValue() {
        return timeValue;
    }

    /**
     * Sets the value of the timeValue property.
     * 
     * @param value
     *     allowed object is
     *     {@link TimeType }
     *     
     */
    public void setTimeValue(
        @Nullable
        TimeType value) {
        this.timeValue = value;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;an:DataProperty xmlns:an="https://semic.org/sa/cv/common/semic-annot-2.0.0#" xmlns="https://semic.org/sa/cv/cccev-2.0.0#" xmlns:cac="https://semic.org/sa/cv/common/cac-2.0.0#" xmlns:cagv="https://semic.org/sa/cv/cagv/agent-2.0.0#" xmlns:cbc="https://semic.org/sa/cv/common/cbc-2.0.0#" xmlns:ccts="urn:un:unece:uncefact:data:specification:CoreComponentTypeSchemaModule:2" xmlns:dcat-ap="http://data.europa.eu/r5r/" xmlns:foaf="http://xmlns.com/foaf/0.1/" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;Data property&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Value. uri Value&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;&lt;DefinitionSource/&gt;&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Value&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;anyURI&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;anyURI&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;URI. Type&lt;/ccts:DataType&gt;&lt;/an:DataProperty&gt;
     * </pre>
     * 
     * 
     * @return
     *     possible object is
     *     {@link URIType }
     *     
     */
    @Nullable
    public URIType getUriValue() {
        return uriValue;
    }

    /**
     * Sets the value of the uriValue property.
     * 
     * @param value
     *     allowed object is
     *     {@link URIType }
     *     
     */
    public void setUriValue(
        @Nullable
        URIType value) {
        this.uriValue = value;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;an:DataProperty xmlns:an="https://semic.org/sa/cv/common/semic-annot-2.0.0#" xmlns="https://semic.org/sa/cv/cccev-2.0.0#" xmlns:cac="https://semic.org/sa/cv/common/cac-2.0.0#" xmlns:cagv="https://semic.org/sa/cv/cagv/agent-2.0.0#" xmlns:cbc="https://semic.org/sa/cv/common/cbc-2.0.0#" xmlns:ccts="urn:un:unece:uncefact:data:specification:CoreComponentTypeSchemaModule:2" xmlns:dcat-ap="http://data.europa.eu/r5r/" xmlns:foaf="http://xmlns.com/foaf/0.1/" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;Data property&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Value. custom Data Type Value&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;&lt;DefinitionSource/&gt;&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Value&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Code&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Code&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Code. Type&lt;/ccts:DataType&gt;&lt;/an:DataProperty&gt;
     * </pre>
     * 
     * 
     * @return
     *     possible object is
     *     {@link CodeType }
     *     
     */
    @Nullable
    public CodeType getCustomDataType() {
        return customDataType;
    }

    /**
     * Sets the value of the customDataType property.
     * 
     * @param value
     *     allowed object is
     *     {@link CodeType }
     *     
     */
    public void setCustomDataType(
        @Nullable
        CodeType value) {
        this.customDataType = value;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;an:DataProperty xmlns:an="https://semic.org/sa/cv/common/semic-annot-2.0.0#" xmlns="https://semic.org/sa/cv/cccev-2.0.0#" xmlns:cac="https://semic.org/sa/cv/common/cac-2.0.0#" xmlns:cagv="https://semic.org/sa/cv/cagv/agent-2.0.0#" xmlns:cbc="https://semic.org/sa/cv/common/cbc-2.0.0#" xmlns:ccts="urn:un:unece:uncefact:data:specification:CoreComponentTypeSchemaModule:2" xmlns:dcat-ap="http://data.europa.eu/r5r/" xmlns:foaf="http://xmlns.com/foaf/0.1/" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;Data property&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Value. custom Function Value&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;&lt;DefinitionSource/&gt;&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Value&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Identifier&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Identifier&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;ID. Type&lt;/ccts:DataType&gt;&lt;/an:DataProperty&gt;
     * </pre>
     * 
     * 
     * @return
     *     possible object is
     *     {@link IDType }
     *     
     */
    @Nullable
    public IDType getCustomFunction() {
        return customFunction;
    }

    /**
     * Sets the value of the customFunction property.
     * 
     * @param value
     *     allowed object is
     *     {@link IDType }
     *     
     */
    public void setCustomFunction(
        @Nullable
        IDType value) {
        this.customFunction = value;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;an:DataProperty xmlns:an="https://semic.org/sa/cv/common/semic-annot-2.0.0#" xmlns="https://semic.org/sa/cv/cccev-2.0.0#" xmlns:cac="https://semic.org/sa/cv/common/cac-2.0.0#" xmlns:cagv="https://semic.org/sa/cv/cagv/agent-2.0.0#" xmlns:cbc="https://semic.org/sa/cv/common/cbc-2.0.0#" xmlns:ccts="urn:un:unece:uncefact:data:specification:CoreComponentTypeSchemaModule:2" xmlns:dcat-ap="http://data.europa.eu/r5r/" xmlns:foaf="http://xmlns.com/foaf/0.1/" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;Data property&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Value. code Value&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;&lt;DefinitionSource/&gt;&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Value&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Code&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Code&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Code. Type&lt;/ccts:DataType&gt;&lt;/an:DataProperty&gt;
     * </pre>
     * 
     * 
     * @return
     *     possible object is
     *     {@link CodeType }
     *     
     */
    @Nullable
    public CodeType getError() {
        return error;
    }

    /**
     * Sets the value of the error property.
     * 
     * @param value
     *     allowed object is
     *     {@link CodeType }
     *     
     */
    public void setError(
        @Nullable
        CodeType value) {
        this.error = value;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ObjectProperty xmlns="https://semic.org/sa/cv/cccev-2.0.0#" xmlns:an="https://semic.org/sa/cv/common/semic-annot-2.0.0#" xmlns:cac="https://semic.org/sa/cv/common/cac-2.0.0#" xmlns:cagv="https://semic.org/sa/cv/cagv/agent-2.0.0#" xmlns:cbc="https://semic.org/sa/cv/common/cbc-2.0.0#" xmlns:ccts="urn:un:unece:uncefact:data:specification:CoreComponentTypeSchemaModule:2" xmlns:dcat-ap="http://data.europa.eu/r5r/" xmlns:foaf="http://xmlns.com/foaf/0.1/" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;Object property&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Value. period Value&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition/&gt;&lt;ccts:ObjectClass&gt;Value&lt;/ccts:ObjectClass&gt;&lt;Domain&gt;Value&lt;/Domain&gt;&lt;Range&gt;cac:Period&lt;/Range&gt;&lt;Predicate&gt;hasPeriodValue&lt;/Predicate&gt;&lt;/ObjectProperty&gt;
     * </pre>
     * 
     * 
     * @return
     *     possible object is
     *     {@link PeriodType }
     *     
     */
    @Nullable
    public PeriodType getPeriodValue() {
        return periodValue;
    }

    /**
     * Sets the value of the periodValue property.
     * 
     * @param value
     *     allowed object is
     *     {@link PeriodType }
     *     
     */
    public void setPeriodValue(
        @Nullable
        PeriodType value) {
        this.periodValue = value;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ObjectProperty xmlns="https://semic.org/sa/cv/cccev-2.0.0#" xmlns:an="https://semic.org/sa/cv/common/semic-annot-2.0.0#" xmlns:cac="https://semic.org/sa/cv/common/cac-2.0.0#" xmlns:cagv="https://semic.org/sa/cv/cagv/agent-2.0.0#" xmlns:cbc="https://semic.org/sa/cv/common/cbc-2.0.0#" xmlns:ccts="urn:un:unece:uncefact:data:specification:CoreComponentTypeSchemaModule:2" xmlns:dcat-ap="http://data.europa.eu/r5r/" xmlns:foaf="http://xmlns.com/foaf/0.1/" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;Object property&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Value. value Of&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition/&gt;&lt;ccts:ObjectClass&gt;Value&lt;/ccts:ObjectClass&gt;&lt;Domain&gt;Value&lt;/Domain&gt;&lt;Range&gt;Concep&lt;/Range&gt;&lt;Predicate&gt;isValueOf&lt;/Predicate&gt;&lt;Axiom&gt;owl:inverseOf :hasValue&lt;/Axiom&gt;&lt;/ObjectProperty&gt;
     * </pre>
     * Gets the value of the valueOf property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the valueOf property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getValueOf().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link IDReferenceType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<IDReferenceType> getValueOf() {
        if (valueOf == null) {
            valueOf = new ArrayList<IDReferenceType>();
        }
        return this.valueOf;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ObjectProperty xmlns="https://semic.org/sa/cv/cccev-2.0.0#" xmlns:an="https://semic.org/sa/cv/common/semic-annot-2.0.0#" xmlns:cac="https://semic.org/sa/cv/common/cac-2.0.0#" xmlns:cagv="https://semic.org/sa/cv/cagv/agent-2.0.0#" xmlns:cbc="https://semic.org/sa/cv/common/cbc-2.0.0#" xmlns:ccts="urn:un:unece:uncefact:data:specification:CoreComponentTypeSchemaModule:2" xmlns:dcat-ap="http://data.europa.eu/r5r/" xmlns:foaf="http://xmlns.com/foaf/0.1/" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;Object property&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Value. value&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition/&gt;&lt;ccts:ObjectClass&gt;Value&lt;/ccts:ObjectClass&gt;&lt;Domain&gt;Value&lt;/Domain&gt;&lt;Range&gt;Value&lt;/Range&gt;&lt;Predicate&gt;hasValue&lt;/Predicate&gt;&lt;/ObjectProperty&gt;
     * </pre>
     * Gets the value of the value property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the value property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getValue().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CCCEVValueType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<CCCEVValueType> getValue() {
        if (value == null) {
            value = new ArrayList<CCCEVValueType>();
        }
        return this.value;
    }

    /**
     * Gets the value of the versionIdAttr property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getVersionIdAttr() {
        return versionIdAttr;
    }

    /**
     * Sets the value of the versionIdAttr property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setVersionIdAttr(
        @Nullable
        String value) {
        this.versionIdAttr = value;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final CCCEVValueType rhs = ((CCCEVValueType) o);
        if (!EqualsHelper.equals(amountValue, rhs.amountValue)) {
            return false;
        }
        if (!EqualsHelper.equals(codeValue, rhs.codeValue)) {
            return false;
        }
        if (!EqualsHelper.equals(customDataType, rhs.customDataType)) {
            return false;
        }
        if (!EqualsHelper.equals(customFunction, rhs.customFunction)) {
            return false;
        }
        if (!EqualsHelper.equals(dateValue, rhs.dateValue)) {
            return false;
        }
        if (!EqualsHelper.equals(error, rhs.error)) {
            return false;
        }
        if (!EqualsHelper.equals(identifierValue, rhs.identifierValue)) {
            return false;
        }
        if (!EqualsHelper.equals(indicatorValue, rhs.indicatorValue)) {
            return false;
        }
        if (!EqualsHelper.equals(measureValue, rhs.measureValue)) {
            return false;
        }
        if (!EqualsHelper.equals(numericValue, rhs.numericValue)) {
            return false;
        }
        if (!EqualsHelper.equals(periodValue, rhs.periodValue)) {
            return false;
        }
        if (!EqualsHelper.equals(quantityValue, rhs.quantityValue)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(textValue, rhs.textValue)) {
            return false;
        }
        if (!EqualsHelper.equals(timeValue, rhs.timeValue)) {
            return false;
        }
        if (!EqualsHelper.equals(uriValue, rhs.uriValue)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(value, rhs.value)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(valueOf, rhs.valueOf)) {
            return false;
        }
        if (!EqualsHelper.equals(versionIdAttr, rhs.versionIdAttr)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(amountValue).append(codeValue).append(customDataType).append(customFunction).append(dateValue).append(error).append(identifierValue).append(indicatorValue).append(measureValue).append(numericValue).append(periodValue).append(quantityValue).append(textValue).append(timeValue).append(uriValue).append(value).append(valueOf).append(versionIdAttr).getHashCode();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("amountValue", amountValue).append("codeValue", codeValue).append("customDataType", customDataType).append("customFunction", customFunction).append("dateValue", dateValue).append("error", error).append("identifierValue", identifierValue).append("indicatorValue", indicatorValue).append("measureValue", measureValue).append("numericValue", numericValue).append("periodValue", periodValue).append("quantityValue", quantityValue).append("textValue", textValue).append("timeValue", timeValue).append("uriValue", uriValue).append("value", value).append("valueOf", valueOf).append("versionIdAttr", versionIdAttr).getToString();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setTextValue(
        @Nullable
        final List<TextType> aList) {
        textValue = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setValueOf(
        @Nullable
        final List<IDReferenceType> aList) {
        valueOf = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setValue(
        @Nullable
        final List<CCCEVValueType> aList) {
        value = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasTextValueEntries() {
        return (!getTextValue().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoTextValueEntries() {
        return getTextValue().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getTextValueCount() {
        return getTextValue().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TextType getTextValueAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getTextValue().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addTextValue(
        @Nonnull
        final TextType elem) {
        getTextValue().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasValueOfEntries() {
        return (!getValueOf().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoValueOfEntries() {
        return getValueOf().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getValueOfCount() {
        return getValueOf().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public IDReferenceType getValueOfAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getValueOf().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addValueOf(
        @Nonnull
        final IDReferenceType elem) {
        getValueOf().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasValueEntries() {
        return (!getValue().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoValueEntries() {
        return getValue().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getValueCount() {
        return getValue().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public CCCEVValueType getValueAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getValue().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addValue(
        @Nonnull
        final CCCEVValueType elem) {
        getValue().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        CCCEVValueType ret) {
        ret.amountValue = ((amountValue == null)?null:amountValue.clone());
        ret.codeValue = ((codeValue == null)?null:codeValue.clone());
        ret.customDataType = ((customDataType == null)?null:customDataType.clone());
        ret.customFunction = ((customFunction == null)?null:customFunction.clone());
        ret.dateValue = ((dateValue == null)?null:dateValue.clone());
        ret.error = ((error == null)?null:error.clone());
        ret.identifierValue = ((identifierValue == null)?null:identifierValue.clone());
        ret.indicatorValue = ((indicatorValue == null)?null:indicatorValue.clone());
        ret.measureValue = ((measureValue == null)?null:measureValue.clone());
        ret.numericValue = ((numericValue == null)?null:numericValue.clone());
        ret.periodValue = ((periodValue == null)?null:periodValue.clone());
        ret.quantityValue = ((quantityValue == null)?null:quantityValue.clone());
        if (textValue == null) {
            ret.textValue = null;
        } else {
            List<TextType> retTextValue = new ArrayList<TextType>();
            for (TextType aItem: getTextValue()) {
                retTextValue.add(((aItem == null)?null:aItem.clone()));
            }
            ret.textValue = retTextValue;
        }
        ret.timeValue = ((timeValue == null)?null:timeValue.clone());
        ret.uriValue = ((uriValue == null)?null:uriValue.clone());
        if (value == null) {
            ret.value = null;
        } else {
            List<CCCEVValueType> retValue = new ArrayList<CCCEVValueType>();
            for (CCCEVValueType aItem: getValue()) {
                retValue.add(((aItem == null)?null:aItem.clone()));
            }
            ret.value = retValue;
        }
        if (valueOf == null) {
            ret.valueOf = null;
        } else {
            List<IDReferenceType> retValueOf = new ArrayList<IDReferenceType>();
            for (IDReferenceType aItem: getValueOf()) {
                retValueOf.add(((aItem == null)?null:aItem.clone()));
            }
            ret.valueOf = retValueOf;
        }
        ret.versionIdAttr = versionIdAttr;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public CCCEVValueType clone() {
        CCCEVValueType ret = new CCCEVValueType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type AmountType and never <code>null</code>
     */
    @Nonnull
    public AmountType setAmountValue(
        @Nullable
        final BigDecimal valueParam) {
        AmountType aObj = getAmountValue();
        if (aObj == null) {
            aObj = new AmountType(valueParam);
            setAmountValue(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type CodeType and never <code>null</code>
     */
    @Nonnull
    public CodeType setCodeValue(
        @Nullable
        final String valueParam) {
        CodeType aObj = getCodeValue();
        if (aObj == null) {
            aObj = new CodeType(valueParam);
            setCodeValue(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type CodeType and never <code>null</code>
     */
    @Nonnull
    public CodeType setCustomDataType(
        @Nullable
        final String valueParam) {
        CodeType aObj = getCustomDataType();
        if (aObj == null) {
            aObj = new CodeType(valueParam);
            setCustomDataType(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type CodeType and never <code>null</code>
     */
    @Nonnull
    public CodeType setError(
        @Nullable
        final String valueParam) {
        CodeType aObj = getError();
        if (aObj == null) {
            aObj = new CodeType(valueParam);
            setError(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type XMLGregorianCalendar<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type DateType and never <code>null</code>
     */
    @Nonnull
    public DateType setDateValue(
        @Nullable
        final XMLGregorianCalendar valueParam) {
        DateType aObj = getDateValue();
        if (aObj == null) {
            aObj = new DateType(valueParam);
            setDateValue(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IDType and never <code>null</code>
     */
    @Nonnull
    public IDType setIdentifierValue(
        @Nullable
        final String valueParam) {
        IDType aObj = getIdentifierValue();
        if (aObj == null) {
            aObj = new IDType(valueParam);
            setIdentifierValue(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type URIType and never <code>null</code>
     */
    @Nonnull
    public URIType setUriValue(
        @Nullable
        final String valueParam) {
        URIType aObj = getUriValue();
        if (aObj == null) {
            aObj = new URIType(valueParam);
            setUriValue(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IDType and never <code>null</code>
     */
    @Nonnull
    public IDType setCustomFunction(
        @Nullable
        final String valueParam) {
        IDType aObj = getCustomFunction();
        if (aObj == null) {
            aObj = new IDType(valueParam);
            setCustomFunction(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type MeasureType and never <code>null</code>
     */
    @Nonnull
    public MeasureType setMeasureValue(
        @Nullable
        final BigDecimal valueParam) {
        MeasureType aObj = getMeasureValue();
        if (aObj == null) {
            aObj = new MeasureType(valueParam);
            setMeasureValue(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type QuantityType and never <code>null</code>
     */
    @Nonnull
    public QuantityType setQuantityValue(
        @Nullable
        final BigDecimal valueParam) {
        QuantityType aObj = getQuantityValue();
        if (aObj == null) {
            aObj = new QuantityType(valueParam);
            setQuantityValue(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type XMLGregorianCalendar<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TimeType and never <code>null</code>
     */
    @Nonnull
    public TimeType setTimeValue(
        @Nullable
        final XMLGregorianCalendar valueParam) {
        TimeType aObj = getTimeValue();
        if (aObj == null) {
            aObj = new TimeType(valueParam);
            setTimeValue(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type NumericType and never <code>null</code>
     */
    @Nonnull
    public NumericType setNumericValue(
        @Nullable
        final BigDecimal valueParam) {
        NumericType aObj = getNumericValue();
        if (aObj == null) {
            aObj = new NumericType(valueParam);
            setNumericValue(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained AmountType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained AmountType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getAmountValueValue() {
        AmountType aObj = getAmountValue();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained CodeType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained CodeType object or <code>null</code>
     */
    @Nullable
    public String getCodeValueValue() {
        CodeType aObj = getCodeValue();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained DateType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained DateType object or <code>null</code>
     */
    @Nullable
    public XMLGregorianCalendar getDateValueValue() {
        DateType aObj = getDateValue();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained IDType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IDType object or <code>null</code>
     */
    @Nullable
    public String getIdentifierValueValue() {
        IDType aObj = getIdentifierValue();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained MeasureType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained MeasureType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getMeasureValueValue() {
        MeasureType aObj = getMeasureValue();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained NumericType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained NumericType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getNumericValueValue() {
        NumericType aObj = getNumericValue();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained QuantityType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained QuantityType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getQuantityValueValue() {
        QuantityType aObj = getQuantityValue();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained TimeType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TimeType object or <code>null</code>
     */
    @Nullable
    public XMLGregorianCalendar getTimeValueValue() {
        TimeType aObj = getTimeValue();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained URIType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained URIType object or <code>null</code>
     */
    @Nullable
    public String getUriValueValue() {
        URIType aObj = getUriValue();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained CodeType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained CodeType object or <code>null</code>
     */
    @Nullable
    public String getCustomDataTypeValue() {
        CodeType aObj = getCustomDataType();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained IDType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IDType object or <code>null</code>
     */
    @Nullable
    public String getCustomFunctionValue() {
        IDType aObj = getCustomFunction();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained CodeType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained CodeType object or <code>null</code>
     */
    @Nullable
    public String getErrorValue() {
        CodeType aObj = getError();
        return ((aObj == null)?null:aObj.getValue());
    }

}
