
package eu.toop.edm.jaxb.dcatap;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import eu.toop.edm.jaxb.cccev.CCCEVDocumentReferenceType;
import eu.toop.edm.jaxb.dcterms.DCLicenceDocumentType;
import eu.toop.edm.jaxb.dcterms.DCMediaType;
import eu.toop.edm.jaxb.dcterms.DCRightStatementType;
import eu.toop.edm.jaxb.dcterms.DCStandardType;
import eu.toop.edm.jaxb.foaf.FoafDocumentType;
import eu.toop.edm.jaxb.spdx.ChecksumType;
import eu.toop.edm.jaxb.w3.odrl.Policy;
import eu.toop.edm.jaxb.w3.skos.ConceptType;


/**
 * <p>Java class for DistributionType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="DistributionType"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element ref="{http://data.europa.eu/r5r/}accessURL"/&gt;
 *         &lt;element ref="{http://www.w3.org/ns/adms#}status" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://xmlns.com/foaf/0.1/}page" minOccurs="0"/&gt;
 *         &lt;element ref="{http://purl.org/dc/terms/}conformsTo" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://purl.org/dc/terms/}issued" minOccurs="0"/&gt;
 *         &lt;element ref="{http://purl.org/dc/terms/}title" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://purl.org/dc/terms/}description" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://purl.org/dc/terms/}format" minOccurs="0"/&gt;
 *         &lt;element ref="{http://purl.org/dc/terms/}modified" minOccurs="0"/&gt;
 *         &lt;element ref="{http://purl.org/dc/terms/}rights" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.w3.org/ns/odrl/2/}hasPolicy" minOccurs="0"/&gt;
 *         &lt;element ref="{spdx:xsd::1.0}checksum" minOccurs="0"/&gt;
 *         &lt;element ref="{http://data.europa.eu/r5r/}accessService" minOccurs="0"/&gt;
 *         &lt;element ref="{http://data.europa.eu/r5r/}availability" minOccurs="0"/&gt;
 *         &lt;element ref="{http://data.europa.eu/r5r/}byteSize" minOccurs="0"/&gt;
 *         &lt;element ref="{http://data.europa.eu/r5r/}compressedFormat" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://data.europa.eu/r5r/}downloadURL" minOccurs="0"/&gt;
 *         &lt;element ref="{http://data.europa.eu/r5r/}mediaType" minOccurs="0"/&gt;
 *         &lt;element ref="{http://data.europa.eu/r5r/}spatialResolutionInMeters" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://data.europa.eu/r5r/}temporalResolution" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://purl.org/dc/terms/}licence" minOccurs="0"/&gt;
 *         &lt;element ref="{http://data.europa.eu/r5r/}packageFormat" minOccurs="0"/&gt;
 *       &lt;/sequence&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * <p>This class was annotated by ph-jaxb22-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "DistributionType", propOrder = {
    "accessURL",
    "status",
    "page",
    "conformsTo",
    "issued",
    "title",
    "description",
    "format",
    "modified",
    "rights",
    "hasPolicy",
    "checksum",
    "accessService",
    "availability",
    "byteSize",
    "compressedFormat",
    "downloadURL",
    "mediaType",
    "spatialResolutionInMeters",
    "temporalResolution",
    "licence",
    "packageFormat"
})
@XmlSeeAlso({
    CCCEVDocumentReferenceType.class
})
@CodingStyleguideUnaware
public class DCatAPDistributionType implements Serializable, IExplicitlyCloneable
{

    @XmlElement(required = true)
    @XmlSchemaType(name = "anyURI")
    private String accessURL;
    @XmlElement(namespace = "http://www.w3.org/ns/adms#")
    private List<ConceptType> status;
    @XmlElement(namespace = "http://xmlns.com/foaf/0.1/")
    private FoafDocumentType page;
    @XmlElement(namespace = "http://purl.org/dc/terms/")
    private List<DCStandardType> conformsTo;
    @XmlElement(namespace = "http://purl.org/dc/terms/")
    @XmlSchemaType(name = "dateTime")
    private XMLGregorianCalendar issued;
    @XmlElement(namespace = "http://purl.org/dc/terms/")
    private List<String> title;
    @XmlElement(namespace = "http://purl.org/dc/terms/")
    private List<String> description;
    @XmlElement(namespace = "http://purl.org/dc/terms/")
    private DCMediaType format;
    @XmlElement(namespace = "http://purl.org/dc/terms/")
    @XmlSchemaType(name = "dateTime")
    private XMLGregorianCalendar modified;
    @XmlElement(namespace = "http://purl.org/dc/terms/")
    private DCRightStatementType rights;
    @XmlElement(namespace = "http://www.w3.org/ns/odrl/2/")
    private Policy hasPolicy;
    @XmlElement(namespace = "spdx:xsd::1.0")
    private ChecksumType checksum;
    private DCatAPDataServiceType accessService;
    private ConceptType availability;
    private BigDecimal byteSize;
    private List<DCMediaType> compressedFormat;
    @XmlSchemaType(name = "anyURI")
    private String downloadURL;
    private DCMediaType mediaType;
    private List<BigDecimal> spatialResolutionInMeters;
    private List<Duration> temporalResolution;
    @XmlElement(namespace = "http://purl.org/dc/terms/")
    private DCLicenceDocumentType licence;
    private DCMediaType packageFormat;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     */
    public DCatAPDistributionType() {
    }

    /**
     * Gets the value of the accessURL property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getAccessURL() {
        return accessURL;
    }

    /**
     * Sets the value of the accessURL property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setAccessURL(
        @Nullable
        String value) {
        this.accessURL = value;
    }

    /**
     * Gets the value of the status property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the status property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getStatus().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ConceptType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<ConceptType> getStatus() {
        if (status == null) {
            status = new ArrayList<ConceptType>();
        }
        return this.status;
    }

    /**
     * Gets the value of the page property.
     * 
     * @return
     *     possible object is
     *     {@link FoafDocumentType }
     *     
     */
    @Nullable
    public FoafDocumentType getPage() {
        return page;
    }

    /**
     * Sets the value of the page property.
     * 
     * @param value
     *     allowed object is
     *     {@link FoafDocumentType }
     *     
     */
    public void setPage(
        @Nullable
        FoafDocumentType value) {
        this.page = value;
    }

    /**
     * Gets the value of the conformsTo property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the conformsTo property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getConformsTo().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DCStandardType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DCStandardType> getConformsTo() {
        if (conformsTo == null) {
            conformsTo = new ArrayList<DCStandardType>();
        }
        return this.conformsTo;
    }

    /**
     * Gets the value of the issued property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    @Nullable
    public XMLGregorianCalendar getIssued() {
        return issued;
    }

    /**
     * Sets the value of the issued property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setIssued(
        @Nullable
        XMLGregorianCalendar value) {
        this.issued = value;
    }

    /**
     * Gets the value of the title property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the title property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getTitle().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link String }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<String> getTitle() {
        if (title == null) {
            title = new ArrayList<String>();
        }
        return this.title;
    }

    /**
     * Gets the value of the description property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the description property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getDescription().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link String }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<String> getDescription() {
        if (description == null) {
            description = new ArrayList<String>();
        }
        return this.description;
    }

    /**
     * Gets the value of the format property.
     * 
     * @return
     *     possible object is
     *     {@link DCMediaType }
     *     
     */
    @Nullable
    public DCMediaType getFormat() {
        return format;
    }

    /**
     * Sets the value of the format property.
     * 
     * @param value
     *     allowed object is
     *     {@link DCMediaType }
     *     
     */
    public void setFormat(
        @Nullable
        DCMediaType value) {
        this.format = value;
    }

    /**
     * Gets the value of the modified property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    @Nullable
    public XMLGregorianCalendar getModified() {
        return modified;
    }

    /**
     * Sets the value of the modified property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setModified(
        @Nullable
        XMLGregorianCalendar value) {
        this.modified = value;
    }

    /**
     * Gets the value of the rights property.
     * 
     * @return
     *     possible object is
     *     {@link DCRightStatementType }
     *     
     */
    @Nullable
    public DCRightStatementType getRights() {
        return rights;
    }

    /**
     * Sets the value of the rights property.
     * 
     * @param value
     *     allowed object is
     *     {@link DCRightStatementType }
     *     
     */
    public void setRights(
        @Nullable
        DCRightStatementType value) {
        this.rights = value;
    }

    /**
     * Gets the value of the hasPolicy property.
     * 
     * @return
     *     possible object is
     *     {@link Policy }
     *     
     */
    @Nullable
    public Policy getHasPolicy() {
        return hasPolicy;
    }

    /**
     * Sets the value of the hasPolicy property.
     * 
     * @param value
     *     allowed object is
     *     {@link Policy }
     *     
     */
    public void setHasPolicy(
        @Nullable
        Policy value) {
        this.hasPolicy = value;
    }

    /**
     * Gets the value of the checksum property.
     * 
     * @return
     *     possible object is
     *     {@link ChecksumType }
     *     
     */
    @Nullable
    public ChecksumType getChecksum() {
        return checksum;
    }

    /**
     * Sets the value of the checksum property.
     * 
     * @param value
     *     allowed object is
     *     {@link ChecksumType }
     *     
     */
    public void setChecksum(
        @Nullable
        ChecksumType value) {
        this.checksum = value;
    }

    /**
     * Gets the value of the accessService property.
     * 
     * @return
     *     possible object is
     *     {@link DCatAPDataServiceType }
     *     
     */
    @Nullable
    public DCatAPDataServiceType getAccessService() {
        return accessService;
    }

    /**
     * Sets the value of the accessService property.
     * 
     * @param value
     *     allowed object is
     *     {@link DCatAPDataServiceType }
     *     
     */
    public void setAccessService(
        @Nullable
        DCatAPDataServiceType value) {
        this.accessService = value;
    }

    /**
     * Gets the value of the availability property.
     * 
     * @return
     *     possible object is
     *     {@link ConceptType }
     *     
     */
    @Nullable
    public ConceptType getAvailability() {
        return availability;
    }

    /**
     * Sets the value of the availability property.
     * 
     * @param value
     *     allowed object is
     *     {@link ConceptType }
     *     
     */
    public void setAvailability(
        @Nullable
        ConceptType value) {
        this.availability = value;
    }

    /**
     * Gets the value of the byteSize property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    @Nullable
    public BigDecimal getByteSize() {
        return byteSize;
    }

    /**
     * Sets the value of the byteSize property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setByteSize(
        @Nullable
        BigDecimal value) {
        this.byteSize = value;
    }

    /**
     * Gets the value of the compressedFormat property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the compressedFormat property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getCompressedFormat().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DCMediaType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DCMediaType> getCompressedFormat() {
        if (compressedFormat == null) {
            compressedFormat = new ArrayList<DCMediaType>();
        }
        return this.compressedFormat;
    }

    /**
     * Gets the value of the downloadURL property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getDownloadURL() {
        return downloadURL;
    }

    /**
     * Sets the value of the downloadURL property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setDownloadURL(
        @Nullable
        String value) {
        this.downloadURL = value;
    }

    /**
     * Gets the value of the mediaType property.
     * 
     * @return
     *     possible object is
     *     {@link DCMediaType }
     *     
     */
    @Nullable
    public DCMediaType getMediaType() {
        return mediaType;
    }

    /**
     * Sets the value of the mediaType property.
     * 
     * @param value
     *     allowed object is
     *     {@link DCMediaType }
     *     
     */
    public void setMediaType(
        @Nullable
        DCMediaType value) {
        this.mediaType = value;
    }

    /**
     * Gets the value of the spatialResolutionInMeters property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the spatialResolutionInMeters property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getSpatialResolutionInMeters().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link BigDecimal }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<BigDecimal> getSpatialResolutionInMeters() {
        if (spatialResolutionInMeters == null) {
            spatialResolutionInMeters = new ArrayList<BigDecimal>();
        }
        return this.spatialResolutionInMeters;
    }

    /**
     * Gets the value of the temporalResolution property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the temporalResolution property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getTemporalResolution().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Duration }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<Duration> getTemporalResolution() {
        if (temporalResolution == null) {
            temporalResolution = new ArrayList<Duration>();
        }
        return this.temporalResolution;
    }

    /**
     * Gets the value of the licence property.
     * 
     * @return
     *     possible object is
     *     {@link DCLicenceDocumentType }
     *     
     */
    @Nullable
    public DCLicenceDocumentType getLicence() {
        return licence;
    }

    /**
     * Sets the value of the licence property.
     * 
     * @param value
     *     allowed object is
     *     {@link DCLicenceDocumentType }
     *     
     */
    public void setLicence(
        @Nullable
        DCLicenceDocumentType value) {
        this.licence = value;
    }

    /**
     * Gets the value of the packageFormat property.
     * 
     * @return
     *     possible object is
     *     {@link DCMediaType }
     *     
     */
    @Nullable
    public DCMediaType getPackageFormat() {
        return packageFormat;
    }

    /**
     * Sets the value of the packageFormat property.
     * 
     * @param value
     *     allowed object is
     *     {@link DCMediaType }
     *     
     */
    public void setPackageFormat(
        @Nullable
        DCMediaType value) {
        this.packageFormat = value;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final DCatAPDistributionType rhs = ((DCatAPDistributionType) o);
        if (!EqualsHelper.equals(accessService, rhs.accessService)) {
            return false;
        }
        if (!EqualsHelper.equals(accessURL, rhs.accessURL)) {
            return false;
        }
        if (!EqualsHelper.equals(availability, rhs.availability)) {
            return false;
        }
        if (!EqualsHelper.equals(byteSize, rhs.byteSize)) {
            return false;
        }
        if (!EqualsHelper.equals(checksum, rhs.checksum)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(compressedFormat, rhs.compressedFormat)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(conformsTo, rhs.conformsTo)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(description, rhs.description)) {
            return false;
        }
        if (!EqualsHelper.equals(downloadURL, rhs.downloadURL)) {
            return false;
        }
        if (!EqualsHelper.equals(format, rhs.format)) {
            return false;
        }
        if (!EqualsHelper.equals(hasPolicy, rhs.hasPolicy)) {
            return false;
        }
        if (!EqualsHelper.equals(issued, rhs.issued)) {
            return false;
        }
        if (!EqualsHelper.equals(licence, rhs.licence)) {
            return false;
        }
        if (!EqualsHelper.equals(mediaType, rhs.mediaType)) {
            return false;
        }
        if (!EqualsHelper.equals(modified, rhs.modified)) {
            return false;
        }
        if (!EqualsHelper.equals(packageFormat, rhs.packageFormat)) {
            return false;
        }
        if (!EqualsHelper.equals(page, rhs.page)) {
            return false;
        }
        if (!EqualsHelper.equals(rights, rhs.rights)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(spatialResolutionInMeters, rhs.spatialResolutionInMeters)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(status, rhs.status)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(temporalResolution, rhs.temporalResolution)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(title, rhs.title)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(accessService).append(accessURL).append(availability).append(byteSize).append(checksum).append(compressedFormat).append(conformsTo).append(description).append(downloadURL).append(format).append(hasPolicy).append(issued).append(licence).append(mediaType).append(modified).append(packageFormat).append(page).append(rights).append(spatialResolutionInMeters).append(status).append(temporalResolution).append(title).getHashCode();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("accessService", accessService).append("accessURL", accessURL).append("availability", availability).append("byteSize", byteSize).append("checksum", checksum).append("compressedFormat", compressedFormat).append("conformsTo", conformsTo).append("description", description).append("downloadURL", downloadURL).append("format", format).append("hasPolicy", hasPolicy).append("issued", issued).append("licence", licence).append("mediaType", mediaType).append("modified", modified).append("packageFormat", packageFormat).append("page", page).append("rights", rights).append("spatialResolutionInMeters", spatialResolutionInMeters).append("status", status).append("temporalResolution", temporalResolution).append("title", title).getToString();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setStatus(
        @Nullable
        final List<ConceptType> aList) {
        status = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setConformsTo(
        @Nullable
        final List<DCStandardType> aList) {
        conformsTo = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setTitle(
        @Nullable
        final List<String> aList) {
        title = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setDescription(
        @Nullable
        final List<String> aList) {
        description = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setCompressedFormat(
        @Nullable
        final List<DCMediaType> aList) {
        compressedFormat = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setSpatialResolutionInMeters(
        @Nullable
        final List<BigDecimal> aList) {
        spatialResolutionInMeters = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setTemporalResolution(
        @Nullable
        final List<Duration> aList) {
        temporalResolution = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasStatusEntries() {
        return (!getStatus().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoStatusEntries() {
        return getStatus().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getStatusCount() {
        return getStatus().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public ConceptType getStatusAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getStatus().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addStatus(
        @Nonnull
        final ConceptType elem) {
        getStatus().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasConformsToEntries() {
        return (!getConformsTo().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoConformsToEntries() {
        return getConformsTo().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getConformsToCount() {
        return getConformsTo().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DCStandardType getConformsToAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getConformsTo().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addConformsTo(
        @Nonnull
        final DCStandardType elem) {
        getConformsTo().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasTitleEntries() {
        return (!getTitle().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoTitleEntries() {
        return getTitle().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getTitleCount() {
        return getTitle().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public String getTitleAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getTitle().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addTitle(
        @Nonnull
        final String elem) {
        getTitle().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasDescriptionEntries() {
        return (!getDescription().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoDescriptionEntries() {
        return getDescription().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getDescriptionCount() {
        return getDescription().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public String getDescriptionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getDescription().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addDescription(
        @Nonnull
        final String elem) {
        getDescription().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasCompressedFormatEntries() {
        return (!getCompressedFormat().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoCompressedFormatEntries() {
        return getCompressedFormat().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getCompressedFormatCount() {
        return getCompressedFormat().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DCMediaType getCompressedFormatAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getCompressedFormat().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addCompressedFormat(
        @Nonnull
        final DCMediaType elem) {
        getCompressedFormat().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasSpatialResolutionInMetersEntries() {
        return (!getSpatialResolutionInMeters().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoSpatialResolutionInMetersEntries() {
        return getSpatialResolutionInMeters().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getSpatialResolutionInMetersCount() {
        return getSpatialResolutionInMeters().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public BigDecimal getSpatialResolutionInMetersAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getSpatialResolutionInMeters().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addSpatialResolutionInMeters(
        @Nonnull
        final BigDecimal elem) {
        getSpatialResolutionInMeters().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasTemporalResolutionEntries() {
        return (!getTemporalResolution().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoTemporalResolutionEntries() {
        return getTemporalResolution().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getTemporalResolutionCount() {
        return getTemporalResolution().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public Duration getTemporalResolutionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getTemporalResolution().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addTemporalResolution(
        @Nonnull
        final Duration elem) {
        getTemporalResolution().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        DCatAPDistributionType ret) {
        ret.accessService = ((accessService == null)?null:accessService.clone());
        ret.accessURL = accessURL;
        ret.availability = ((availability == null)?null:availability.clone());
        ret.byteSize = byteSize;
        ret.checksum = ((checksum == null)?null:checksum.clone());
        if (compressedFormat == null) {
            ret.compressedFormat = null;
        } else {
            List<DCMediaType> retCompressedFormat = new ArrayList<DCMediaType>();
            for (DCMediaType aItem: getCompressedFormat()) {
                retCompressedFormat.add(((aItem == null)?null:aItem.clone()));
            }
            ret.compressedFormat = retCompressedFormat;
        }
        if (conformsTo == null) {
            ret.conformsTo = null;
        } else {
            List<DCStandardType> retConformsTo = new ArrayList<DCStandardType>();
            for (DCStandardType aItem: getConformsTo()) {
                retConformsTo.add(((aItem == null)?null:aItem.clone()));
            }
            ret.conformsTo = retConformsTo;
        }
        if (description == null) {
            ret.description = null;
        } else {
            List<String> retDescription = new ArrayList<String>();
            for (String aItem: getDescription()) {
                retDescription.add(aItem);
            }
            ret.description = retDescription;
        }
        ret.downloadURL = downloadURL;
        ret.format = ((format == null)?null:format.clone());
        ret.hasPolicy = ((hasPolicy == null)?null:hasPolicy.clone());
        ret.issued = ((issued == null)?null:((XMLGregorianCalendar) issued.clone()));
        ret.licence = ((licence == null)?null:licence.clone());
        ret.mediaType = ((mediaType == null)?null:mediaType.clone());
        ret.modified = ((modified == null)?null:((XMLGregorianCalendar) modified.clone()));
        ret.packageFormat = ((packageFormat == null)?null:packageFormat.clone());
        ret.page = ((page == null)?null:page.clone());
        ret.rights = ((rights == null)?null:rights.clone());
        if (spatialResolutionInMeters == null) {
            ret.spatialResolutionInMeters = null;
        } else {
            List<BigDecimal> retSpatialResolutionInMeters = new ArrayList<BigDecimal>();
            for (BigDecimal aItem: getSpatialResolutionInMeters()) {
                retSpatialResolutionInMeters.add(aItem);
            }
            ret.spatialResolutionInMeters = retSpatialResolutionInMeters;
        }
        if (status == null) {
            ret.status = null;
        } else {
            List<ConceptType> retStatus = new ArrayList<ConceptType>();
            for (ConceptType aItem: getStatus()) {
                retStatus.add(((aItem == null)?null:aItem.clone()));
            }
            ret.status = retStatus;
        }
        if (temporalResolution == null) {
            ret.temporalResolution = null;
        } else {
            List<Duration> retTemporalResolution = new ArrayList<Duration>();
            for (Duration aItem: getTemporalResolution()) {
                retTemporalResolution.add(aItem);
            }
            ret.temporalResolution = retTemporalResolution;
        }
        if (title == null) {
            ret.title = null;
        } else {
            List<String> retTitle = new ArrayList<String>();
            for (String aItem: getTitle()) {
                retTitle.add(aItem);
            }
            ret.title = retTitle;
        }
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public DCatAPDistributionType clone() {
        DCatAPDistributionType ret = new DCatAPDistributionType();
        cloneTo(ret);
        return ret;
    }

}
