
package eu.toop.edm.jaxb.cv.agent;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.XMLGregorianCalendar;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import eu.toop.edm.jaxb.cv.cbc.CodeType;
import eu.toop.edm.jaxb.cv.cbc.DateType;
import eu.toop.edm.jaxb.cv.cbc.NameType;
import eu.toop.edm.jaxb.w3.locn.LocationType;


/**
 * <p>Java class for PersonType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="PersonType"&gt;
 *   &lt;complexContent&gt;
 *     &lt;extension base="{https://semic.org/sa/cv/cagv/agent-2.0.0#}AgentType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element ref="{https://semic.org/sa/cv/cagv/agent-2.0.0#}fullName" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{https://semic.org/sa/cv/cagv/agent-2.0.0#}givenName" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{https://semic.org/sa/cv/cagv/agent-2.0.0#}familyName" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{https://semic.org/sa/cv/cagv/agent-2.0.0#}patronimicName" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{https://semic.org/sa/cv/cagv/agent-2.0.0#}alternativeName" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{https://semic.org/sa/cv/cagv/agent-2.0.0#}birthFamilyName" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{https://semic.org/sa/cv/cagv/agent-2.0.0#}gender" minOccurs="0"/&gt;
 *         &lt;element ref="{https://semic.org/sa/cv/cagv/agent-2.0.0#}dateOfBirth" minOccurs="0"/&gt;
 *         &lt;element ref="{https://semic.org/sa/cv/cagv/agent-2.0.0#}dateOfDeath" minOccurs="0"/&gt;
 *         &lt;element ref="{https://semic.org/sa/cv/cagv/agent-2.0.0#}legalLocation" minOccurs="0"/&gt;
 *         &lt;element ref="{https://semic.org/sa/cv/cagv/agent-2.0.0#}citizenship" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{https://semic.org/sa/cv/cagv/agent-2.0.0#}countryOfBirth" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{https://semic.org/sa/cv/cagv/agent-2.0.0#}countryOfDeath" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{https://semic.org/sa/cv/cagv/agent-2.0.0#}placeOfBirth" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{https://semic.org/sa/cv/cagv/agent-2.0.0#}placeOfDeath" maxOccurs="unbounded" minOccurs="0"/&gt;
 *       &lt;/sequence&gt;
 *     &lt;/extension&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * <p>This class was annotated by ph-jaxb22-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "PersonType", propOrder = {
    "fullName",
    "givenName",
    "familyName",
    "patronimicName",
    "alternativeName",
    "birthFamilyName",
    "gender",
    "dateOfBirth",
    "dateOfDeath",
    "legalLocation",
    "citizenship",
    "countryOfBirth",
    "countryOfDeath",
    "placeOfBirth",
    "placeOfDeath"
})
@CodingStyleguideUnaware
public class PersonType
    extends AgentType
{

    private List<NameType> fullName;
    private List<NameType> givenName;
    private List<NameType> familyName;
    private List<NameType> patronimicName;
    private List<NameType> alternativeName;
    private List<NameType> birthFamilyName;
    private CodeType gender;
    private DateType dateOfBirth;
    private DateType dateOfDeath;
    private LocationType legalLocation;
    private List<CodeType> citizenship;
    private List<LocationType> countryOfBirth;
    private List<LocationType> countryOfDeath;
    private List<LocationType> placeOfBirth;
    private List<LocationType> placeOfDeath;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     */
    public PersonType() {
    }

    /**
     * Gets the value of the fullName property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the fullName property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getFullName().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link NameType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<NameType> getFullName() {
        if (fullName == null) {
            fullName = new ArrayList<NameType>();
        }
        return this.fullName;
    }

    /**
     * Gets the value of the givenName property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the givenName property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getGivenName().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link NameType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<NameType> getGivenName() {
        if (givenName == null) {
            givenName = new ArrayList<NameType>();
        }
        return this.givenName;
    }

    /**
     * Gets the value of the familyName property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the familyName property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getFamilyName().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link NameType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<NameType> getFamilyName() {
        if (familyName == null) {
            familyName = new ArrayList<NameType>();
        }
        return this.familyName;
    }

    /**
     * Gets the value of the patronimicName property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the patronimicName property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPatronimicName().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link NameType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<NameType> getPatronimicName() {
        if (patronimicName == null) {
            patronimicName = new ArrayList<NameType>();
        }
        return this.patronimicName;
    }

    /**
     * Gets the value of the alternativeName property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the alternativeName property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getAlternativeName().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link NameType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<NameType> getAlternativeName() {
        if (alternativeName == null) {
            alternativeName = new ArrayList<NameType>();
        }
        return this.alternativeName;
    }

    /**
     * Gets the value of the birthFamilyName property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the birthFamilyName property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getBirthFamilyName().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link NameType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<NameType> getBirthFamilyName() {
        if (birthFamilyName == null) {
            birthFamilyName = new ArrayList<NameType>();
        }
        return this.birthFamilyName;
    }

    /**
     * Gets the value of the gender property.
     * 
     * @return
     *     possible object is
     *     {@link CodeType }
     *     
     */
    @Nullable
    public CodeType getGender() {
        return gender;
    }

    /**
     * Sets the value of the gender property.
     * 
     * @param value
     *     allowed object is
     *     {@link CodeType }
     *     
     */
    public void setGender(
        @Nullable
        CodeType value) {
        this.gender = value;
    }

    /**
     * Gets the value of the dateOfBirth property.
     * 
     * @return
     *     possible object is
     *     {@link DateType }
     *     
     */
    @Nullable
    public DateType getDateOfBirth() {
        return dateOfBirth;
    }

    /**
     * Sets the value of the dateOfBirth property.
     * 
     * @param value
     *     allowed object is
     *     {@link DateType }
     *     
     */
    public void setDateOfBirth(
        @Nullable
        DateType value) {
        this.dateOfBirth = value;
    }

    /**
     * Gets the value of the dateOfDeath property.
     * 
     * @return
     *     possible object is
     *     {@link DateType }
     *     
     */
    @Nullable
    public DateType getDateOfDeath() {
        return dateOfDeath;
    }

    /**
     * Sets the value of the dateOfDeath property.
     * 
     * @param value
     *     allowed object is
     *     {@link DateType }
     *     
     */
    public void setDateOfDeath(
        @Nullable
        DateType value) {
        this.dateOfDeath = value;
    }

    /**
     * Gets the value of the legalLocation property.
     * 
     * @return
     *     possible object is
     *     {@link LocationType }
     *     
     */
    @Nullable
    public LocationType getLegalLocation() {
        return legalLocation;
    }

    /**
     * Sets the value of the legalLocation property.
     * 
     * @param value
     *     allowed object is
     *     {@link LocationType }
     *     
     */
    public void setLegalLocation(
        @Nullable
        LocationType value) {
        this.legalLocation = value;
    }

    /**
     * Gets the value of the citizenship property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the citizenship property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getCitizenship().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CodeType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<CodeType> getCitizenship() {
        if (citizenship == null) {
            citizenship = new ArrayList<CodeType>();
        }
        return this.citizenship;
    }

    /**
     * Gets the value of the countryOfBirth property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the countryOfBirth property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getCountryOfBirth().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link LocationType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<LocationType> getCountryOfBirth() {
        if (countryOfBirth == null) {
            countryOfBirth = new ArrayList<LocationType>();
        }
        return this.countryOfBirth;
    }

    /**
     * Gets the value of the countryOfDeath property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the countryOfDeath property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getCountryOfDeath().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link LocationType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<LocationType> getCountryOfDeath() {
        if (countryOfDeath == null) {
            countryOfDeath = new ArrayList<LocationType>();
        }
        return this.countryOfDeath;
    }

    /**
     * Gets the value of the placeOfBirth property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the placeOfBirth property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPlaceOfBirth().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link LocationType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<LocationType> getPlaceOfBirth() {
        if (placeOfBirth == null) {
            placeOfBirth = new ArrayList<LocationType>();
        }
        return this.placeOfBirth;
    }

    /**
     * Gets the value of the placeOfDeath property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the placeOfDeath property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPlaceOfDeath().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link LocationType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<LocationType> getPlaceOfDeath() {
        if (placeOfDeath == null) {
            placeOfDeath = new ArrayList<LocationType>();
        }
        return this.placeOfDeath;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        final PersonType rhs = ((PersonType) o);
        if (!EqualsHelper.equalsCollection(alternativeName, rhs.alternativeName)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(birthFamilyName, rhs.birthFamilyName)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(citizenship, rhs.citizenship)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(countryOfBirth, rhs.countryOfBirth)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(countryOfDeath, rhs.countryOfDeath)) {
            return false;
        }
        if (!EqualsHelper.equals(dateOfBirth, rhs.dateOfBirth)) {
            return false;
        }
        if (!EqualsHelper.equals(dateOfDeath, rhs.dateOfDeath)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(familyName, rhs.familyName)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(fullName, rhs.fullName)) {
            return false;
        }
        if (!EqualsHelper.equals(gender, rhs.gender)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(givenName, rhs.givenName)) {
            return false;
        }
        if (!EqualsHelper.equals(legalLocation, rhs.legalLocation)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(patronimicName, rhs.patronimicName)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(placeOfBirth, rhs.placeOfBirth)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(placeOfDeath, rhs.placeOfDeath)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived(super.hashCode()).append(alternativeName).append(birthFamilyName).append(citizenship).append(countryOfBirth).append(countryOfDeath).append(dateOfBirth).append(dateOfDeath).append(familyName).append(fullName).append(gender).append(givenName).append(legalLocation).append(patronimicName).append(placeOfBirth).append(placeOfDeath).getHashCode();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("alternativeName", alternativeName).append("birthFamilyName", birthFamilyName).append("citizenship", citizenship).append("countryOfBirth", countryOfBirth).append("countryOfDeath", countryOfDeath).append("dateOfBirth", dateOfBirth).append("dateOfDeath", dateOfDeath).append("familyName", familyName).append("fullName", fullName).append("gender", gender).append("givenName", givenName).append("legalLocation", legalLocation).append("patronimicName", patronimicName).append("placeOfBirth", placeOfBirth).append("placeOfDeath", placeOfDeath).getToString();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setFullName(
        @Nullable
        final List<NameType> aList) {
        fullName = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setGivenName(
        @Nullable
        final List<NameType> aList) {
        givenName = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setFamilyName(
        @Nullable
        final List<NameType> aList) {
        familyName = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setPatronimicName(
        @Nullable
        final List<NameType> aList) {
        patronimicName = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setAlternativeName(
        @Nullable
        final List<NameType> aList) {
        alternativeName = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setBirthFamilyName(
        @Nullable
        final List<NameType> aList) {
        birthFamilyName = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setCitizenship(
        @Nullable
        final List<CodeType> aList) {
        citizenship = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setCountryOfBirth(
        @Nullable
        final List<LocationType> aList) {
        countryOfBirth = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setCountryOfDeath(
        @Nullable
        final List<LocationType> aList) {
        countryOfDeath = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setPlaceOfBirth(
        @Nullable
        final List<LocationType> aList) {
        placeOfBirth = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setPlaceOfDeath(
        @Nullable
        final List<LocationType> aList) {
        placeOfDeath = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasFullNameEntries() {
        return (!getFullName().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoFullNameEntries() {
        return getFullName().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getFullNameCount() {
        return getFullName().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public NameType getFullNameAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getFullName().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addFullName(
        @Nonnull
        final NameType elem) {
        getFullName().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasGivenNameEntries() {
        return (!getGivenName().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoGivenNameEntries() {
        return getGivenName().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getGivenNameCount() {
        return getGivenName().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public NameType getGivenNameAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getGivenName().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addGivenName(
        @Nonnull
        final NameType elem) {
        getGivenName().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasFamilyNameEntries() {
        return (!getFamilyName().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoFamilyNameEntries() {
        return getFamilyName().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getFamilyNameCount() {
        return getFamilyName().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public NameType getFamilyNameAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getFamilyName().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addFamilyName(
        @Nonnull
        final NameType elem) {
        getFamilyName().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasPatronimicNameEntries() {
        return (!getPatronimicName().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoPatronimicNameEntries() {
        return getPatronimicName().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getPatronimicNameCount() {
        return getPatronimicName().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public NameType getPatronimicNameAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getPatronimicName().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addPatronimicName(
        @Nonnull
        final NameType elem) {
        getPatronimicName().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasAlternativeNameEntries() {
        return (!getAlternativeName().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoAlternativeNameEntries() {
        return getAlternativeName().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getAlternativeNameCount() {
        return getAlternativeName().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public NameType getAlternativeNameAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getAlternativeName().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addAlternativeName(
        @Nonnull
        final NameType elem) {
        getAlternativeName().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasBirthFamilyNameEntries() {
        return (!getBirthFamilyName().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoBirthFamilyNameEntries() {
        return getBirthFamilyName().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getBirthFamilyNameCount() {
        return getBirthFamilyName().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public NameType getBirthFamilyNameAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getBirthFamilyName().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addBirthFamilyName(
        @Nonnull
        final NameType elem) {
        getBirthFamilyName().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasCitizenshipEntries() {
        return (!getCitizenship().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoCitizenshipEntries() {
        return getCitizenship().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getCitizenshipCount() {
        return getCitizenship().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public CodeType getCitizenshipAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getCitizenship().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addCitizenship(
        @Nonnull
        final CodeType elem) {
        getCitizenship().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasCountryOfBirthEntries() {
        return (!getCountryOfBirth().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoCountryOfBirthEntries() {
        return getCountryOfBirth().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getCountryOfBirthCount() {
        return getCountryOfBirth().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public LocationType getCountryOfBirthAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getCountryOfBirth().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addCountryOfBirth(
        @Nonnull
        final LocationType elem) {
        getCountryOfBirth().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasCountryOfDeathEntries() {
        return (!getCountryOfDeath().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoCountryOfDeathEntries() {
        return getCountryOfDeath().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getCountryOfDeathCount() {
        return getCountryOfDeath().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public LocationType getCountryOfDeathAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getCountryOfDeath().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addCountryOfDeath(
        @Nonnull
        final LocationType elem) {
        getCountryOfDeath().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasPlaceOfBirthEntries() {
        return (!getPlaceOfBirth().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoPlaceOfBirthEntries() {
        return getPlaceOfBirth().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getPlaceOfBirthCount() {
        return getPlaceOfBirth().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public LocationType getPlaceOfBirthAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getPlaceOfBirth().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addPlaceOfBirth(
        @Nonnull
        final LocationType elem) {
        getPlaceOfBirth().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasPlaceOfDeathEntries() {
        return (!getPlaceOfDeath().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoPlaceOfDeathEntries() {
        return getPlaceOfDeath().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getPlaceOfDeathCount() {
        return getPlaceOfDeath().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public LocationType getPlaceOfDeathAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getPlaceOfDeath().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addPlaceOfDeath(
        @Nonnull
        final LocationType elem) {
        getPlaceOfDeath().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        PersonType ret) {
        super.cloneTo(ret);
        if (alternativeName == null) {
            ret.alternativeName = null;
        } else {
            List<NameType> retAlternativeName = new ArrayList<NameType>();
            for (NameType aItem: getAlternativeName()) {
                retAlternativeName.add(((aItem == null)?null:aItem.clone()));
            }
            ret.alternativeName = retAlternativeName;
        }
        if (birthFamilyName == null) {
            ret.birthFamilyName = null;
        } else {
            List<NameType> retBirthFamilyName = new ArrayList<NameType>();
            for (NameType aItem: getBirthFamilyName()) {
                retBirthFamilyName.add(((aItem == null)?null:aItem.clone()));
            }
            ret.birthFamilyName = retBirthFamilyName;
        }
        if (citizenship == null) {
            ret.citizenship = null;
        } else {
            List<CodeType> retCitizenship = new ArrayList<CodeType>();
            for (CodeType aItem: getCitizenship()) {
                retCitizenship.add(((aItem == null)?null:aItem.clone()));
            }
            ret.citizenship = retCitizenship;
        }
        if (countryOfBirth == null) {
            ret.countryOfBirth = null;
        } else {
            List<LocationType> retCountryOfBirth = new ArrayList<LocationType>();
            for (LocationType aItem: getCountryOfBirth()) {
                retCountryOfBirth.add(((aItem == null)?null:aItem.clone()));
            }
            ret.countryOfBirth = retCountryOfBirth;
        }
        if (countryOfDeath == null) {
            ret.countryOfDeath = null;
        } else {
            List<LocationType> retCountryOfDeath = new ArrayList<LocationType>();
            for (LocationType aItem: getCountryOfDeath()) {
                retCountryOfDeath.add(((aItem == null)?null:aItem.clone()));
            }
            ret.countryOfDeath = retCountryOfDeath;
        }
        ret.dateOfBirth = ((dateOfBirth == null)?null:dateOfBirth.clone());
        ret.dateOfDeath = ((dateOfDeath == null)?null:dateOfDeath.clone());
        if (familyName == null) {
            ret.familyName = null;
        } else {
            List<NameType> retFamilyName = new ArrayList<NameType>();
            for (NameType aItem: getFamilyName()) {
                retFamilyName.add(((aItem == null)?null:aItem.clone()));
            }
            ret.familyName = retFamilyName;
        }
        if (fullName == null) {
            ret.fullName = null;
        } else {
            List<NameType> retFullName = new ArrayList<NameType>();
            for (NameType aItem: getFullName()) {
                retFullName.add(((aItem == null)?null:aItem.clone()));
            }
            ret.fullName = retFullName;
        }
        ret.gender = ((gender == null)?null:gender.clone());
        if (givenName == null) {
            ret.givenName = null;
        } else {
            List<NameType> retGivenName = new ArrayList<NameType>();
            for (NameType aItem: getGivenName()) {
                retGivenName.add(((aItem == null)?null:aItem.clone()));
            }
            ret.givenName = retGivenName;
        }
        ret.legalLocation = ((legalLocation == null)?null:legalLocation.clone());
        if (patronimicName == null) {
            ret.patronimicName = null;
        } else {
            List<NameType> retPatronimicName = new ArrayList<NameType>();
            for (NameType aItem: getPatronimicName()) {
                retPatronimicName.add(((aItem == null)?null:aItem.clone()));
            }
            ret.patronimicName = retPatronimicName;
        }
        if (placeOfBirth == null) {
            ret.placeOfBirth = null;
        } else {
            List<LocationType> retPlaceOfBirth = new ArrayList<LocationType>();
            for (LocationType aItem: getPlaceOfBirth()) {
                retPlaceOfBirth.add(((aItem == null)?null:aItem.clone()));
            }
            ret.placeOfBirth = retPlaceOfBirth;
        }
        if (placeOfDeath == null) {
            ret.placeOfDeath = null;
        } else {
            List<LocationType> retPlaceOfDeath = new ArrayList<LocationType>();
            for (LocationType aItem: getPlaceOfDeath()) {
                retPlaceOfDeath.add(((aItem == null)?null:aItem.clone()));
            }
            ret.placeOfDeath = retPlaceOfDeath;
        }
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public PersonType clone() {
        PersonType ret = new PersonType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type CodeType and never <code>null</code>
     */
    @Nonnull
    public CodeType setGender(
        @Nullable
        final String valueParam) {
        CodeType aObj = getGender();
        if (aObj == null) {
            aObj = new CodeType(valueParam);
            setGender(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type XMLGregorianCalendar<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type DateType and never <code>null</code>
     */
    @Nonnull
    public DateType setDateOfBirth(
        @Nullable
        final XMLGregorianCalendar valueParam) {
        DateType aObj = getDateOfBirth();
        if (aObj == null) {
            aObj = new DateType(valueParam);
            setDateOfBirth(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type XMLGregorianCalendar<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type DateType and never <code>null</code>
     */
    @Nonnull
    public DateType setDateOfDeath(
        @Nullable
        final XMLGregorianCalendar valueParam) {
        DateType aObj = getDateOfDeath();
        if (aObj == null) {
            aObj = new DateType(valueParam);
            setDateOfDeath(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained CodeType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained CodeType object or <code>null</code>
     */
    @Nullable
    public String getGenderValue() {
        CodeType aObj = getGender();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained DateType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained DateType object or <code>null</code>
     */
    @Nullable
    public XMLGregorianCalendar getDateOfBirthValue() {
        DateType aObj = getDateOfBirth();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained DateType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained DateType object or <code>null</code>
     */
    @Nullable
    public XMLGregorianCalendar getDateOfDeathValue() {
        DateType aObj = getDateOfDeath();
        return ((aObj == null)?null:aObj.getValue());
    }

}
