/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.edm.xml;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.debug.GlobalDebug;
import com.helger.jaxb.IJAXBReader;
import eu.toop.edm.xml.IJAXBVersatileReader;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.transform.Source;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class JAXBVersatileReader<JAXBTYPE, T>
implements IJAXBVersatileReader<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JAXBVersatileReader.class);
    private final IJAXBReader<JAXBTYPE> m_aReader;
    private final Function<JAXBTYPE, T> m_aMapper;

    public JAXBVersatileReader(@Nonnull IJAXBReader<JAXBTYPE> iJAXBReader, @Nonnull Function<JAXBTYPE, T> function) {
        ValueEnforcer.notNull(iJAXBReader, (String)"Reader");
        ValueEnforcer.notNull(function, (String)"Mapper");
        this.m_aReader = iJAXBReader;
        this.m_aMapper = function;
    }

    @Override
    @Nullable
    public T read(@Nonnull Source source) {
        Object object = this.m_aReader.read(source);
        if (object == null) {
            return null;
        }
        try {
            return this.m_aMapper.apply(object);
        }
        catch (RuntimeException runtimeException) {
            if (GlobalDebug.isDebugMode()) {
                LOGGER.warn("Error mapping the read XML to the target type", (Throwable)runtimeException);
            }
            return null;
        }
    }

    @Override
    @Nullable
    public T read(@Nonnull Node node) {
        Object object = this.m_aReader.read(node);
        return object == null ? null : (T)this.m_aMapper.apply(object);
    }
}

