/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.edm.xml;

import com.helger.commons.io.stream.StreamHelper;
import com.helger.xml.XMLHelper;
import com.helger.xml.serialize.read.DOMReader;
import eu.toop.edm.EDMErrorResponse;
import eu.toop.edm.EDMRequest;
import eu.toop.edm.EDMResponse;
import eu.toop.edm.IEDMTopLevelObject;
import java.io.InputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Immutable
public final class EDMPayloadDeterminator {
    private static final Logger LOGGER = LoggerFactory.getLogger(EDMPayloadDeterminator.class);

    private EDMPayloadDeterminator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static IEDMTopLevelObject parseAndFind(@Nonnull @WillClose InputStream inputStream) {
        try {
            Element element;
            Document document = DOMReader.readXMLDOM((InputStream)inputStream);
            if (document != null) {
                element = document.getDocumentElement();
                if (element != null) {
                    String string = element.getNamespaceURI();
                    String string2 = element.getLocalName();
                    if ("urn:oasis:names:tc:ebxml-regrep:xsd:query:4.0".equals(string) && "QueryRequest".equals(string2)) {
                        EDMRequest eDMRequest = EDMRequest.reader().read(document);
                        if (eDMRequest != null) {
                            LOGGER.info("Sucessfully read the payload as an EDMRequest");
                            EDMRequest eDMRequest2 = eDMRequest;
                            return eDMRequest2;
                        }
                        LOGGER.warn("Failed to read the payload as an EDMRequest");
                    } else if ("urn:oasis:names:tc:ebxml-regrep:xsd:query:4.0".equals(string) && "QueryResponse".equals(string2)) {
                        IEDMTopLevelObject iEDMTopLevelObject;
                        if (XMLHelper.getFirstChildElementOfName((Node)element, (String)"urn:oasis:names:tc:ebxml-regrep:xsd:rs:4.0", (String)"Exception") != null) {
                            iEDMTopLevelObject = EDMErrorResponse.reader().read(document);
                            if (iEDMTopLevelObject != null) {
                                LOGGER.info("Sucessfully read the payload as an EDMErrorResponse");
                                IEDMTopLevelObject iEDMTopLevelObject2 = iEDMTopLevelObject;
                                return iEDMTopLevelObject2;
                            }
                            LOGGER.warn("Failed to read the payload as an EDMErrorResponse");
                        }
                        if ((iEDMTopLevelObject = EDMResponse.reader().read(document)) != null) {
                            LOGGER.info("Sucessfully read the payload as an EDMResponse");
                            IEDMTopLevelObject iEDMTopLevelObject3 = iEDMTopLevelObject;
                            return iEDMTopLevelObject3;
                        }
                        LOGGER.warn("Failed to read the payload as an EDMResponse");
                    } else if (LOGGER.isWarnEnabled()) {
                        LOGGER.warn("The contained XML could not be interpreted. Root element is {" + string + "}" + string2);
                    }
                } else {
                    LOGGER.warn("The parsed XML document has no root element");
                }
            } else {
                LOGGER.warn("Failed to parse the InputStream as an XML document");
            }
            element = null;
            return element;
        }
        finally {
            StreamHelper.close((AutoCloseable)inputStream);
        }
    }
}

