/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.edm.response;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import eu.toop.edm.jaxb.dcatap.DCatAPDatasetType;
import eu.toop.edm.model.DatasetPojo;
import eu.toop.edm.response.IEDMResponsePayloadDocumentReference;
import eu.toop.edm.slot.SlotDocumentMetadata;
import eu.toop.edm.xml.dcatap.DatasetMarshaller;
import eu.toop.regrep.rim.AnyValueType;
import eu.toop.regrep.rim.ObjectRefType;
import eu.toop.regrep.rim.SlotType;
import eu.toop.regrep.rim.ValueType;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.w3c.dom.Node;

public class ResponseDocumentReferencePojo
implements IEDMResponsePayloadDocumentReference {
    private final String m_sRegistryObjectID;
    private final DatasetPojo m_aDataset;

    public ResponseDocumentReferencePojo(@Nonnull @Nonempty String string, @Nonnull DatasetPojo datasetPojo) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"RegistryObjectID");
        ValueEnforcer.notNull((Object)datasetPojo, (String)"Dataset");
        this.m_sRegistryObjectID = string;
        this.m_aDataset = datasetPojo;
    }

    @Override
    @Nonnull
    @Nonempty
    public final String getRegistryObjectID() {
        return this.m_sRegistryObjectID;
    }

    @Override
    @Nonnull
    public final DatasetPojo getDataset() {
        return this.m_aDataset;
    }

    @Override
    @Nonnull
    public ObjectRefType getAsObjectRef() {
        ObjectRefType objectRefType = new ObjectRefType();
        objectRefType.setId(this.m_sRegistryObjectID);
        objectRefType.addSlot(new SlotDocumentMetadata(this.m_aDataset).createSlot());
        return objectRefType;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ResponseDocumentReferencePojo responseDocumentReferencePojo = (ResponseDocumentReferencePojo)object;
        return EqualsHelper.equals((Object)this.m_sRegistryObjectID, (Object)responseDocumentReferencePojo.m_sRegistryObjectID) && EqualsHelper.equals((Object)this.m_aDataset, (Object)responseDocumentReferencePojo.m_aDataset);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sRegistryObjectID).append((Object)this.m_aDataset).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("RegistryObjectID", (Object)this.m_sRegistryObjectID).append("Dataset", (Object)this.m_aDataset).getToString();
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    private static void _applySlots(@Nonnull SlotType slotType, @Nonnull Builder builder) {
        String string = slotType.getName();
        ValueType valueType = slotType.getSlotValue();
        switch (string) {
            case "DocumentMetadata": {
                if (!(valueType instanceof AnyValueType)) break;
                Node node = (Node)((AnyValueType)valueType).getAny();
                builder.dataset(DatasetPojo.builder((DCatAPDatasetType)new DatasetMarshaller().read(node)));
                break;
            }
            default: {
                throw new IllegalStateException("Found unsupported slot '" + string + "'");
            }
        }
    }

    @Nonnull
    public static Builder builder(@Nullable ObjectRefType objectRefType) {
        Builder builder = new Builder();
        if (objectRefType != null) {
            builder.registryObjectID(objectRefType.getId());
            for (SlotType slotType : objectRefType.getSlot()) {
                ResponseDocumentReferencePojo._applySlots(slotType, builder);
            }
        }
        return builder;
    }

    public static class Builder {
        private String m_sRegistryObjectID;
        private DatasetPojo m_aDataset;

        protected Builder() {
        }

        @Nonnull
        public Builder registryObjectID(@Nullable String string) {
            this.m_sRegistryObjectID = string;
            return this;
        }

        @Nonnull
        public Builder randomRegistryObjectID() {
            return this.registryObjectID(UUID.randomUUID().toString());
        }

        @Nonnull
        public Builder dataset(@Nullable DatasetPojo.Builder builder) {
            return this.dataset(builder == null ? null : builder.build());
        }

        @Nonnull
        public Builder dataset(@Nullable DatasetPojo datasetPojo) {
            this.m_aDataset = datasetPojo;
            return this;
        }

        @Nonnull
        public Builder dataset(@Nullable DCatAPDatasetType dCatAPDatasetType) {
            return this.dataset(dCatAPDatasetType == null ? null : DatasetPojo.builder(dCatAPDatasetType));
        }

        public void checkConsistency() {
            if (StringHelper.hasNoText((String)this.m_sRegistryObjectID)) {
                throw new IllegalStateException("RegistryObjectID must be present");
            }
            if (this.m_aDataset == null) {
                throw new IllegalStateException("Dataset MUST be present");
            }
        }

        @Nonnull
        public ResponseDocumentReferencePojo build() {
            this.checkConsistency();
            return new ResponseDocumentReferencePojo(this.m_sRegistryObjectID, this.m_aDataset);
        }
    }
}

