/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.edm.response;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import eu.toop.edm.jaxb.dcatap.DCatAPDatasetType;
import eu.toop.edm.model.DatasetPojo;
import eu.toop.edm.model.RepositoryItemRefPojo;
import eu.toop.edm.response.IEDMResponsePayloadDocument;
import eu.toop.edm.slot.SlotDocumentMetadata;
import eu.toop.edm.xml.dcatap.DatasetMarshaller;
import eu.toop.regrep.rim.AnyValueType;
import eu.toop.regrep.rim.ExtrinsicObjectType;
import eu.toop.regrep.rim.SimpleLinkType;
import eu.toop.regrep.rim.SlotType;
import eu.toop.regrep.rim.ValueType;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.w3c.dom.Node;

public class ResponseDocumentPojo
implements IEDMResponsePayloadDocument {
    private final String m_sRegistryObjectID;
    private final DatasetPojo m_aDataset;
    private final RepositoryItemRefPojo m_aRepositoryItemRef;

    public ResponseDocumentPojo(@Nonnull @Nonempty String string, @Nonnull DatasetPojo datasetPojo, @Nonnull RepositoryItemRefPojo repositoryItemRefPojo) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"RegistryObjectID");
        ValueEnforcer.notNull((Object)datasetPojo, (String)"Dataset");
        ValueEnforcer.notNull((Object)repositoryItemRefPojo, (String)"RepositoryItemRef");
        this.m_sRegistryObjectID = string;
        this.m_aDataset = datasetPojo;
        this.m_aRepositoryItemRef = repositoryItemRefPojo;
    }

    @Override
    @Nonnull
    @Nonempty
    public final String getRegistryObjectID() {
        return this.m_sRegistryObjectID;
    }

    @Override
    @Nonnull
    public final DatasetPojo getDataset() {
        return this.m_aDataset;
    }

    @Override
    @Nonnull
    public final RepositoryItemRefPojo getRepositoryItemRef() {
        return this.m_aRepositoryItemRef;
    }

    @Nonnull
    public ExtrinsicObjectType getAsRegistryObject() {
        ExtrinsicObjectType extrinsicObjectType = new ExtrinsicObjectType();
        extrinsicObjectType.setId(this.m_sRegistryObjectID);
        extrinsicObjectType.addSlot(new SlotDocumentMetadata(this.m_aDataset).createSlot());
        extrinsicObjectType.setRepositoryItemRef(this.m_aRepositoryItemRef.getAsSimpleLink());
        return extrinsicObjectType;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ResponseDocumentPojo responseDocumentPojo = (ResponseDocumentPojo)object;
        return EqualsHelper.equals((Object)this.m_sRegistryObjectID, (Object)responseDocumentPojo.m_sRegistryObjectID) && EqualsHelper.equals((Object)this.m_aDataset, (Object)responseDocumentPojo.m_aDataset) && EqualsHelper.equals((Object)this.m_aRepositoryItemRef, (Object)responseDocumentPojo.m_aRepositoryItemRef);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sRegistryObjectID).append((Object)this.m_aDataset).append((Object)this.m_aRepositoryItemRef).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("RegistryObjectID", (Object)this.m_sRegistryObjectID).append("Dataset", (Object)this.m_aDataset).append("RepositoryItemRef", (Object)this.m_aRepositoryItemRef).getToString();
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    private static void _applySlots(@Nonnull SlotType slotType, @Nonnull Builder builder) {
        String string = slotType.getName();
        ValueType valueType = slotType.getSlotValue();
        switch (string) {
            case "DocumentMetadata": {
                if (!(valueType instanceof AnyValueType)) break;
                Node node = (Node)((AnyValueType)valueType).getAny();
                builder.dataset(DatasetPojo.builder((DCatAPDatasetType)new DatasetMarshaller().read(node)));
                break;
            }
            default: {
                throw new IllegalStateException("Found unsupported slot '" + string + "'");
            }
        }
    }

    @Nonnull
    public static Builder builder(@Nullable ExtrinsicObjectType extrinsicObjectType) {
        Builder builder = new Builder();
        if (extrinsicObjectType != null) {
            builder.registryObjectID(extrinsicObjectType.getId());
            for (SlotType slotType : extrinsicObjectType.getSlot()) {
                ResponseDocumentPojo._applySlots(slotType, builder);
            }
            builder.repositoryItemRef(extrinsicObjectType.getRepositoryItemRef());
        }
        return builder;
    }

    public static class Builder {
        private String m_sRegistryObjectID;
        private DatasetPojo m_aDataset;
        private RepositoryItemRefPojo m_aRepositoryItemRef;

        protected Builder() {
        }

        @Nonnull
        public Builder registryObjectID(@Nullable String string) {
            this.m_sRegistryObjectID = string;
            return this;
        }

        @Nonnull
        public Builder randomRegistryObjectID() {
            return this.registryObjectID(UUID.randomUUID().toString());
        }

        @Nonnull
        public Builder dataset(@Nullable DatasetPojo.Builder builder) {
            return this.dataset(builder == null ? null : builder.build());
        }

        @Nonnull
        public Builder dataset(@Nullable DatasetPojo datasetPojo) {
            this.m_aDataset = datasetPojo;
            return this;
        }

        @Nonnull
        public Builder dataset(@Nullable DCatAPDatasetType dCatAPDatasetType) {
            return this.dataset(dCatAPDatasetType == null ? null : DatasetPojo.builder(dCatAPDatasetType));
        }

        @Nonnull
        public Builder repositoryItemRef(@Nullable Consumer<? super RepositoryItemRefPojo.Builder> consumer) {
            if (consumer != null) {
                RepositoryItemRefPojo.Builder builder = RepositoryItemRefPojo.builder();
                consumer.accept(builder);
                this.repositoryItemRef(builder);
            }
            return this;
        }

        @Nonnull
        public Builder repositoryItemRef(@Nullable RepositoryItemRefPojo.Builder builder) {
            return this.repositoryItemRef(builder == null ? null : builder.build());
        }

        @Nonnull
        public Builder repositoryItemRef(@Nullable RepositoryItemRefPojo repositoryItemRefPojo) {
            this.m_aRepositoryItemRef = repositoryItemRefPojo;
            return this;
        }

        @Nonnull
        public Builder repositoryItemRef(@Nullable SimpleLinkType simpleLinkType) {
            return this.repositoryItemRef(simpleLinkType == null ? null : RepositoryItemRefPojo.builder(simpleLinkType));
        }

        public void checkConsistency() {
            if (StringHelper.hasNoText((String)this.m_sRegistryObjectID)) {
                throw new IllegalStateException("RegistryObjectID must be present");
            }
            if (this.m_aDataset == null) {
                throw new IllegalStateException("Dataset MUST be present");
            }
            if (this.m_aRepositoryItemRef == null) {
                throw new IllegalStateException("RepositoryItemRef MUST be present");
            }
        }

        @Nonnull
        public ResponseDocumentPojo build() {
            this.checkConsistency();
            return new ResponseDocumentPojo(this.m_sRegistryObjectID, this.m_aDataset, this.m_aRepositoryItemRef);
        }
    }
}

