/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.edm.response;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import eu.toop.edm.model.ConceptPojo;
import eu.toop.edm.response.IEDMResponsePayloadConcepts;
import eu.toop.edm.slot.SlotConceptValues;
import eu.toop.regrep.rim.ExtrinsicObjectType;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class EDMResponsePayloadConcepts
implements IEDMResponsePayloadConcepts {
    private final String m_sRegistryObjectID;
    private final ICommonsList<ConceptPojo> m_aConcepts = new CommonsArrayList();

    public EDMResponsePayloadConcepts(@Nonnull @Nonempty String string, @Nullable ICommonsList<ConceptPojo> iCommonsList) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"RegistryObjectID");
        ValueEnforcer.notEmpty(iCommonsList, (String)"Concepts");
        this.m_sRegistryObjectID = string;
        this.m_aConcepts.addAll(iCommonsList);
    }

    @Override
    @Nonnull
    @Nonempty
    public final String getRegistryObjectID() {
        return this.m_sRegistryObjectID;
    }

    @Override
    @Nonnull
    @ReturnsMutableObject
    public final List<ConceptPojo> concepts() {
        return this.m_aConcepts;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public final List<ConceptPojo> getAllConcepts() {
        return (List)this.m_aConcepts.getClone();
    }

    @Nonnull
    public ExtrinsicObjectType getAsRegistryObject() {
        ExtrinsicObjectType extrinsicObjectType = new ExtrinsicObjectType();
        extrinsicObjectType.setId(this.m_sRegistryObjectID);
        extrinsicObjectType.addSlot(new SlotConceptValues((Iterable<ConceptPojo>)this.m_aConcepts).createSlot());
        return extrinsicObjectType;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        EDMResponsePayloadConcepts eDMResponsePayloadConcepts = (EDMResponsePayloadConcepts)object;
        return EqualsHelper.equals((Object)this.m_sRegistryObjectID, (Object)eDMResponsePayloadConcepts.m_sRegistryObjectID) && EqualsHelper.equals(this.m_aConcepts, eDMResponsePayloadConcepts.m_aConcepts);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sRegistryObjectID).append(this.m_aConcepts).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("RegistryObjectID", (Object)this.m_sRegistryObjectID).append("Concepts", this.m_aConcepts).getToString();
    }
}

