/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.edm.request;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import eu.toop.edm.model.DistributionPojo;
import eu.toop.edm.request.IEDMRequestPayloadDistribution;
import eu.toop.edm.slot.SlotDistributionRequestList;
import eu.toop.regrep.slot.ISlotProvider;
import java.util.List;
import javax.annotation.Nonnull;

public class EDMRequestPayloadDistribution
implements IEDMRequestPayloadDistribution {
    private final ICommonsList<DistributionPojo> m_aDistributions = new CommonsArrayList();

    public EDMRequestPayloadDistribution(@Nonnull @Nonempty ICommonsList<DistributionPojo> iCommonsList) {
        ValueEnforcer.notEmpty(iCommonsList, (String)"Distributions");
        this.m_aDistributions.addAll(iCommonsList);
    }

    @Override
    @Nonnull
    @ReturnsMutableObject
    public final List<DistributionPojo> distributions() {
        return this.m_aDistributions;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public final List<DistributionPojo> getAllDistributions() {
        return (List)this.m_aDistributions.getClone();
    }

    @Override
    @Nonnull
    public ISlotProvider getAsSlotProvider() {
        return new SlotDistributionRequestList((Iterable<DistributionPojo>)this.m_aDistributions);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        EDMRequestPayloadDistribution eDMRequestPayloadDistribution = (EDMRequestPayloadDistribution)object;
        return EqualsHelper.equals(this.m_aDistributions, eDMRequestPayloadDistribution.m_aDistributions);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aDistributions).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Distributions", this.m_aDistributions).getToString();
    }
}

