/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.edm.model;

import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import eu.toop.regrep.rim.SimpleLinkType;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RepositoryItemRefPojo {
    private final String m_sTitle;
    private final String m_sLink;

    public RepositoryItemRefPojo(@Nullable String string, @Nullable String string2) {
        this.m_sTitle = string;
        this.m_sLink = string2;
    }

    @Nullable
    public final String getTitle() {
        return this.m_sTitle;
    }

    @Nullable
    public final String getLink() {
        return this.m_sLink;
    }

    @Nonnull
    public SimpleLinkType getAsSimpleLink() {
        SimpleLinkType simpleLinkType = new SimpleLinkType();
        if (this.m_sTitle != null) {
            simpleLinkType.setTitle(this.m_sTitle);
        }
        if (this.m_sLink != null) {
            simpleLinkType.setHref(this.m_sLink);
        }
        return simpleLinkType;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        RepositoryItemRefPojo repositoryItemRefPojo = (RepositoryItemRefPojo)object;
        return EqualsHelper.equals((Object)this.m_sTitle, (Object)repositoryItemRefPojo.m_sTitle) && EqualsHelper.equals((Object)this.m_sLink, (Object)repositoryItemRefPojo.m_sLink);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sTitle).append((Object)this.m_sLink).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Title", (Object)this.m_sTitle).append("Link", (Object)this.m_sLink).getToString();
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @Nonnull
    public static Builder builder(@Nullable SimpleLinkType simpleLinkType) {
        Builder builder = new Builder();
        if (simpleLinkType != null) {
            builder.title(simpleLinkType.getTitle()).link(simpleLinkType.getHref());
        }
        return builder;
    }

    public static class Builder {
        private String m_sTitle;
        private String m_sLink;

        @Nonnull
        public Builder title(@Nullable String string) {
            this.m_sTitle = string;
            return this;
        }

        @Nonnull
        public Builder link(@Nullable String string) {
            this.m_sLink = string;
            return this;
        }

        @Nonnull
        public RepositoryItemRefPojo build() {
            return new RepositoryItemRefPojo(this.m_sTitle, this.m_sLink);
        }
    }
}

