/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.edm.model;

import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.math.MathHelper;
import com.helger.commons.string.ToStringGenerator;
import eu.toop.edm.jaxb.cv.cbc.QuantityType;
import java.math.BigDecimal;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class QuantityPojo {
    private final BigDecimal m_aValue;
    private final String m_sUnitCode;

    public QuantityPojo(@Nullable BigDecimal bigDecimal, @Nullable String string) {
        this.m_aValue = bigDecimal;
        this.m_sUnitCode = string;
    }

    @Nullable
    public final BigDecimal getValue() {
        return this.m_aValue;
    }

    @Nullable
    public final String getUnitCode() {
        return this.m_sUnitCode;
    }

    @Nonnull
    public QuantityType getAsQuantity() {
        QuantityType quantityType = new QuantityType();
        quantityType.setValue(this.m_aValue);
        quantityType.setUnitCode(this.m_sUnitCode);
        return quantityType;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        QuantityPojo quantityPojo = (QuantityPojo)object;
        return EqualsHelper.equals((Object)this.m_aValue, (Object)quantityPojo.m_aValue) && EqualsHelper.equals((Object)this.m_sUnitCode, (Object)quantityPojo.m_sUnitCode);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aValue).append((Object)this.m_sUnitCode).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Value", (Object)this.m_aValue).append("UnitCode", (Object)this.m_sUnitCode).getToString();
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @Nonnull
    public static Builder builder(@Nullable QuantityType quantityType) {
        Builder builder = new Builder();
        if (quantityType != null) {
            builder.value(quantityType.getValue()).unitCode(quantityType.getUnitCode());
        }
        return builder;
    }

    public static class Builder {
        private BigDecimal m_aValue;
        private String m_sUnitCode;

        public Builder value(@Nonnull long l) {
            return this.value(MathHelper.toBigDecimal((long)l));
        }

        @Nonnull
        public Builder value(@Nonnull double d) {
            return this.value(MathHelper.toBigDecimal((double)d));
        }

        @Nonnull
        public Builder value(@Nullable BigDecimal bigDecimal) {
            this.m_aValue = bigDecimal;
            return this;
        }

        @Nonnull
        public Builder unitCode(@Nullable String string) {
            this.m_sUnitCode = string;
            return this;
        }

        @Nonnull
        public QuantityPojo build() {
            return new QuantityPojo(this.m_aValue, this.m_sUnitCode);
        }
    }
}

