/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.edm.model;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import eu.toop.edm.jaxb.cccev.CCCEVReferenceFrameworkType;
import eu.toop.edm.jaxb.dcatap.DCatAPDatasetType;
import eu.toop.edm.jaxb.dcatap.DCatAPRelationshipType;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class QualifiedRelationPojo {
    private final ICommonsList<String> m_aDescriptions = new CommonsArrayList();
    private final ICommonsList<String> m_aTitles = new CommonsArrayList();
    private final ICommonsList<String> m_aIDs = new CommonsArrayList();

    public QualifiedRelationPojo(@Nonnull @Nonempty ICommonsList<String> iCommonsList, @Nonnull @Nonempty ICommonsList<String> iCommonsList2, @Nullable ICommonsList<String> iCommonsList3) {
        ValueEnforcer.notEmptyNoNullValue(iCommonsList, (String)"Descriptions");
        ValueEnforcer.notEmptyNoNullValue(iCommonsList2, (String)"Titles");
        ValueEnforcer.noNullValue(iCommonsList3, (String)"IDs");
        this.m_aDescriptions.addAll(iCommonsList);
        this.m_aTitles.addAll(iCommonsList2);
        if (iCommonsList3 != null) {
            this.m_aIDs.addAll(iCommonsList3);
        }
    }

    @Nonnull
    @ReturnsMutableObject
    public final List<String> descriptions() {
        return this.m_aDescriptions;
    }

    @Nonnull
    @ReturnsMutableCopy
    public final List<String> getAllDescriptions() {
        return (List)this.m_aDescriptions.getClone();
    }

    @Nonnull
    @ReturnsMutableObject
    public final List<String> titles() {
        return this.m_aTitles;
    }

    @Nonnull
    @ReturnsMutableCopy
    public final List<String> getAllTitles() {
        return (List)this.m_aTitles.getClone();
    }

    @Nonnull
    @ReturnsMutableObject
    public final List<String> ids() {
        return this.m_aIDs;
    }

    @Nonnull
    @ReturnsMutableCopy
    public final List<String> getAllIDs() {
        return (List)this.m_aIDs.getClone();
    }

    @Nonnull
    public DCatAPRelationshipType getAsRelationship() {
        DCatAPRelationshipType dCatAPRelationshipType = new DCatAPRelationshipType();
        CCCEVReferenceFrameworkType cCCEVReferenceFrameworkType = new CCCEVReferenceFrameworkType();
        for (String string : this.m_aDescriptions) {
            cCCEVReferenceFrameworkType.addDescription(string);
        }
        for (String string : this.m_aTitles) {
            cCCEVReferenceFrameworkType.addTitle(string);
        }
        for (String string : this.m_aIDs) {
            cCCEVReferenceFrameworkType.addIdentifier(string);
        }
        dCatAPRelationshipType.addRelation(cCCEVReferenceFrameworkType);
        return dCatAPRelationshipType;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        QualifiedRelationPojo qualifiedRelationPojo = (QualifiedRelationPojo)object;
        return EqualsHelper.equals(this.m_aDescriptions, qualifiedRelationPojo.m_aDescriptions) && EqualsHelper.equals(this.m_aTitles, qualifiedRelationPojo.m_aTitles) && EqualsHelper.equals(this.m_aIDs, qualifiedRelationPojo.m_aIDs);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aDescriptions).append(this.m_aTitles).append(this.m_aIDs).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Descriptions", this.m_aDescriptions).append("Titles", this.m_aTitles).append("IDs", this.m_aIDs).getToString();
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @Nonnull
    public static Builder builder(@Nullable DCatAPRelationshipType dCatAPRelationshipType) {
        Object object;
        Builder builder = new Builder();
        if (dCatAPRelationshipType != null && dCatAPRelationshipType.hasRelationEntries() && (object = dCatAPRelationshipType.getRelationAtIndex(0)) instanceof DCatAPDatasetType) {
            DCatAPDatasetType dCatAPDatasetType = (DCatAPDatasetType)object;
            builder.descriptions(dCatAPDatasetType.getDescription()).titles(dCatAPDatasetType.getTitle()).ids(dCatAPDatasetType.getIdentifier());
        }
        return builder;
    }

    public static class Builder {
        private final ICommonsList<String> m_aDescriptions = new CommonsArrayList();
        private final ICommonsList<String> m_aTitles = new CommonsArrayList();
        private final ICommonsList<String> m_aIDs = new CommonsArrayList();

        @Nonnull
        public Builder addDescription(@Nullable String string) {
            if (StringHelper.hasText((String)string)) {
                this.m_aDescriptions.add((Object)string);
            }
            return this;
        }

        @Nonnull
        public Builder description(@Nullable String string) {
            if (StringHelper.hasText((String)string)) {
                this.m_aDescriptions.set((Object)string);
            } else {
                this.m_aDescriptions.clear();
            }
            return this;
        }

        @Nonnull
        public Builder descriptions(String ... stringArray) {
            this.m_aDescriptions.setAll((Object[])stringArray);
            return this;
        }

        @Nonnull
        public Builder descriptions(@Nullable Iterable<String> iterable) {
            this.m_aDescriptions.setAll(iterable);
            return this;
        }

        @Nonnull
        public Builder addTitle(@Nullable String string) {
            if (StringHelper.hasText((String)string)) {
                this.m_aTitles.add((Object)string);
            }
            return this;
        }

        @Nonnull
        public Builder title(@Nullable String string) {
            if (StringHelper.hasText((String)string)) {
                this.m_aTitles.set((Object)string);
            } else {
                this.m_aTitles.clear();
            }
            return this;
        }

        @Nonnull
        public Builder titles(String ... stringArray) {
            this.m_aTitles.setAll((Object[])stringArray);
            return this;
        }

        @Nonnull
        public Builder titles(@Nullable Iterable<String> iterable) {
            this.m_aTitles.setAll(iterable);
            return this;
        }

        @Nonnull
        public Builder addID(@Nullable String string) {
            if (StringHelper.hasText((String)string)) {
                this.m_aIDs.add((Object)string);
            }
            return this;
        }

        @Nonnull
        public Builder id(@Nullable String string) {
            if (StringHelper.hasText((String)string)) {
                this.m_aIDs.set((Object)string);
            } else {
                this.m_aIDs.clear();
            }
            return this;
        }

        @Nonnull
        public Builder ids(String ... stringArray) {
            this.m_aIDs.setAll((Object[])stringArray);
            return this;
        }

        @Nonnull
        public Builder ids(@Nullable Iterable<String> iterable) {
            this.m_aIDs.setAll(iterable);
            return this;
        }

        @Nonnull
        public QualifiedRelationPojo build() {
            return new QualifiedRelationPojo(this.m_aDescriptions, this.m_aTitles, this.m_aIDs);
        }
    }
}

