/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.edm.model;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.datetime.util.PDTXMLConverter;
import eu.toop.edm.jaxb.w3.cv.ac.CoreLocationType;
import eu.toop.edm.jaxb.w3.cv.ac.CorePersonType;
import eu.toop.edm.jaxb.w3.cv.bc.PersonBirthDateType;
import eu.toop.edm.jaxb.w3.cv.bc.PersonBirthNameType;
import eu.toop.edm.jaxb.w3.cv.bc.PersonFamilyNameType;
import eu.toop.edm.jaxb.w3.cv.bc.PersonGenderCodeType;
import eu.toop.edm.jaxb.w3.cv.bc.PersonGivenNameType;
import eu.toop.edm.jaxb.w3.cv.bc.PersonIDType;
import eu.toop.edm.model.AddressPojo;
import eu.toop.edm.model.EGenderCode;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.datatype.XMLGregorianCalendar;

public class PersonPojo {
    private final String m_sID;
    private final String m_sIDSchemeID;
    private final String m_sFamilyName;
    private final String m_sGivenName;
    private final String m_sGenderCode;
    private final String m_sBirthName;
    private final LocalDate m_aBirthDate;
    private final String m_sBirthTown;
    private final AddressPojo m_aAddress;

    public PersonPojo(@Nonnull String string, @Nonnull String string2, @Nonnull String string3, @Nonnull String string4, @Nullable String string5, @Nullable String string6, @Nonnull LocalDate localDate, @Nullable String string7, @Nullable AddressPojo addressPojo) {
        ValueEnforcer.notNull((Object)string, (String)"ID");
        ValueEnforcer.notNull((Object)string2, (String)"IDSchemeID");
        ValueEnforcer.notNull((Object)string3, (String)"FamilyName");
        ValueEnforcer.notNull((Object)string4, (String)"GivenName");
        ValueEnforcer.notNull((Object)localDate, (String)"BirthDate");
        this.m_sID = string;
        this.m_sIDSchemeID = string2;
        this.m_sFamilyName = string3;
        this.m_sGivenName = string4;
        this.m_sGenderCode = string5;
        this.m_sBirthName = string6;
        this.m_aBirthDate = localDate;
        this.m_sBirthTown = string7;
        this.m_aAddress = addressPojo;
    }

    @Nonnull
    public final String getID() {
        return this.m_sID;
    }

    @Nonnull
    public final String getIDSchemeID() {
        return this.m_sIDSchemeID;
    }

    @Nonnull
    public final String getFamilyName() {
        return this.m_sFamilyName;
    }

    @Nonnull
    public final String getGivenName() {
        return this.m_sGivenName;
    }

    @Nullable
    public final String getGenderCode() {
        return this.m_sGenderCode;
    }

    @Nullable
    public final String getBirthName() {
        return this.m_sBirthName;
    }

    @Nonnull
    public final LocalDate getBirthDate() {
        return this.m_aBirthDate;
    }

    @Nullable
    public final String getBirthTown() {
        return this.m_sBirthTown;
    }

    @Nullable
    public final AddressPojo getAddress() {
        return this.m_aAddress;
    }

    @Nonnull
    public CorePersonType getAsCorePerson() {
        Serializable serializable;
        CorePersonType corePersonType = new CorePersonType();
        if (StringHelper.hasText((String)this.m_sID)) {
            serializable = new PersonIDType();
            serializable.setValue(this.m_sID);
            serializable.setSchemeID(this.m_sIDSchemeID);
            corePersonType.addPersonID((PersonIDType)serializable);
        }
        if (StringHelper.hasText((String)this.m_sFamilyName)) {
            serializable = new PersonFamilyNameType();
            serializable.setValue(this.m_sFamilyName);
            corePersonType.addPersonFamilyName((PersonFamilyNameType)serializable);
        }
        if (StringHelper.hasText((String)this.m_sGivenName)) {
            serializable = new PersonGivenNameType();
            serializable.setValue(this.m_sGivenName);
            corePersonType.addPersonGivenName((PersonGivenNameType)serializable);
        }
        if (StringHelper.hasText((String)this.m_sGenderCode)) {
            serializable = new PersonGenderCodeType();
            serializable.setValue(this.m_sGenderCode);
            corePersonType.addPersonGenderCode((PersonGenderCodeType)serializable);
        }
        if (StringHelper.hasText((String)this.m_sBirthName)) {
            serializable = new PersonBirthNameType();
            serializable.setValue(this.m_sBirthName);
            corePersonType.addPersonBirthName((PersonBirthNameType)serializable);
        }
        if (this.m_aBirthDate != null) {
            serializable = new PersonBirthDateType();
            serializable.setValue(PDTXMLConverter.getXMLCalendarDate((LocalDate)this.m_aBirthDate));
            corePersonType.addPersonBirthDate((PersonBirthDateType)serializable);
        }
        if (StringHelper.hasText((String)this.m_sBirthTown)) {
            serializable = new CoreLocationType();
            ((CoreLocationType)serializable).addLocationCoreAddress(AddressPojo.builder().town(this.m_sBirthTown).build().getAsCoreAddress());
            corePersonType.addPersonPlaceOfBirthCoreLocation((CoreLocationType)serializable);
        }
        if (this.m_aAddress != null) {
            corePersonType.addPersonCoreAddress(this.m_aAddress.getAsCoreAddress());
        }
        return corePersonType;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        PersonPojo personPojo = (PersonPojo)object;
        return EqualsHelper.equals((Object)this.m_sID, (Object)personPojo.m_sID) && EqualsHelper.equals((Object)this.m_sIDSchemeID, (Object)personPojo.m_sIDSchemeID) && EqualsHelper.equals((Object)this.m_sFamilyName, (Object)personPojo.m_sFamilyName) && EqualsHelper.equals((Object)this.m_sGivenName, (Object)personPojo.m_sGivenName) && EqualsHelper.equals((Object)this.m_sGenderCode, (Object)personPojo.m_sGenderCode) && EqualsHelper.equals((Object)this.m_sBirthName, (Object)personPojo.m_sBirthName) && EqualsHelper.equals((Object)this.m_aBirthDate, (Object)personPojo.m_aBirthDate) && EqualsHelper.equals((Object)this.m_sBirthTown, (Object)personPojo.m_sBirthTown) && EqualsHelper.equals((Object)this.m_aAddress, (Object)personPojo.m_aAddress);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sID).append((Object)this.m_sIDSchemeID).append((Object)this.m_sFamilyName).append((Object)this.m_sGivenName).append((Object)this.m_sGenderCode).append((Object)this.m_sBirthName).append((Object)this.m_aBirthDate).append((Object)this.m_sBirthTown).append((Object)this.m_aAddress).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("ID", (Object)this.m_sID).append("IDSchemeID", (Object)this.m_sIDSchemeID).append("FamilyName", (Object)this.m_sFamilyName).append("GivenName", (Object)this.m_sGivenName).append("GenderCode", (Object)this.m_sGenderCode).append("BirthName", (Object)this.m_sBirthName).append("BirthDate", (Object)this.m_aBirthDate).append("BirthTown", (Object)this.m_sBirthTown).append("Address", (Object)this.m_aAddress).getToString();
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @Nonnull
    public static Builder builder(@Nullable CorePersonType corePersonType) {
        Builder builder = new Builder();
        if (corePersonType != null) {
            CoreLocationType coreLocationType;
            if (corePersonType.hasPersonIDEntries()) {
                builder.id(corePersonType.getPersonIDAtIndex(0).getValue()).idSchemeID(corePersonType.getPersonIDAtIndex(0).getSchemeID());
            }
            if (corePersonType.hasPersonFamilyNameEntries()) {
                builder.familyName(corePersonType.getPersonFamilyNameAtIndex(0).getValue());
            }
            if (corePersonType.hasPersonGivenNameEntries()) {
                builder.givenName(corePersonType.getPersonGivenNameAtIndex(0).getValue());
            }
            if (corePersonType.hasPersonGenderCodeEntries()) {
                builder.genderCode(corePersonType.getPersonGenderCodeAtIndex(0).getValue());
            }
            if (corePersonType.hasPersonBirthNameEntries()) {
                builder.birthName(corePersonType.getPersonBirthNameAtIndex(0).getValue());
            }
            if (corePersonType.hasPersonBirthDateEntries()) {
                builder.birthDate(corePersonType.getPersonBirthDateAtIndex(0).getValue());
            }
            if (corePersonType.hasPersonPlaceOfBirthCoreLocationEntries() && (coreLocationType = corePersonType.getPersonPlaceOfBirthCoreLocationAtIndex(0)).hasLocationCoreAddressEntries()) {
                builder.birthTown(AddressPojo.builder(coreLocationType.getLocationCoreAddressAtIndex(0)).build().getTown());
            }
            if (corePersonType.hasPersonCoreAddressEntries()) {
                builder.address(AddressPojo.builder(corePersonType.getPersonCoreAddressAtIndex(0)));
            }
        }
        return builder;
    }

    public static class Builder {
        private String m_sID;
        private String m_sIDSchemeID;
        private String m_sFamilyName;
        private String m_sGivenName;
        private String m_sGenderCode;
        private String m_sBirthName;
        private LocalDate m_aBirthDate;
        private String m_sBirthTown;
        private AddressPojo m_aAddress;

        @Nonnull
        public Builder id(@Nullable String string) {
            this.m_sID = string;
            return this;
        }

        @Nonnull
        public Builder idSchemeID(@Nullable String string) {
            this.m_sIDSchemeID = string;
            return this;
        }

        @Nonnull
        public Builder familyName(@Nullable String string) {
            this.m_sFamilyName = string;
            return this;
        }

        @Nonnull
        public Builder givenName(@Nullable String string) {
            this.m_sGivenName = string;
            return this;
        }

        @Nonnull
        public Builder genderCode(@Nullable EGenderCode eGenderCode) {
            return this.genderCode(eGenderCode == null ? null : eGenderCode.getID());
        }

        @Nonnull
        public Builder genderCode(@Nullable String string) {
            this.m_sGenderCode = string;
            return this;
        }

        @Nonnull
        public Builder birthName(@Nullable String string) {
            this.m_sBirthName = string;
            return this;
        }

        @Nonnull
        public Builder birthDate(@Nullable XMLGregorianCalendar xMLGregorianCalendar) {
            return this.birthDate(PDTXMLConverter.getLocalDate((XMLGregorianCalendar)xMLGregorianCalendar));
        }

        @Nonnull
        public Builder birthDate(@Nullable LocalDate localDate) {
            this.m_aBirthDate = localDate;
            return this;
        }

        @Nonnull
        public Builder birthTown(@Nullable String string) {
            this.m_sBirthTown = string;
            return this;
        }

        @Nonnull
        public Builder address(@Nullable Consumer<? super AddressPojo.Builder> consumer) {
            if (consumer != null) {
                AddressPojo.Builder builder = AddressPojo.builder();
                consumer.accept(builder);
                this.address(builder);
            }
            return this;
        }

        @Nonnull
        public Builder address(@Nullable AddressPojo.Builder builder) {
            return this.address(builder == null ? null : builder.build());
        }

        @Nonnull
        public Builder address(@Nullable AddressPojo addressPojo) {
            this.m_aAddress = addressPojo;
            return this;
        }

        public void checkConsistency() {
            if (StringHelper.hasNoText((String)this.m_sID)) {
                throw new IllegalStateException("ID must be present");
            }
            if (StringHelper.hasNoText((String)this.m_sIDSchemeID)) {
                throw new IllegalStateException("ID SchemeID must be present");
            }
            if (StringHelper.hasNoText((String)this.m_sFamilyName)) {
                throw new IllegalStateException("Family Name must be present");
            }
            if (StringHelper.hasNoText((String)this.m_sGivenName)) {
                throw new IllegalStateException("Given Name must be present");
            }
            if (this.m_aBirthDate == null) {
                throw new IllegalStateException("Birth Date must be present");
            }
        }

        @Nonnull
        public PersonPojo build() {
            this.checkConsistency();
            return new PersonPojo(this.m_sID, this.m_sIDSchemeID, this.m_sFamilyName, this.m_sGivenName, this.m_sGenderCode, this.m_sBirthName, this.m_aBirthDate, this.m_sBirthTown, this.m_aAddress);
        }
    }
}

