/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.edm.model;

import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.datetime.util.PDTXMLConverter;
import eu.toop.edm.jaxb.cv.cac.PeriodType;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.datatype.XMLGregorianCalendar;

public class PeriodPojo {
    private final LocalDate m_aStartDate;
    private final LocalTime m_aStartTime;
    private final LocalDate m_aEndDate;
    private final LocalTime m_aEndTime;

    public PeriodPojo(@Nullable LocalDate localDate, @Nullable LocalTime localTime, @Nullable LocalDate localDate2, @Nullable LocalTime localTime2) {
        this.m_aStartDate = localDate;
        this.m_aStartTime = localTime;
        this.m_aEndDate = localDate2;
        this.m_aEndTime = localTime2;
    }

    @Nullable
    public final LocalDate getStartDate() {
        return this.m_aStartDate;
    }

    @Nullable
    public final LocalTime getStartTime() {
        return this.m_aStartTime;
    }

    @Nullable
    public final LocalDate getEndDate() {
        return this.m_aEndDate;
    }

    @Nullable
    public final LocalTime getEndTime() {
        return this.m_aEndTime;
    }

    @Nonnull
    public PeriodType getAsPeriod() {
        PeriodType periodType = new PeriodType();
        if (this.m_aStartDate != null) {
            periodType.setStartDate(PDTXMLConverter.getXMLCalendarDate((LocalDate)this.m_aStartDate));
        }
        if (this.m_aStartTime != null) {
            periodType.setStartTime(PDTXMLConverter.getXMLCalendarTime((LocalTime)this.m_aStartTime));
        }
        if (this.m_aEndDate != null) {
            periodType.setEndDate(PDTXMLConverter.getXMLCalendarDate((LocalDate)this.m_aEndDate));
        }
        if (this.m_aEndTime != null) {
            periodType.setEndTime(PDTXMLConverter.getXMLCalendarTime((LocalTime)this.m_aEndTime));
        }
        return periodType;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        PeriodPojo periodPojo = (PeriodPojo)object;
        return EqualsHelper.equals((Object)this.m_aStartDate, (Object)periodPojo.m_aStartDate) && EqualsHelper.equals((Object)this.m_aStartTime, (Object)periodPojo.m_aStartTime) && EqualsHelper.equals((Object)this.m_aEndDate, (Object)periodPojo.m_aEndDate) && EqualsHelper.equals((Object)this.m_aEndTime, (Object)periodPojo.m_aEndTime);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aStartDate).append((Object)this.m_aStartTime).append((Object)this.m_aEndDate).append((Object)this.m_aEndTime).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("StartDate", (Object)this.m_aStartDate).append("StartTime", (Object)this.m_aStartDate).append("EndDate", (Object)this.m_aEndDate).append("EndTime", (Object)this.m_aEndTime).getToString();
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @Nonnull
    public static Builder builder(@Nullable PeriodType periodType) {
        Builder builder = new Builder();
        if (periodType != null) {
            builder.startDate(periodType.getStartDateValue()).startTime(periodType.getStartTimeValue()).endDate(periodType.getEndDateValue()).endTime(periodType.getEndTimeValue());
        }
        return builder;
    }

    public static class Builder {
        private LocalDate m_aStartDate;
        private LocalTime m_aStartTime;
        private LocalDate m_aEndDate;
        private LocalTime m_aEndTime;

        @Nonnull
        public Builder startDateTime(@Nullable XMLGregorianCalendar xMLGregorianCalendar) {
            return this.startDateTime(PDTXMLConverter.getLocalDateTime((XMLGregorianCalendar)xMLGregorianCalendar));
        }

        @Nonnull
        public Builder startDateTime(@Nullable LocalDateTime localDateTime) {
            return this.startDate(localDateTime == null ? null : localDateTime.toLocalDate()).startTime(localDateTime == null ? null : localDateTime.toLocalTime());
        }

        @Nonnull
        public Builder startDate(@Nullable XMLGregorianCalendar xMLGregorianCalendar) {
            return this.startDate(PDTXMLConverter.getLocalDate((XMLGregorianCalendar)xMLGregorianCalendar));
        }

        @Nonnull
        public Builder startDate(@Nullable LocalDate localDate) {
            this.m_aStartDate = localDate;
            return this;
        }

        @Nonnull
        public Builder startTime(@Nullable XMLGregorianCalendar xMLGregorianCalendar) {
            return this.startTime(PDTXMLConverter.getLocalTime((XMLGregorianCalendar)xMLGregorianCalendar));
        }

        @Nonnull
        public Builder startTime(@Nullable LocalTime localTime) {
            this.m_aStartTime = localTime == null ? null : localTime.truncatedTo(ChronoUnit.MILLIS);
            return this;
        }

        @Nonnull
        public Builder endDateTime(@Nullable XMLGregorianCalendar xMLGregorianCalendar) {
            return this.endDateTime(PDTXMLConverter.getLocalDateTime((XMLGregorianCalendar)xMLGregorianCalendar));
        }

        @Nonnull
        public Builder endDateTime(@Nullable LocalDateTime localDateTime) {
            return this.endDate(localDateTime == null ? null : localDateTime.toLocalDate()).endTime(localDateTime == null ? null : localDateTime.toLocalTime());
        }

        @Nonnull
        public Builder endDate(@Nullable XMLGregorianCalendar xMLGregorianCalendar) {
            return this.endDate(PDTXMLConverter.getLocalDate((XMLGregorianCalendar)xMLGregorianCalendar));
        }

        @Nonnull
        public Builder endDate(@Nullable LocalDate localDate) {
            this.m_aEndDate = localDate;
            return this;
        }

        @Nonnull
        public Builder endTime(@Nullable XMLGregorianCalendar xMLGregorianCalendar) {
            return this.endTime(PDTXMLConverter.getLocalTime((XMLGregorianCalendar)xMLGregorianCalendar));
        }

        @Nonnull
        public Builder endTime(@Nullable LocalTime localTime) {
            this.m_aEndTime = localTime == null ? null : localTime.truncatedTo(ChronoUnit.MILLIS);
            return this;
        }

        @Nonnull
        public PeriodPojo build() {
            return new PeriodPojo(this.m_aStartDate, this.m_aStartTime, this.m_aEndDate, this.m_aEndTime);
        }
    }
}

