/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.edm.model;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.xsds.ccts.cct.schemamodule.TextType;
import eu.toop.edm.jaxb.cccev.CCCEVDocumentReferenceType;
import eu.toop.edm.jaxb.cv.cbc.DescriptionType;
import eu.toop.edm.jaxb.cv.cbc.IDType;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DocumentReferencePojo {
    private final String m_sDocumentURI;
    private final ICommonsList<String> m_aDocumentDescriptions = new CommonsArrayList();
    private final String m_sDocumentType;
    private final String m_sLocaleCode;

    public DocumentReferencePojo(@Nonnull String string, @Nullable List<String> list, @Nullable String string2, @Nullable String string3) {
        ValueEnforcer.notNull((Object)string, (String)"DocumentURI");
        this.m_sDocumentURI = string;
        this.m_aDocumentDescriptions.addAll(list);
        this.m_sDocumentType = string2;
        this.m_sLocaleCode = string3;
    }

    @Nullable
    public final String getDocumentURI() {
        return this.m_sDocumentURI;
    }

    @Nonnull
    @ReturnsMutableObject
    public final List<String> documentDescriptions() {
        return this.m_aDocumentDescriptions;
    }

    @Nonnull
    @ReturnsMutableCopy
    public final List<String> getAllDocumentDescriptions() {
        return (List)this.m_aDocumentDescriptions.getClone();
    }

    @Nullable
    public final String getDocumentType() {
        return this.m_sDocumentType;
    }

    @Nullable
    public final String getLocaleCode() {
        return this.m_sLocaleCode;
    }

    @Nonnull
    public CCCEVDocumentReferenceType getAsDocumentReference() {
        CCCEVDocumentReferenceType cCCEVDocumentReferenceType = new CCCEVDocumentReferenceType();
        cCCEVDocumentReferenceType.setAccessURL("");
        if (StringHelper.hasText((String)this.m_sDocumentURI)) {
            cCCEVDocumentReferenceType.addDocumentURI(new IDType(this.m_sDocumentURI));
        }
        for (String string : this.m_aDocumentDescriptions) {
            cCCEVDocumentReferenceType.addDocumentDescription(new DescriptionType(string));
        }
        if (StringHelper.hasText((String)this.m_sDocumentType)) {
            cCCEVDocumentReferenceType.setDocumentType(this.m_sDocumentType);
        }
        if (StringHelper.hasText((String)this.m_sLocaleCode)) {
            cCCEVDocumentReferenceType.setLocaleCode(this.m_sLocaleCode);
        }
        return cCCEVDocumentReferenceType;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        DocumentReferencePojo documentReferencePojo = (DocumentReferencePojo)object;
        return EqualsHelper.equals((Object)this.m_sDocumentURI, (Object)documentReferencePojo.m_sDocumentURI) && EqualsHelper.equals(this.m_aDocumentDescriptions, documentReferencePojo.m_aDocumentDescriptions) && EqualsHelper.equals((Object)this.m_sDocumentType, (Object)documentReferencePojo.m_sDocumentType) && EqualsHelper.equals((Object)this.m_sLocaleCode, (Object)documentReferencePojo.m_sLocaleCode);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sDocumentURI).append(this.m_aDocumentDescriptions).append((Object)this.m_sDocumentType).append((Object)this.m_sLocaleCode).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("DocumentURI", (Object)this.m_sDocumentURI).append("DocumentDescriptions", this.m_aDocumentDescriptions).append("DocumentType", (Object)this.m_sDocumentType).append("LocaleCode", (Object)this.m_sLocaleCode).getToString();
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @Nonnull
    public static Builder builder(@Nullable CCCEVDocumentReferenceType cCCEVDocumentReferenceType) {
        Builder builder = new Builder();
        if (cCCEVDocumentReferenceType != null) {
            if (cCCEVDocumentReferenceType.hasDocumentURIEntries()) {
                builder.documentURI(cCCEVDocumentReferenceType.getDocumentURIAtIndex(0).getValue());
            }
            builder.documentDescriptions((Iterable<String>)new CommonsArrayList(cCCEVDocumentReferenceType.getDocumentDescription(), TextType::getValue)).documentType(cCCEVDocumentReferenceType.getDocumentTypeValue()).localeCode(cCCEVDocumentReferenceType.getLocaleCodeValue());
        }
        return builder;
    }

    public static class Builder {
        private String m_sDocumentURI;
        private final ICommonsList<String> m_aDocumentDescriptions = new CommonsArrayList();
        private String m_sDocumentType;
        private String m_sLocaleCode;

        @Nonnull
        public Builder documentURI(@Nullable String string) {
            this.m_sDocumentURI = string;
            return this;
        }

        @Nonnull
        public Builder addDocumentDescription(@Nullable String string) {
            if (StringHelper.hasText((String)string)) {
                this.m_aDocumentDescriptions.add((Object)string);
            }
            return this;
        }

        @Nonnull
        public Builder documentDescription(@Nullable String string) {
            if (StringHelper.hasText((String)string)) {
                this.m_aDocumentDescriptions.set((Object)string);
            } else {
                this.m_aDocumentDescriptions.clear();
            }
            return this;
        }

        @Nonnull
        public Builder documentDescriptions(String ... stringArray) {
            this.m_aDocumentDescriptions.setAll((Object[])stringArray);
            return this;
        }

        @Nonnull
        public Builder documentDescriptions(@Nullable Iterable<String> iterable) {
            this.m_aDocumentDescriptions.setAll(iterable);
            return this;
        }

        @Nonnull
        public Builder documentType(@Nullable String string) {
            this.m_sDocumentType = string;
            return this;
        }

        @Nonnull
        public Builder localeCode(@Nullable String string) {
            this.m_sLocaleCode = string;
            return this;
        }

        @Nonnull
        public DocumentReferencePojo build() {
            return new DocumentReferencePojo(this.m_sDocumentURI, (List<String>)this.m_aDocumentDescriptions, this.m_sDocumentType, this.m_sLocaleCode);
        }
    }
}

