/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.edm.model;

import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.mime.IMimeType;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.typeconvert.TypeConverter;
import eu.toop.edm.jaxb.dcatap.DCatAPDistributionType;
import eu.toop.edm.jaxb.dcterms.DCMediaType;
import eu.toop.edm.model.EDistributionFormat;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DistributionPojo {
    private final EDistributionFormat m_eFormat;
    private final String m_sMediaType;

    public DistributionPojo(@Nullable EDistributionFormat eDistributionFormat, @Nullable String string) {
        this.m_eFormat = eDistributionFormat;
        this.m_sMediaType = string;
    }

    @Nullable
    public final EDistributionFormat getFormat() {
        return this.m_eFormat;
    }

    @Nullable
    public final String getMediaType() {
        return this.m_sMediaType;
    }

    @Nonnull
    public DCatAPDistributionType getAsDistribution() {
        DCMediaType dCMediaType;
        DCatAPDistributionType dCatAPDistributionType = new DCatAPDistributionType();
        dCatAPDistributionType.setAccessURL("");
        if (this.m_eFormat != null) {
            dCMediaType = new DCMediaType();
            dCMediaType.addContent(this.m_eFormat.getID());
            dCatAPDistributionType.setFormat(dCMediaType);
        }
        if (StringHelper.hasText((String)this.m_sMediaType)) {
            dCMediaType = new DCMediaType();
            dCMediaType.addContent(this.m_sMediaType);
            dCatAPDistributionType.setMediaType(dCMediaType);
        }
        return dCatAPDistributionType;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        DistributionPojo distributionPojo = (DistributionPojo)object;
        return EqualsHelper.equals((Object)((Object)this.m_eFormat), (Object)((Object)distributionPojo.m_eFormat)) && EqualsHelper.equals((Object)this.m_sMediaType, (Object)distributionPojo.m_sMediaType);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Enum)this.m_eFormat).append((Object)this.m_sMediaType).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Format", (Enum)this.m_eFormat).append("MediaType", (Object)this.m_sMediaType).getToString();
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @Nonnull
    public static Builder builder(@Nullable DCatAPDistributionType dCatAPDistributionType) {
        Builder builder = new Builder();
        if (dCatAPDistributionType != null) {
            if (dCatAPDistributionType.getFormat() != null) {
                builder.format(EDistributionFormat.getFromIDOrNull((String)TypeConverter.convert((Object)dCatAPDistributionType.getFormat().getContentAtIndex(0), String.class)));
            }
            if (dCatAPDistributionType.getMediaType() != null) {
                builder.mediaType((String)TypeConverter.convert((Object)dCatAPDistributionType.getMediaType().getContentAtIndex(0), String.class));
            }
        }
        return builder;
    }

    public static class Builder {
        private EDistributionFormat m_eFormat;
        private String m_sMediaType;

        @Nonnull
        public Builder format(@Nullable EDistributionFormat eDistributionFormat) {
            this.m_eFormat = eDistributionFormat;
            return this;
        }

        @Nonnull
        public Builder mediaType(@Nullable IMimeType iMimeType) {
            return this.mediaType(iMimeType == null ? null : iMimeType.getAsString());
        }

        @Nonnull
        public Builder mediaType(@Nullable String string) {
            this.m_sMediaType = string;
            return this;
        }

        @Nonnull
        public DistributionPojo build() {
            return new DistributionPojo(this.m_eFormat, this.m_sMediaType);
        }
    }
}

