/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.edm.model;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.datetime.PDTFactory;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.datetime.util.PDTXMLConverter;
import eu.toop.edm.jaxb.cccev.CCCEVDocumentReferenceType;
import eu.toop.edm.jaxb.cv.agent.AgentType;
import eu.toop.edm.jaxb.dcatap.DCatAPDatasetType;
import eu.toop.edm.jaxb.dcatap.DCatAPRelationshipType;
import eu.toop.edm.jaxb.dcterms.DCPeriodOfTimeType;
import eu.toop.edm.model.AgentPojo;
import eu.toop.edm.model.DocumentReferencePojo;
import eu.toop.edm.model.QualifiedRelationPojo;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.datatype.XMLGregorianCalendar;

public class DatasetPojo {
    private final ICommonsList<String> m_aDescriptions = new CommonsArrayList();
    private final ICommonsList<String> m_aTitles = new CommonsArrayList();
    private final DocumentReferencePojo m_aDistribution;
    private final AgentPojo m_aCreator;
    private final ICommonsList<String> m_aIDs = new CommonsArrayList();
    private final LocalDateTime m_aIssuedDT;
    private final String m_sLanguage;
    private final LocalDateTime m_aLastModifiedDT;
    private final LocalDate m_aValidFrom;
    private final LocalDate m_aValidTo;
    private final ICommonsList<QualifiedRelationPojo> m_aQualifiedRelations = new CommonsArrayList();

    public DatasetPojo(@Nonnull @Nonempty ICommonsList<String> iCommonsList, @Nonnull @Nonempty ICommonsList<String> iCommonsList2, @Nullable DocumentReferencePojo documentReferencePojo, @Nullable AgentPojo agentPojo, @Nullable ICommonsList<String> iCommonsList3, @Nullable LocalDateTime localDateTime, @Nullable String string, @Nullable LocalDateTime localDateTime2, @Nullable LocalDate localDate, @Nullable LocalDate localDate2, @Nullable ICommonsList<QualifiedRelationPojo> iCommonsList4) {
        ValueEnforcer.notEmptyNoNullValue(iCommonsList, (String)"Descriptions");
        ValueEnforcer.notEmptyNoNullValue(iCommonsList2, (String)"Titles");
        ValueEnforcer.noNullValue(iCommonsList3, (String)"IDs");
        ValueEnforcer.noNullValue(iCommonsList4, (String)"QualifiedRelations");
        this.m_aDescriptions.addAll(iCommonsList);
        this.m_aTitles.addAll(iCommonsList2);
        this.m_aDistribution = documentReferencePojo;
        this.m_aCreator = agentPojo;
        if (iCommonsList3 != null) {
            this.m_aIDs.addAll(iCommonsList3);
        }
        this.m_aIssuedDT = localDateTime;
        this.m_sLanguage = string;
        this.m_aLastModifiedDT = localDateTime2;
        this.m_aValidFrom = localDate;
        this.m_aValidTo = localDate2;
        if (iCommonsList4 != null) {
            this.m_aQualifiedRelations.addAll(iCommonsList4);
        }
    }

    @Nonnull
    @ReturnsMutableObject
    public final List<String> descriptions() {
        return this.m_aDescriptions;
    }

    @Nonnull
    @ReturnsMutableCopy
    public final List<String> getAllDescriptions() {
        return (List)this.m_aDescriptions.getClone();
    }

    @Nonnull
    @ReturnsMutableObject
    public final List<String> titles() {
        return this.m_aTitles;
    }

    @Nonnull
    @ReturnsMutableCopy
    public final List<String> getAllTitles() {
        return (List)this.m_aTitles.getClone();
    }

    @Nullable
    public final DocumentReferencePojo getDistribution() {
        return this.m_aDistribution;
    }

    @Nullable
    public final AgentPojo getCreator() {
        return this.m_aCreator;
    }

    @Nonnull
    @ReturnsMutableObject
    public final List<String> ids() {
        return this.m_aIDs;
    }

    @Nonnull
    @ReturnsMutableCopy
    public final List<String> getAllIDs() {
        return this.m_aIDs;
    }

    @Nullable
    public final LocalDateTime getIssuedDT() {
        return this.m_aIssuedDT;
    }

    @Nullable
    public final String getLanguage() {
        return this.m_sLanguage;
    }

    @Nullable
    public final LocalDateTime getLastModifiedDT() {
        return this.m_aLastModifiedDT;
    }

    @Nullable
    public final LocalDate getValidFrom() {
        return this.m_aValidFrom;
    }

    @Nullable
    public final LocalDate getValidTo() {
        return this.m_aValidTo;
    }

    @Nonnull
    @ReturnsMutableObject
    public final List<QualifiedRelationPojo> qualifiedRelations() {
        return this.m_aQualifiedRelations;
    }

    @Nonnull
    @ReturnsMutableCopy
    public final List<QualifiedRelationPojo> getAllQualifiedRelations() {
        return (List)this.m_aQualifiedRelations.getClone();
    }

    @Nonnull
    public DCatAPDatasetType getAsDataset() {
        DCatAPDatasetType dCatAPDatasetType = new DCatAPDatasetType();
        for (Object object : this.m_aDescriptions) {
            dCatAPDatasetType.addDescription((String)object);
        }
        for (Object object : this.m_aTitles) {
            dCatAPDatasetType.addTitle((String)object);
        }
        if (this.m_aDistribution != null) {
            dCatAPDatasetType.addDistribution(this.m_aDistribution.getAsDocumentReference());
        }
        if (this.m_aCreator != null) {
            dCatAPDatasetType.setCreator(this.m_aCreator.getAsAgent());
        }
        for (Object object : this.m_aIDs) {
            dCatAPDatasetType.addIdentifier((String)object);
        }
        if (this.m_aIssuedDT != null) {
            dCatAPDatasetType.setIssued(PDTXMLConverter.getXMLCalendar((LocalDateTime)this.m_aIssuedDT));
        }
        if (StringHelper.hasText((String)this.m_sLanguage)) {
            dCatAPDatasetType.addLanguage(this.m_sLanguage);
        }
        if (this.m_aLastModifiedDT != null) {
            dCatAPDatasetType.setModified(PDTXMLConverter.getXMLCalendar((LocalDateTime)this.m_aLastModifiedDT));
        }
        if (this.m_aValidFrom != null || this.m_aValidTo != null) {
            DCPeriodOfTimeType dCPeriodOfTimeType = new DCPeriodOfTimeType();
            if (this.m_aValidFrom != null) {
                dCPeriodOfTimeType.addStartDate(PDTXMLConverter.getXMLCalendarDate((LocalDate)this.m_aValidFrom));
            }
            if (this.m_aValidTo != null) {
                dCPeriodOfTimeType.addEndDate(PDTXMLConverter.getXMLCalendarDate((LocalDate)this.m_aValidTo));
            }
            dCatAPDatasetType.addTemporal(dCPeriodOfTimeType);
        }
        for (Object object : this.m_aQualifiedRelations) {
            dCatAPDatasetType.addQualifiedRelation(((QualifiedRelationPojo)object).getAsRelationship());
        }
        return dCatAPDatasetType;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        DatasetPojo datasetPojo = (DatasetPojo)object;
        return EqualsHelper.equals(this.m_aDescriptions, datasetPojo.m_aDescriptions) && EqualsHelper.equals(this.m_aTitles, datasetPojo.m_aTitles) && EqualsHelper.equals((Object)this.m_aDistribution, (Object)datasetPojo.m_aDistribution) && EqualsHelper.equals((Object)this.m_aCreator, (Object)datasetPojo.m_aCreator) && EqualsHelper.equals(this.m_aIDs, datasetPojo.m_aIDs) && EqualsHelper.equals((Object)this.m_aIssuedDT, (Object)datasetPojo.m_aIssuedDT) && EqualsHelper.equals((Object)this.m_sLanguage, (Object)datasetPojo.m_sLanguage) && EqualsHelper.equals((Object)this.m_aLastModifiedDT, (Object)datasetPojo.m_aLastModifiedDT) && EqualsHelper.equals((Object)this.m_aValidFrom, (Object)datasetPojo.m_aValidFrom) && EqualsHelper.equals((Object)this.m_aValidTo, (Object)datasetPojo.m_aValidTo) && EqualsHelper.equals(this.m_aQualifiedRelations, datasetPojo.m_aQualifiedRelations);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aDescriptions).append(this.m_aTitles).append((Object)this.m_aDistribution).append((Object)this.m_aCreator).append(this.m_aIDs).append((Object)this.m_aIssuedDT).append((Object)this.m_sLanguage).append((Object)this.m_aLastModifiedDT).append((Object)this.m_aValidFrom).append((Object)this.m_aValidTo).append(this.m_aQualifiedRelations).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Descriptions", this.m_aDescriptions).append("Titles", this.m_aTitles).append("Distribution", (Object)this.m_aDistribution).append("Creator", (Object)this.m_aCreator).append("IDs", this.m_aIDs).append("IssuedDT", (Object)this.m_aIssuedDT).append("Language", (Object)this.m_sLanguage).append("LastModifiedDT", (Object)this.m_aLastModifiedDT).append("ValidFrom", (Object)this.m_aValidFrom).append("ValidTo", (Object)this.m_aValidTo).append("QualifiedRelations", this.m_aQualifiedRelations).getToString();
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @Nonnull
    public static Builder builder(@Nullable DCatAPDatasetType dCatAPDatasetType) {
        Builder builder = new Builder();
        if (dCatAPDatasetType != null) {
            Object object;
            builder.descriptions(dCatAPDatasetType.getDescription()).titles(dCatAPDatasetType.getTitle());
            if (dCatAPDatasetType.hasDistributionEntries() && (object = dCatAPDatasetType.getDistributionAtIndex(0)) instanceof CCCEVDocumentReferenceType) {
                builder.distribution(DocumentReferencePojo.builder((CCCEVDocumentReferenceType)object));
            }
            if (dCatAPDatasetType.getCreator() instanceof AgentType) {
                builder.creator(AgentPojo.builder((AgentType)dCatAPDatasetType.getCreator()));
            }
            builder.ids(dCatAPDatasetType.getIdentifier()).issued(dCatAPDatasetType.getIssued());
            if (dCatAPDatasetType.hasLanguageEntries()) {
                builder.language(dCatAPDatasetType.getLanguageAtIndex(0));
            }
            builder.lastModified(dCatAPDatasetType.getModified());
            if (dCatAPDatasetType.hasTemporalEntries()) {
                object = dCatAPDatasetType.getTemporalAtIndex(0);
                if (((DCPeriodOfTimeType)object).hasStartDateEntries()) {
                    builder.validFrom(((DCPeriodOfTimeType)object).getStartDateAtIndex(0));
                }
                if (((DCPeriodOfTimeType)object).hasEndDateEntries()) {
                    builder.validTo(((DCPeriodOfTimeType)object).getEndDateAtIndex(0));
                }
            }
            for (DCatAPRelationshipType dCatAPRelationshipType : dCatAPDatasetType.getQualifiedRelation()) {
                builder.addQualifiedRelation(QualifiedRelationPojo.builder(dCatAPRelationshipType));
            }
        }
        return builder;
    }

    public static class Builder {
        private final ICommonsList<String> m_aDescriptions = new CommonsArrayList();
        private final ICommonsList<String> m_aTitles = new CommonsArrayList();
        private DocumentReferencePojo m_aDistribution;
        private AgentPojo m_aCreator;
        private final ICommonsList<String> m_aIDs = new CommonsArrayList();
        private LocalDateTime m_aIssuedDT;
        private String m_sLanguage;
        private LocalDateTime m_aLastModifiedDT;
        private LocalDate m_aValidFrom;
        private LocalDate m_aValidTo;
        private final ICommonsList<QualifiedRelationPojo> m_aQualifiedRelations = new CommonsArrayList();

        @Nonnull
        public Builder addDescription(@Nullable String string) {
            if (StringHelper.hasText((String)string)) {
                this.m_aDescriptions.add((Object)string);
            }
            return this;
        }

        @Nonnull
        public Builder description(@Nullable String string) {
            if (StringHelper.hasText((String)string)) {
                this.m_aDescriptions.set((Object)string);
            } else {
                this.m_aDescriptions.clear();
            }
            return this;
        }

        @Nonnull
        public Builder descriptions(String ... stringArray) {
            this.m_aDescriptions.setAll((Object[])stringArray);
            return this;
        }

        @Nonnull
        public Builder descriptions(@Nullable Iterable<String> iterable) {
            this.m_aDescriptions.setAll(iterable);
            return this;
        }

        @Nonnull
        public Builder addTitle(@Nullable String string) {
            if (StringHelper.hasText((String)string)) {
                this.m_aTitles.add((Object)string);
            }
            return this;
        }

        @Nonnull
        public Builder title(@Nullable String string) {
            if (StringHelper.hasText((String)string)) {
                this.m_aTitles.set((Object)string);
            } else {
                this.m_aTitles.clear();
            }
            return this;
        }

        @Nonnull
        public Builder titles(String ... stringArray) {
            this.m_aTitles.setAll((Object[])stringArray);
            return this;
        }

        @Nonnull
        public Builder titles(@Nullable Iterable<String> iterable) {
            this.m_aTitles.setAll(iterable);
            return this;
        }

        @Nonnull
        public Builder distribution(@Nullable Consumer<? super DocumentReferencePojo.Builder> consumer) {
            if (consumer != null) {
                DocumentReferencePojo.Builder builder = DocumentReferencePojo.builder();
                consumer.accept(builder);
                this.distribution(builder);
            }
            return this;
        }

        @Nonnull
        public Builder distribution(@Nullable DocumentReferencePojo.Builder builder) {
            return this.distribution(builder == null ? null : builder.build());
        }

        @Nonnull
        public Builder distribution(@Nullable DocumentReferencePojo documentReferencePojo) {
            this.m_aDistribution = documentReferencePojo;
            return this;
        }

        @Nonnull
        public Builder distribution(@Nullable CCCEVDocumentReferenceType cCCEVDocumentReferenceType) {
            return this.distribution(cCCEVDocumentReferenceType == null ? null : DocumentReferencePojo.builder(cCCEVDocumentReferenceType));
        }

        @Nonnull
        public Builder creator(@Nullable Consumer<? super AgentPojo.Builder> consumer) {
            if (consumer != null) {
                AgentPojo.Builder builder = AgentPojo.builder();
                consumer.accept(builder);
                this.creator(builder);
            }
            return this;
        }

        @Nonnull
        public Builder creator(@Nullable AgentPojo.Builder builder) {
            return this.creator(builder == null ? null : builder.build());
        }

        @Nonnull
        public Builder creator(@Nullable AgentPojo agentPojo) {
            this.m_aCreator = agentPojo;
            return this;
        }

        @Nonnull
        public Builder creator(@Nullable AgentType agentType) {
            return this.creator(agentType == null ? null : AgentPojo.builder(agentType));
        }

        @Nonnull
        public Builder addID(@Nullable String string) {
            if (StringHelper.hasText((String)string)) {
                this.m_aIDs.add((Object)string);
            }
            return this;
        }

        @Nonnull
        public Builder id(@Nullable String string) {
            if (StringHelper.hasText((String)string)) {
                this.m_aIDs.set((Object)string);
            } else {
                this.m_aIDs.clear();
            }
            return this;
        }

        @Nonnull
        public Builder ids(String ... stringArray) {
            this.m_aIDs.setAll((Object[])stringArray);
            return this;
        }

        @Nonnull
        public Builder ids(@Nullable Iterable<String> iterable) {
            this.m_aIDs.setAll(iterable);
            return this;
        }

        @Nonnull
        public Builder issued(@Nullable XMLGregorianCalendar xMLGregorianCalendar) {
            return this.issued(PDTXMLConverter.getLocalDateTime((XMLGregorianCalendar)xMLGregorianCalendar));
        }

        @Nonnull
        public Builder issuedNow() {
            return this.issued(PDTFactory.getCurrentLocalDateTime());
        }

        @Nonnull
        public Builder issued(@Nullable LocalDateTime localDateTime) {
            this.m_aIssuedDT = localDateTime == null ? null : localDateTime.truncatedTo(ChronoUnit.MILLIS);
            return this;
        }

        @Nonnull
        public Builder language(@Nullable String string) {
            this.m_sLanguage = string;
            return this;
        }

        @Nonnull
        public Builder lastModified(@Nullable XMLGregorianCalendar xMLGregorianCalendar) {
            return this.lastModified(PDTXMLConverter.getLocalDateTime((XMLGregorianCalendar)xMLGregorianCalendar));
        }

        @Nonnull
        public Builder lastModifiedNow() {
            return this.lastModified(PDTFactory.getCurrentLocalDateTime());
        }

        @Nonnull
        public Builder lastModified(@Nullable LocalDateTime localDateTime) {
            this.m_aLastModifiedDT = localDateTime == null ? null : localDateTime.truncatedTo(ChronoUnit.MILLIS);
            return this;
        }

        @Nonnull
        public Builder validFrom(@Nullable XMLGregorianCalendar xMLGregorianCalendar) {
            return this.validFrom(PDTXMLConverter.getLocalDate((XMLGregorianCalendar)xMLGregorianCalendar));
        }

        @Nonnull
        public Builder validFrom(@Nullable LocalDate localDate) {
            this.m_aValidFrom = localDate;
            return this;
        }

        @Nonnull
        public Builder validTo(@Nullable XMLGregorianCalendar xMLGregorianCalendar) {
            return this.validTo(PDTXMLConverter.getLocalDate((XMLGregorianCalendar)xMLGregorianCalendar));
        }

        @Nonnull
        public Builder validTo(@Nullable LocalDate localDate) {
            this.m_aValidTo = localDate;
            return this;
        }

        @Nonnull
        public Builder addQualifiedRelation(@Nullable Consumer<? super QualifiedRelationPojo.Builder> consumer) {
            if (consumer != null) {
                QualifiedRelationPojo.Builder builder = QualifiedRelationPojo.builder();
                consumer.accept(builder);
                this.addQualifiedRelation(builder);
            }
            return this;
        }

        @Nonnull
        public Builder addQualifiedRelation(@Nullable QualifiedRelationPojo.Builder builder) {
            return this.addQualifiedRelation(builder == null ? null : builder.build());
        }

        @Nonnull
        public Builder addQualifiedRelation(@Nullable QualifiedRelationPojo qualifiedRelationPojo) {
            if (qualifiedRelationPojo != null) {
                this.m_aQualifiedRelations.add((Object)qualifiedRelationPojo);
            }
            return this;
        }

        @Nonnull
        public Builder addQualifiedRelation(@Nullable DCatAPRelationshipType dCatAPRelationshipType) {
            return this.addQualifiedRelation(dCatAPRelationshipType == null ? null : QualifiedRelationPojo.builder(dCatAPRelationshipType));
        }

        @Nonnull
        public Builder qualifiedRelation(@Nullable Consumer<? super QualifiedRelationPojo.Builder> consumer) {
            if (consumer != null) {
                QualifiedRelationPojo.Builder builder = QualifiedRelationPojo.builder();
                consumer.accept(builder);
                this.qualifiedRelation(builder);
            }
            return this;
        }

        @Nonnull
        public Builder qualifiedRelation(@Nullable QualifiedRelationPojo.Builder builder) {
            return this.qualifiedRelation(builder == null ? null : builder.build());
        }

        @Nonnull
        public Builder qualifiedRelation(@Nullable QualifiedRelationPojo qualifiedRelationPojo) {
            if (qualifiedRelationPojo != null) {
                this.m_aQualifiedRelations.set((Object)qualifiedRelationPojo);
            } else {
                this.m_aQualifiedRelations.clear();
            }
            return this;
        }

        @Nonnull
        public Builder qualifiedRelation(@Nullable DCatAPRelationshipType dCatAPRelationshipType) {
            return this.qualifiedRelation(dCatAPRelationshipType == null ? null : QualifiedRelationPojo.builder(dCatAPRelationshipType));
        }

        @Nonnull
        public Builder qualifiedRelations(QualifiedRelationPojo ... qualifiedRelationPojoArray) {
            this.m_aQualifiedRelations.setAll((Object[])qualifiedRelationPojoArray);
            return this;
        }

        @Nonnull
        public Builder qualifiedRelations(@Nullable Iterable<? extends QualifiedRelationPojo> iterable) {
            this.m_aQualifiedRelations.setAll(iterable);
            return this;
        }

        @Nonnull
        public DatasetPojo build() {
            return new DatasetPojo(this.m_aDescriptions, this.m_aTitles, this.m_aDistribution, this.m_aCreator, this.m_aIDs, this.m_aIssuedDT, this.m_sLanguage, this.m_aLastModifiedDT, this.m_aValidFrom, this.m_aValidTo, this.m_aQualifiedRelations);
        }
    }
}

