/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.edm.model;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.math.MathHelper;
import com.helger.commons.string.StringParser;
import com.helger.commons.string.ToStringGenerator;
import com.helger.datetime.util.PDTXMLConverter;
import com.helger.xsds.ccts.cct.schemamodule.TextType;
import eu.toop.edm.error.IToopErrorCode;
import eu.toop.edm.jaxb.cccev.CCCEVValueType;
import eu.toop.edm.model.AmountPojo;
import eu.toop.edm.model.MeasurePojo;
import eu.toop.edm.model.PeriodPojo;
import eu.toop.edm.model.QuantityPojo;
import eu.toop.edm.xml.cccev.CCCEVValueHelper;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URL;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.datatype.XMLGregorianCalendar;

public class ConceptValuePojo {
    private final String m_sIdentifier;
    private final AmountPojo m_aAmount;
    private final String m_sCode;
    private final LocalDate m_aDate;
    private final Boolean m_aIndicator;
    private final MeasurePojo m_aMeasure;
    private final BigDecimal m_aNumeric;
    private final PeriodPojo m_aPeriod;
    private final QuantityPojo m_aQuantity;
    private final ICommonsList<String> m_aText = new CommonsArrayList();
    private final LocalTime m_aTime;
    private final String m_sURI;
    private final String m_sErrorCode;

    public ConceptValuePojo(@Nullable String string, @Nullable AmountPojo amountPojo, @Nullable String string2, @Nullable LocalDate localDate, @Nullable Boolean bl, @Nullable MeasurePojo measurePojo, @Nullable BigDecimal bigDecimal, @Nullable PeriodPojo periodPojo, @Nullable QuantityPojo quantityPojo, @Nullable List<String> list, @Nullable LocalTime localTime, @Nullable String string3, @Nullable String string4) {
        this.m_sIdentifier = string;
        this.m_aAmount = amountPojo;
        this.m_sCode = string2;
        this.m_aDate = localDate;
        this.m_aIndicator = bl;
        this.m_aMeasure = measurePojo;
        this.m_aNumeric = bigDecimal;
        this.m_aPeriod = periodPojo;
        this.m_aQuantity = quantityPojo;
        if (list != null) {
            this.m_aText.addAll(list);
        }
        this.m_aTime = localTime;
        this.m_sURI = string3;
        this.m_sErrorCode = string4;
    }

    @Nullable
    public final String getIdentifier() {
        return this.m_sIdentifier;
    }

    @Nullable
    public final AmountPojo getAmount() {
        return this.m_aAmount;
    }

    @Nullable
    public final String getCode() {
        return this.m_sCode;
    }

    @Nullable
    public final LocalDate getDate() {
        return this.m_aDate;
    }

    @Nullable
    public final Boolean getBoolean() {
        return this.m_aIndicator;
    }

    @Nullable
    public final MeasurePojo getMeasure() {
        return this.m_aMeasure;
    }

    @Nullable
    public final BigDecimal getNumeric() {
        return this.m_aNumeric;
    }

    @Nullable
    public final PeriodPojo getPeriod() {
        return this.m_aPeriod;
    }

    @Nullable
    public final QuantityPojo getQuantity() {
        return this.m_aQuantity;
    }

    @Nonnull
    @ReturnsMutableCopy
    public final List<String> text() {
        return this.m_aText;
    }

    @Nonnull
    @ReturnsMutableCopy
    public final List<String> getAllTexts() {
        return (List)this.m_aText.getClone();
    }

    @Nullable
    public final LocalTime getTime() {
        return this.m_aTime;
    }

    @Nullable
    public final String getURI() {
        return this.m_sURI;
    }

    @Nullable
    public final String getErrorCode() {
        return this.m_sErrorCode;
    }

    @Nullable
    public CCCEVValueType getAsCCCEVValueType() {
        if (this.m_sIdentifier != null) {
            return CCCEVValueHelper.createID(this.m_sIdentifier);
        }
        if (this.m_aAmount != null) {
            return CCCEVValueHelper.create(this.m_aAmount.getAsAmount());
        }
        if (this.m_sCode != null) {
            return CCCEVValueHelper.createCode(this.m_sCode);
        }
        if (this.m_aDate != null) {
            return CCCEVValueHelper.create(this.m_aDate);
        }
        if (this.m_aIndicator != null) {
            return CCCEVValueHelper.create(this.m_aIndicator);
        }
        if (this.m_aMeasure != null) {
            return CCCEVValueHelper.create(this.m_aMeasure.getAsMeasure());
        }
        if (this.m_aNumeric != null) {
            return CCCEVValueHelper.create(this.m_aNumeric);
        }
        if (this.m_aPeriod != null) {
            return CCCEVValueHelper.create(this.m_aPeriod.getAsPeriod());
        }
        if (this.m_aQuantity != null) {
            return CCCEVValueHelper.create(this.m_aQuantity.getAsQuantity());
        }
        if (this.m_aText.isNotEmpty()) {
            return CCCEVValueHelper.createText(this.m_aText);
        }
        if (this.m_aTime != null) {
            return CCCEVValueHelper.create(this.m_aTime);
        }
        if (this.m_sURI != null) {
            return CCCEVValueHelper.createURI(this.m_sURI);
        }
        if (this.m_sErrorCode != null) {
            return CCCEVValueHelper.createError(this.m_sErrorCode);
        }
        return null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ConceptValuePojo conceptValuePojo = (ConceptValuePojo)object;
        return EqualsHelper.equals((Object)this.m_sIdentifier, (Object)conceptValuePojo.m_sIdentifier) && EqualsHelper.equals((Object)this.m_aAmount, (Object)conceptValuePojo.m_aAmount) && EqualsHelper.equals((Object)this.m_sCode, (Object)conceptValuePojo.m_sCode) && EqualsHelper.equals((Object)this.m_aDate, (Object)conceptValuePojo.m_aDate) && EqualsHelper.equals((Object)this.m_aIndicator, (Object)conceptValuePojo.m_aIndicator) && EqualsHelper.equals((Object)this.m_aMeasure, (Object)conceptValuePojo.m_aMeasure) && EqualsHelper.equals((Object)this.m_aNumeric, (Object)conceptValuePojo.m_aNumeric) && EqualsHelper.equals((Object)this.m_aPeriod, (Object)conceptValuePojo.m_aPeriod) && EqualsHelper.equals((Object)this.m_aQuantity, (Object)conceptValuePojo.m_aQuantity) && EqualsHelper.equals(this.m_aText, conceptValuePojo.m_aText) && EqualsHelper.equals((Object)this.m_aTime, (Object)conceptValuePojo.m_aTime) && EqualsHelper.equals((Object)this.m_sURI, (Object)conceptValuePojo.m_sURI) && EqualsHelper.equals((Object)this.m_sErrorCode, (Object)conceptValuePojo.m_sErrorCode);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sIdentifier).append((Object)this.m_aAmount).append((Object)this.m_sCode).append((Object)this.m_aDate).append((Object)this.m_aIndicator).append((Object)this.m_aMeasure).append((Object)this.m_aNumeric).append((Object)this.m_aPeriod).append((Object)this.m_aQuantity).append(this.m_aText).append((Object)this.m_aTime).append((Object)this.m_sURI).append((Object)this.m_sErrorCode).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).appendIfNotNull("Identifier", (Object)this.m_sIdentifier).appendIfNotNull("Amount", (Object)this.m_aAmount).appendIfNotNull("Code", (Object)this.m_sCode).appendIfNotNull("Date", (Object)this.m_aDate).appendIfNotNull("Indicator", (Object)this.m_aIndicator).appendIfNotNull("Measure", (Object)this.m_aMeasure).appendIfNotNull("Numeric", (Object)this.m_aNumeric).appendIfNotNull("Period", (Object)this.m_aPeriod).appendIfNotNull("Quantity", (Object)this.m_aQuantity).appendIfNotNull("Text", this.m_aText).appendIfNotNull("Time", (Object)this.m_aTime).appendIfNotNull("URI", (Object)this.m_sURI).appendIfNotNull("ErrorCode", (Object)this.m_sErrorCode).getToString();
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @Nonnull
    public static Builder builder(@Nullable CCCEVValueType cCCEVValueType) {
        Builder builder = new Builder();
        if (cCCEVValueType != null) {
            builder.identifier(cCCEVValueType.getIdentifierValueValue()).amount(cCCEVValueType.getAmountValue() == null ? null : AmountPojo.builder(cCCEVValueType.getAmountValue())).code(cCCEVValueType.getCodeValueValue()).date(cCCEVValueType.getDateValueValue()).indicator(cCCEVValueType.getIndicatorValue() == null ? null : StringParser.parseBoolObj((String)cCCEVValueType.getIndicatorValue().getValue())).measure(cCCEVValueType.getMeasureValue() == null ? null : MeasurePojo.builder(cCCEVValueType.getMeasureValue())).numeric(cCCEVValueType.getNumericValueValue()).period(cCCEVValueType.getPeriodValue() == null ? null : PeriodPojo.builder(cCCEVValueType.getPeriodValue()).build()).quantity(cCCEVValueType.getQuantityValue() == null ? null : QuantityPojo.builder(cCCEVValueType.getQuantityValue())).text((Collection<String>)new CommonsArrayList(cCCEVValueType.getTextValue(), TextType::getValue)).time(cCCEVValueType.getTimeValueValue()).uri(cCCEVValueType.getUriValueValue()).errorCode(cCCEVValueType.getErrorValue());
        }
        return builder;
    }

    public static class Builder {
        private String m_sIdentifier;
        private AmountPojo m_aAmount;
        private String m_sCode;
        private LocalDate m_aDate;
        private Boolean m_aIndicator;
        private MeasurePojo m_aMeasure;
        private BigDecimal m_aNumeric;
        private PeriodPojo m_aPeriod;
        private QuantityPojo m_aQuantity;
        private final ICommonsList<String> m_aText = new CommonsArrayList();
        private LocalTime m_aTime;
        private String m_sURI;
        private String m_sErrorCode;

        @Nonnull
        public Builder identifier(@Nullable String string) {
            this.m_sIdentifier = string;
            return this;
        }

        @Nonnull
        public Builder amount(@Nullable Consumer<? super AmountPojo.Builder> consumer) {
            if (consumer != null) {
                AmountPojo.Builder builder = AmountPojo.builder();
                consumer.accept(builder);
                this.amount(builder);
            }
            return this;
        }

        @Nonnull
        public Builder amount(@Nullable BigDecimal bigDecimal, @Nullable String string) {
            return this.amount(new AmountPojo(bigDecimal, string));
        }

        @Nonnull
        public Builder amount(@Nullable AmountPojo.Builder builder) {
            return this.amount(builder == null ? null : builder.build());
        }

        @Nonnull
        public Builder amount(@Nullable AmountPojo amountPojo) {
            this.m_aAmount = amountPojo;
            return this;
        }

        @Nonnull
        public Builder code(@Nullable String string) {
            this.m_sCode = string;
            return this;
        }

        @Nonnull
        public Builder date(@Nullable XMLGregorianCalendar xMLGregorianCalendar) {
            return this.date(PDTXMLConverter.getLocalDate((XMLGregorianCalendar)xMLGregorianCalendar));
        }

        @Nonnull
        public Builder date(@Nullable LocalDate localDate) {
            this.m_aDate = localDate;
            return this;
        }

        @Nonnull
        public Builder indicator(boolean bl) {
            return this.indicator((Boolean)bl);
        }

        @Nonnull
        public Builder indicator(@Nullable Boolean bl) {
            this.m_aIndicator = bl;
            return this;
        }

        @Nonnull
        public Builder measure(@Nullable BigDecimal bigDecimal, @Nullable String string) {
            return this.measure(new MeasurePojo(bigDecimal, string));
        }

        @Nonnull
        public Builder measure(@Nullable Consumer<? super MeasurePojo.Builder> consumer) {
            if (consumer != null) {
                MeasurePojo.Builder builder = MeasurePojo.builder();
                consumer.accept(builder);
                this.measure(builder);
            }
            return this;
        }

        @Nonnull
        public Builder measure(@Nullable MeasurePojo.Builder builder) {
            return this.measure(builder == null ? null : builder.build());
        }

        @Nonnull
        public Builder measure(@Nullable MeasurePojo measurePojo) {
            this.m_aMeasure = measurePojo;
            return this;
        }

        @Nonnull
        public Builder numeric(long l) {
            return this.numeric(MathHelper.toBigDecimal((long)l));
        }

        @Nonnull
        public Builder numeric(double d) {
            return this.numeric(MathHelper.toBigDecimal((double)d));
        }

        @Nonnull
        public Builder numeric(@Nullable BigDecimal bigDecimal) {
            this.m_aNumeric = bigDecimal;
            return this;
        }

        @Nonnull
        public Builder period(@Nullable LocalDateTime localDateTime, @Nullable LocalDateTime localDateTime2) {
            return this.period(PeriodPojo.builder().startDateTime(localDateTime).endDateTime(localDateTime2));
        }

        @Nonnull
        public Builder period(@Nullable Consumer<? super PeriodPojo.Builder> consumer) {
            if (consumer != null) {
                PeriodPojo.Builder builder = PeriodPojo.builder();
                consumer.accept(builder);
                this.period(builder);
            }
            return this;
        }

        @Nonnull
        public Builder period(@Nullable PeriodPojo.Builder builder) {
            return this.period(builder == null ? null : builder.build());
        }

        @Nonnull
        public Builder period(@Nullable PeriodPojo periodPojo) {
            this.m_aPeriod = periodPojo;
            return this;
        }

        @Nonnull
        public Builder quantity(@Nullable BigDecimal bigDecimal, @Nullable String string) {
            return this.quantity(new QuantityPojo(bigDecimal, string));
        }

        @Nonnull
        public Builder quantity(@Nullable Consumer<? super QuantityPojo.Builder> consumer) {
            if (consumer != null) {
                QuantityPojo.Builder builder = QuantityPojo.builder();
                consumer.accept(builder);
                this.quantity(builder);
            }
            return this;
        }

        @Nonnull
        public Builder quantity(@Nullable QuantityPojo.Builder builder) {
            return this.quantity(builder == null ? null : builder.build());
        }

        @Nonnull
        public Builder quantity(@Nullable QuantityPojo quantityPojo) {
            this.m_aQuantity = quantityPojo;
            return this;
        }

        @Nonnull
        public Builder text(String ... stringArray) {
            this.m_aText.setAll((Object[])stringArray);
            return this;
        }

        @Nonnull
        public Builder text(@Nullable Collection<String> collection) {
            this.m_aText.setAll(collection);
            return this;
        }

        @Nonnull
        public Builder time(@Nullable XMLGregorianCalendar xMLGregorianCalendar) {
            return this.time(PDTXMLConverter.getLocalTime((XMLGregorianCalendar)xMLGregorianCalendar));
        }

        @Nonnull
        public Builder time(@Nullable LocalTime localTime) {
            this.m_aTime = localTime == null ? null : localTime.truncatedTo(ChronoUnit.MILLIS);
            return this;
        }

        @Nonnull
        public Builder uri(@Nullable URI uRI) {
            return this.uri(uRI == null ? null : uRI.toString());
        }

        @Nonnull
        public Builder uri(@Nullable URL uRL) {
            return this.uri(uRL == null ? null : uRL.toExternalForm());
        }

        @Nonnull
        public Builder uri(@Nullable String string) {
            this.m_sURI = string;
            return this;
        }

        @Nonnull
        public Builder errorCode(@Nullable IToopErrorCode iToopErrorCode) {
            return this.errorCode(iToopErrorCode == null ? null : (String)iToopErrorCode.getID());
        }

        @Nonnull
        public Builder errorCode(@Nullable String string) {
            this.m_sErrorCode = string;
            return this;
        }

        public void checkConsistency() {
            int n = 0;
            if (this.m_sIdentifier != null) {
                ++n;
            }
            if (this.m_aAmount != null) {
                ++n;
            }
            if (this.m_sCode != null) {
                ++n;
            }
            if (this.m_aDate != null) {
                ++n;
            }
            if (this.m_aIndicator != null) {
                ++n;
            }
            if (this.m_aMeasure != null) {
                ++n;
            }
            if (this.m_aNumeric != null) {
                ++n;
            }
            if (this.m_aPeriod != null) {
                ++n;
            }
            if (this.m_aQuantity != null) {
                ++n;
            }
            if (this.m_aText.isNotEmpty()) {
                ++n;
            }
            if (this.m_aTime != null) {
                ++n;
            }
            if (this.m_sURI != null) {
                ++n;
            }
            if (this.m_sErrorCode != null) {
                ++n;
            }
            if (n == 0) {
                throw new IllegalStateException("No value was provided to the Concept Value");
            }
            if (n > 1) {
                throw new IllegalStateException("The Concept Value must have exactly one value");
            }
        }

        @Nonnull
        public ConceptValuePojo build() {
            this.checkConsistency();
            return new ConceptValuePojo(this.m_sIdentifier, this.m_aAmount, this.m_sCode, this.m_aDate, this.m_aIndicator, this.m_aMeasure, this.m_aNumeric, this.m_aPeriod, this.m_aQuantity, (List<String>)this.m_aText, this.m_aTime, this.m_sURI, this.m_sErrorCode);
        }
    }
}

